/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.alchemy;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.alchemy.AlchemyPotionHandlerComponent;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;

public class AlchemicalPotionCreationHandler {
    public static ArrayList<AlchemyPotionHandlerComponent> registeredPotionEffects = new ArrayList();

    public static void initializePotions() {
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151073_bk), Potion.field_76428_l.field_76415_H, 450);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151150_bK), Potion.field_76439_r.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151064_bs), Potion.field_76426_n.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151131_as), Potion.field_76427_o.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151102_aT), Potion.field_76424_c.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151060_bw), Potion.field_76432_h.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151070_bp), Potion.field_76436_u.field_76415_H, 450);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151071_bq), Potion.field_76437_t.field_76415_H, 450);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151065_br), Potion.field_76420_g.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(ModItems.aether), Potion.field_76430_j.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151119_aD), Potion.field_76421_d.field_76415_H, 450);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151137_ax), Potion.field_76422_e.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack((Item)Items.field_151068_bn, 1, 0), AlchemicalWizardry.customPotionDrowning.field_76415_H, 450);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151069_bo), Potion.field_76441_p.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151045_i), Potion.field_76429_m.field_76415_H, 2400);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151170_bI), Potion.field_76443_y.field_76415_H, 2);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(ModItems.demonBloodShard), Potion.field_76434_w.field_76415_H, 4800);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(ModItems.weakBloodShard), Potion.field_76444_x.field_76415_H, 4800);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(ModItems.terrae), AlchemicalWizardry.customPotionBoost.field_76415_H, 1200);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151008_G), AlchemicalWizardry.customPotionFlight.field_76415_H, 1200);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151032_g), AlchemicalWizardry.customPotionReciprocation.field_76415_H, 1200);
        AlchemicalPotionCreationHandler.addPotion(new ItemStack(Items.field_151079_bi), AlchemicalWizardry.customPotionPlanarBinding.field_76415_H, 1200);
    }

    public static void addPotion(ItemStack itemStack, int potionID, int tickDuration) {
        registeredPotionEffects.add(new AlchemyPotionHandlerComponent(itemStack, potionID, tickDuration));
    }

    public static int getPotionIDForStack(ItemStack itemStack) {
        for (AlchemyPotionHandlerComponent aphc : registeredPotionEffects) {
            if (!aphc.compareItemStack(itemStack)) continue;
            return aphc.getPotionID();
        }
        return -1;
    }

    public static int getPotionTickDurationForStack(ItemStack itemStack) {
        for (AlchemyPotionHandlerComponent aphc : registeredPotionEffects) {
            if (!aphc.compareItemStack(itemStack)) continue;
            return aphc.getTickDuration();
        }
        return -1;
    }

    public static boolean containsRegisteredPotionIngredient(ItemStack[] stackList) {
        for (ItemStack is : stackList) {
            for (AlchemyPotionHandlerComponent aphc : registeredPotionEffects) {
                if (!aphc.compareItemStack(is)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getRegisteredPotionIngredientPosition(ItemStack[] stackList) {
        int i = 0;
        for (ItemStack is : stackList) {
            for (AlchemyPotionHandlerComponent aphc : registeredPotionEffects) {
                if (!aphc.compareItemStack(is)) continue;
                return i;
            }
            ++i;
        }
        return -1;
    }
}

