/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.configuration.structures;

import biomesoplenty.api.BOPBiomeHelper;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class BOPConfigurationVillages {
    public static Configuration config;
    public static int villageDistance;
    public static ArrayList<String> enabledBiomes;

    public static void addDefaultVillageBiomes() {
        BOPConfigurationVillages.addVillageBiome("alps");
        BOPConfigurationVillages.addVillageBiome("arctic");
        BOPConfigurationVillages.addVillageBiome("bambooForest");
        BOPConfigurationVillages.addVillageBiome("bayou");
        BOPConfigurationVillages.addVillageBiome("bog");
        BOPConfigurationVillages.addVillageBiome("borealForest");
        BOPConfigurationVillages.addVillageBiome("brushland");
        BOPConfigurationVillages.addVillageBiome("canyon");
        BOPConfigurationVillages.addVillageBiome("chaparral");
        BOPConfigurationVillages.addVillageBiome("cherryBlossomGrove");
        BOPConfigurationVillages.addVillageBiome("coniferousForest");
        BOPConfigurationVillages.addVillageBiome("snowyConiferousForest");
        BOPConfigurationVillages.addVillageBiome("deadForest");
        BOPConfigurationVillages.addVillageBiome("deadSwamp");
        BOPConfigurationVillages.addVillageBiome("deciduousForest");
        BOPConfigurationVillages.addVillageBiome("dunes");
        BOPConfigurationVillages.addVillageBiome("fen");
        BOPConfigurationVillages.addVillageBiome("flowerField");
        BOPConfigurationVillages.addVillageBiome("frostForest");
        BOPConfigurationVillages.addVillageBiome("grassland");
        BOPConfigurationVillages.addVillageBiome("grove");
        BOPConfigurationVillages.addVillageBiome("heathland");
        BOPConfigurationVillages.addVillageBiome("highland");
        BOPConfigurationVillages.addVillageBiome("jadeCliffs");
        BOPConfigurationVillages.addVillageBiome("lushDesert");
        BOPConfigurationVillages.addVillageBiome("lushSwamp");
        BOPConfigurationVillages.addVillageBiome("mapleWoods");
        BOPConfigurationVillages.addVillageBiome("marsh");
        BOPConfigurationVillages.addVillageBiome("meadow");
        BOPConfigurationVillages.addVillageBiome("moor");
        BOPConfigurationVillages.addVillageBiome("mountain");
        BOPConfigurationVillages.addVillageBiome("outback");
        BOPConfigurationVillages.addVillageBiome("pasture");
        BOPConfigurationVillages.addVillageBiome("prairie");
        BOPConfigurationVillages.addVillageBiome("quagmire");
        BOPConfigurationVillages.addVillageBiome("rainforest");
        BOPConfigurationVillages.addVillageBiome("redwoodForest");
        BOPConfigurationVillages.addVillageBiome("seasonalForest");
        BOPConfigurationVillages.addVillageBiome("shield");
        BOPConfigurationVillages.addVillageBiome("shrubland");
        BOPConfigurationVillages.addVillageBiome("sludgepit");
        BOPConfigurationVillages.addVillageBiome("spruceWoods");
        BOPConfigurationVillages.addVillageBiome("temperateRainforest");
        BOPConfigurationVillages.addVillageBiome("thicket");
        BOPConfigurationVillages.addVillageBiome("timber");
        BOPConfigurationVillages.addVillageBiome("tropicalRainforest");
        BOPConfigurationVillages.addVillageBiome("tropics");
        BOPConfigurationVillages.addVillageBiome("tundra");
        BOPConfigurationVillages.addVillageBiome("volcano");
        BOPConfigurationVillages.addVillageBiome("wetland");
        BOPConfigurationVillages.addVillageBiome("woodland");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        BOPConfigurationVillages.addDefaultVillageBiomes();
        config = new Configuration(configFile);
        try {
            config.load();
            villageDistance = config.get("Biomes O' Plenty World Type Settings", "Distance between villages", 32, "In Vanilla it is set to 32").getInt();
            if (villageDistance < 8) {
                villageDistance = 8;
            }
            for (BOPBiomeHelper.BOPBiomeEntry entry : BOPBiomeHelper.biomeLists[1].values()) {
                BiomeGenBase biome = entry.biome;
                String name = biome.field_76791_y;
                String convertedName = BOPBiomeHelper.convertBiomeName(name);
                if (!config.get("Allow Villages", name, enabledBiomes.contains(convertedName)).getBoolean(enabledBiomes.contains(convertedName))) continue;
                BiomeManager.addVillageBiome((BiomeGenBase)biome, (boolean)true);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (String)"Biomes O Plenty has had a problem loading its configuration", (Object[])new Object[]{e});
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static void addVillageBiome(String biomeName) {
        enabledBiomes.add(biomeName);
    }

    static {
        enabledBiomes = new ArrayList();
    }
}

