/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.features;

import biomesoplenty.common.world.decoration.BOPDecorationManager;
import biomesoplenty.common.world.generation.WorldGeneratorBOP;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class WorldGenWaterside
extends WorldGeneratorBOP {
    private List sideBlocks;
    private Block watersideBlock;
    private int radius;

    public WorldGenWaterside(Block watersideBlock, int radius, Block ... sideBlocks) {
        super(true);
        this.watersideBlock = watersideBlock;
        this.radius = radius;
        this.sideBlocks = Arrays.asList(sideBlocks);
    }

    @Override
    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o() != Material.field_151586_h) {
            return false;
        }
        int l = random.nextInt(this.radius - 2) + 2;
        int b0 = 2;
        for (int i1 = x - l; i1 <= x + l; ++i1) {
            for (int j1 = z - l; j1 <= z + l; ++j1) {
                int k1 = i1 - x;
                int l1 = j1 - z;
                if (k1 * k1 + l1 * l1 > l * l) continue;
                for (int i2 = y - b0; i2 <= y + b0; ++i2) {
                    Block block = world.func_147439_a(i1, i2, j1);
                    if (!this.sideBlocks.contains(block)) continue;
                    world.func_147465_d(i1, i2, j1, this.watersideBlock, 0, 2);
                }
            }
        }
        return true;
    }

    @Override
    public void setupGeneration(World world, Random random, BiomeGenBase biome, String featureName, int x, int z) {
        for (int i = 0; i < (Integer)BOPDecorationManager.getBiomeFeatures(biome.field_76756_M).getFeature(featureName); ++i) {
            int randX = x + random.nextInt(16) + 8;
            int randZ = z + random.nextInt(16) + 8;
            this.func_76484_a(world, random, randX, world.func_72825_h(randX, randZ), randZ);
        }
    }
}

