/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.BOPBlockHelper;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockBOPColorizedLeaves
extends BlockLeavesBase
implements IShearable {
    private static final String[] leaves = new String[]{"sacredoak", "mangrove", "palm", "redwood", "willow", "pine", "mahogany"};
    private IIcon[][] textures;
    private final ColourizedLeafCategory category;
    int[] adjacentTreeBlocks;

    public BlockBOPColorizedLeaves(ColourizedLeafCategory cat) {
        super(Material.field_151584_j, false);
        this.category = cat;
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149713_g(1);
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[3][leaves.length];
        if (Loader.isModLoaded((String)"BetterGrassAndLeavesMod")) {
            for (int i = 0; i < leaves.length; ++i) {
                this.textures[0][i] = iconRegister.func_94245_a("biomesoplenty:leaves_" + leaves[i] + "_round");
                this.textures[1][i] = iconRegister.func_94245_a("biomesoplenty:leaves_" + leaves[i] + "_fast");
                this.textures[2][i] = iconRegister.func_94245_a("biomesoplenty:better_leaves_" + leaves[i]);
            }
        } else {
            for (int i = 0; i < leaves.length; ++i) {
                this.textures[0][i] = iconRegister.func_94245_a("biomesoplenty:leaves_" + leaves[i] + "_fancy");
                this.textures[1][i] = iconRegister.func_94245_a("biomesoplenty:leaves_" + leaves[i] + "_fast");
            }
        }
    }

    public IIcon getIconBetterLeaves(int metadata, float randomIndex) {
        int type = BlockBOPColorizedLeaves.getTypeFromMeta(metadata) + this.category.ordinal() * 4;
        return this.textures[2][type >= leaves.length ? 0 : type];
    }

    public IIcon getIconFallingLeaves(int metadata) {
        int type = BlockBOPColorizedLeaves.getTypeFromMeta(metadata) + this.category.ordinal() * 4;
        return this.textures[1][type >= leaves.length ? 0 : type];
    }

    public int func_149635_D() {
        double temperature = 0.5;
        double humidity = 1.0;
        return ColorizerFoliage.func_77470_a((double)temperature, (double)humidity);
    }

    public int func_149741_i(int par1) {
        switch (par1) {
            default: 
        }
        return ColorizerFoliage.func_77468_c();
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int var6 = 0;
        int var7 = 0;
        int var8 = 0;
        for (int var9 = -1; var9 <= 1; ++var9) {
            for (int var10 = -1; var10 <= 1; ++var10) {
                int var11 = world.func_72807_a(x + var10, z + var9).func_150571_c(x + var10, y, z + var9);
                var6 += (var11 & 0xFF0000) >> 16;
                var7 += (var11 & 0xFF00) >> 8;
                var8 += var11 & 0xFF;
            }
        }
        return (var6 / 9 & 0xFF) << 16 | (var7 / 9 & 0xFF) << 8 | var8 / 9 & 0xFF;
    }

    public IIcon func_149691_a(int side, int metadata) {
        int type = BlockBOPColorizedLeaves.getTypeFromMeta(metadata) + this.category.ordinal() * 4;
        return this.textures[!this.func_149662_c() ? 0 : 1][type >= leaves.length ? 0 : type];
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 4; ++i) {
            if (this.category == ColourizedLeafCategory.CAT2 && i >= 3) continue;
            list.add(new ItemStack(block, 1, i));
        }
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (world.func_72951_B(x, y + 1, z) && !World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && random.nextInt(15) == 1) {
            double d0 = (float)x + random.nextFloat();
            double d1 = (double)y - 0.05;
            double d2 = (float)z + random.nextFloat();
            world.func_72869_a("dripWater", d0, d1, d2, 0.0, 0.0, 0.0);
        }
        super.func_149734_b(world, x, y, z, random);
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        int radius = 1;
        int bounds = radius + 1;
        if (world.func_72904_c(x - bounds, y - bounds, z - bounds, x + bounds, y + bounds, z + bounds)) {
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        Block block = world.func_147439_a(x + i, y + j, z + k);
                        if (!block.isLeaves((IBlockAccess)world, x, y, z)) continue;
                        block.beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) != 0 && (meta & 4) == 0) {
            int l1;
            int b0 = 4;
            int i1 = b0 + 1;
            int b1 = 32;
            int j1 = b1 * b1;
            int k1 = b1 / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[b1 * b1 * b1];
            }
            if (world.func_72904_c(x - i1, y - i1, z - i1, x + i1, y + i1, z + i1)) {
                int j2;
                int i2;
                for (l1 = -b0; l1 <= b0; ++l1) {
                    for (i2 = -b0; i2 <= b0; ++i2) {
                        for (j2 = -b0; j2 <= b0; ++j2) {
                            Block block = world.func_147439_a(x + l1, y + i2, z + j2);
                            this.adjacentTreeBlocks[(l1 + k1) * j1 + (i2 + k1) * b1 + j2 + k1] = block != null && block.canSustainLeaves((IBlockAccess)world, x + l1, y + i2, z + j2) ? 0 : (block != null && block.isLeaves((IBlockAccess)world, x + l1, y + i2, z + j2) ? -2 : -1);
                        }
                    }
                }
                for (l1 = 1; l1 <= 4; ++l1) {
                    for (i2 = -b0; i2 <= b0; ++i2) {
                        for (j2 = -b0; j2 <= b0; ++j2) {
                            for (int k2 = -b0; k2 <= b0; ++k2) {
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1] != l1 - 1) continue;
                                if (this.adjacentTreeBlocks[(i2 + k1 - 1) * j1 + (j2 + k1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1 - 1) * j1 + (j2 + k1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1 + 1) * j1 + (j2 + k1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1 + 1) * j1 + (j2 + k1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 - 1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 - 1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 + 1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 + 1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + (k2 + k1 - 1)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + (k2 + k1 - 1)] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1 + 1] != -2) continue;
                                this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1 + 1] = l1;
                            }
                        }
                    }
                }
            }
            if ((l1 = this.adjacentTreeBlocks[k1 * j1 + k1 * b1 + k1]) >= 0) {
                world.func_72921_c(x, y, z, meta & 0xFFFFFFF7, 4);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return Item.func_150898_a((Block)BOPBlockHelper.get("colorizedSaplings"));
    }

    public int func_149692_a(int meta) {
        return BlockBOPColorizedLeaves.getTypeFromMeta(meta) + this.category.ordinal() * 4;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return BlockBOPColorizedLeaves.getTypeFromMeta(world.func_72805_g(x, y, z));
    }

    public int func_149745_a(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, BlockBOPColorizedLeaves.getTypeFromMeta(world.func_72805_g(x, y, z))));
        return ret;
    }

    public String getLeafType(int metadata) {
        int type = BlockBOPColorizedLeaves.getTypeFromMeta(metadata) + this.category.ordinal() * 4;
        return leaves[type >= leaves.length ? 0 : type];
    }

    private static int getTypeFromMeta(int meta) {
        if ((meta &= 3) < 0 || meta >= leaves.length) {
            meta = 0;
        }
        return meta;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 4);
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public static enum ColourizedLeafCategory {
        CAT1,
        CAT2,
        CAT3,
        CAT4;

    }
}

