/*
 * Decompiled with CFR 0.152.
 */
package bwg4.world.generators;

import bwg4.deco.old.OldGenBigTree;
import bwg4.deco.old.OldGenTrees;
import bwg4.map.MapGenBWG4;
import bwg4.map.MapGenBWG4Caves;
import bwg4.util.PerlinNoise;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class ChunkGeneratorWasteland
implements IChunkProvider {
    private Random rand;
    private World worldObj;
    private double[] noiseField;
    private double[] netherrackExclusivityNoise = new double[256];
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private final boolean mapFeaturesEnabled;
    private MapGenBWG4 cavegen;
    public PerlinNoise cavenoise_top;
    public PerlinNoise cavenoise_1;
    public PerlinNoise cavenoise_2;
    public PerlinNoise cavenoise_3;

    public ChunkGeneratorWasteland(World par1World, long par2, boolean par4) {
        this.worldObj = par1World;
        this.rand = new Random(par2);
        this.mapFeaturesEnabled = par4;
        this.cavegen = new MapGenBWG4Caves();
        this.cavenoise_top = new PerlinNoise(par2 + 1L);
        this.cavenoise_1 = new PerlinNoise(par2 + 2L);
        this.cavenoise_2 = new PerlinNoise(par2 + 3L);
        this.cavenoise_3 = new PerlinNoise(par2 + 4L);
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Block[] blocks = new Block[32768];
        this.generateWorld(par1, par2, blocks);
        this.replaceBlocks(par1, par2, blocks);
        this.cavegen.generate(this, this.worldObj, par1, par2, blocks);
        if (this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, blocks);
        }
        Chunk var4 = new Chunk(this.worldObj, blocks, par1, par2);
        BiomeGenBase[] var5 = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, par1 * 16, par2 * 16, 16, 16);
        byte[] var6 = var4.func_76605_m();
        for (int var7 = 0; var7 < var6.length; ++var7) {
            var6[var7] = (byte)var5[var7].field_76756_M;
        }
        var4.func_76613_n();
        return var4;
    }

    public void generateWorld(int par1, int par2, Block[] blocks) {
        int var5 = 48;
        int i = par1 << 4;
        int j = par2 << 4;
        int jj = 0;
        boolean p = false;
        for (int k = i; k < i + 16; ++k) {
            for (int m = j; m < j + 16; ++m) {
                float b = this.cavenoise_2.turbulence2((float)k / 500.0f, (float)m / 500.0f, 5.0f) * 25.0f;
                float strength = 1.6f + this.cavenoise_1.turbulence2((float)k / 300.0f, (float)m / 300.0f, 5.0f) * 2.0f;
                if (strength < 0.5f) {
                    strength = 0.5f;
                }
                for (int i3 = 0; i3 < 128; ++i3) {
                    float s = (float)i3 < b + 80.0f - 20.0f * strength ? -1.0f : ((float)i3 > b + 80.0f + 20.0f * strength ? 1.0f : (float)(i3 - 80) + b + this.cavenoise_3.turbulence3((float)k / 30.0f, (float)i3 / 30.0f, (float)m / 30.0f, 3.0f) * (15.0f * strength) + this.cavenoise_3.turbulence3((float)k / 200.0f, (float)i3 / 200.0f, (float)m / 200.0f, 3.0f) * (25.0f * strength));
                    blocks[jj] = i3 == 0 ? Blocks.field_150357_h : (s < 0.0f ? Blocks.field_150348_b : (i3 > var5 ? Blocks.field_150350_a : Blocks.field_150355_j));
                    ++jj;
                }
            }
        }
    }

    public void replaceBlocks(int par1, int par2, Block[] par3ArrayOfByte) {
        int var5 = 48;
        double var6 = 0.03125;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var13 = 0;
                for (int var16 = 127; var16 >= 0; --var16) {
                    int var17 = (var9 * 16 + var8) * 128 + var16;
                    Block var18 = par3ArrayOfByte[var17];
                    if (var18 == Blocks.field_150350_a) {
                        var13 = 0;
                        continue;
                    }
                    if (var18 != Blocks.field_150348_b) continue;
                    if (var13 == 0) {
                        par3ArrayOfByte[var17] = Blocks.field_150346_d;
                    } else if (var13 > -1 && var13 < 4) {
                        par3ArrayOfByte[var17] = Blocks.field_150346_d;
                    }
                    ++var13;
                }
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockSand.field_149832_M = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        BiomeGenBase var6 = this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var77 = this.rand.nextLong() / 2L * 2L + 1L;
        long var99 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * var77 + (long)par3 * var99 ^ this.worldObj.func_72905_C());
        double d = 0.25;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.rand, par2, par3, false));
        if (this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
        }
        if (this.rand.nextInt(6) == 0) {
            int k15 = var4 + this.rand.nextInt(16) + 8;
            int k17 = this.rand.nextInt(40) + 40;
            int k20 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(this.worldObj, this.rand, k15, k17, k20);
        }
        if (this.rand.nextInt(6) == 0) {
            int l15 = var4 + this.rand.nextInt(16) + 8;
            int l17 = this.rand.nextInt(40) + 40;
            int l20 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(this.worldObj, this.rand, l15, l17, l20);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.rand, par2, par3, false));
        BlockSand.field_149832_M = false;
    }

    public WorldGenerator getRandomWorldGenForTrees(Random par1Random) {
        if (par1Random.nextInt(8) == 0) {
            return new OldGenBigTree(2);
        }
        if (par1Random.nextInt(18) == 0) {
            return new WorldGenTaiga1();
        }
        if (par1Random.nextInt(10) == 0) {
            return new WorldGenForest(false, false);
        }
        return new OldGenTrees(2);
    }

    public int getGrassPos(World world, int x, int z, int req) {
        int h = 0;
        for (int i = 105; i > 40; --i) {
            if (world.func_147439_a(x, i, z).func_149688_o() == Material.field_151577_b) {
                if (h < req) continue;
                return i + 1;
            }
            if (world.func_147439_a(x, i, z).func_149688_o() == Material.field_151579_a) {
                ++h;
                continue;
            }
            h = 0;
        }
        return -1;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_104112_b() {
    }

    public void func_82695_e(int par1, int par2) {
        if (this.mapFeaturesEnabled) {
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        }
    }
}

