/*
 * Decompiled with CFR 0.152.
 */
package bwg4.world.generators;

import bwg4.deco.DecoBigTree;
import bwg4.deco.DecoDungeons;
import bwg4.deco.DecoIsland;
import bwg4.deco.DecoSurvival;
import bwg4.deco.old.OldGenClay;
import bwg4.deco.old.OldGenMinable;
import bwg4.deco.old.OldGenTrees;
import bwg4.noise.NoiseOctavesBeta;
import bwg4.util.PerlinNoise;
import bwg4.util.TerrainMath;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class ChunkGeneratorIsland
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    public NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseOctavesBeta TreeNoise;
    private World world;
    private double[] densities;
    private BiomeGenBase[] biomesForGeneration;
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;
    int[][] field_73203_h = new int[32][32];
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    public int THEMEID = 1;
    public double width;
    public int height;
    public PerlinNoise perlin1;
    public PerlinNoise perlin2;
    public double volcanoX;
    public double volcanoY;

    public ChunkGeneratorIsland(World par1World, long par2, int theme, int s) {
        this.world = par1World;
        this.rand = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 16);
        this.TreeNoise = new NoiseOctavesBeta(this.rand, 8);
        this.THEMEID = theme;
        this.perlin1 = new PerlinNoise(par2);
        this.perlin2 = new PerlinNoise(par2 + 100L);
        if (this.THEMEID == 1) {
            switch (s) {
                case 1: {
                    this.width = 3.3;
                    this.height = 67;
                    break;
                }
                case 2: {
                    this.width = 5.0;
                    this.height = 68;
                    break;
                }
                case 3: {
                    this.width = 7.0;
                    this.height = 70;
                }
            }
        } else if (this.THEMEID == 2) {
            switch (s) {
                case 1: {
                    this.width = 3.3;
                    this.height = 72;
                    break;
                }
                case 2: {
                    this.width = 5.0;
                    this.height = 74;
                    break;
                }
                case 3: {
                    this.width = 6.5;
                    this.height = 76;
                }
            }
        } else if (this.THEMEID != 3) {
            if (this.THEMEID == 4) {
                switch (s) {
                    case 1: {
                        this.width = 2.5;
                        this.height = 5;
                        break;
                    }
                    case 2: {
                        this.width = 3.8;
                        this.height = 7;
                        break;
                    }
                    case 3: {
                        this.width = 4.9;
                        this.height = 10;
                    }
                }
            } else if (this.THEMEID == 5) {
                int dir = this.rand.nextInt(360);
                this.volcanoX = TerrainMath.nextX(0.0, dir, 150.0);
                this.volcanoY = TerrainMath.nextY(0.0, dir, 150.0);
            }
        }
    }

    public void generateTerrain(int par1, int par2, Block[] blocks, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        block49: {
            block50: {
                block48: {
                    if (this.THEMEID != 1) break block48;
                    int jj = 0;
                    int i = par1 << 4;
                    int j = par2 << 4;
                    for (int k = i; k < i + 16; ++k) {
                        for (int m = j; m < j + 16; ++m) {
                            float i2 = this.height;
                            if ((i2 = (float)((double)i2 - (Math.sqrt((0.0 - (double)k) * (0.0 - (double)k) + (0.0 - (double)m) * (0.0 - (double)m)) / this.width + (double)(this.perlin1.turbulence2((float)k / 60.0f, (float)m / 60.0f, 4.0f) * 5.0f)))) < 50.0f) {
                                i2 = 50.0f;
                            }
                            for (int i3 = 0; i3 < 256; ++i3) {
                                Block i4 = Blocks.field_150350_a;
                                if ((float)i3 < i2 - 6.0f + (float)this.rand.nextInt(3)) {
                                    i4 = Blocks.field_150348_b;
                                } else if ((float)i3 < i2 - 3.0f) {
                                    i4 = Blocks.field_150322_A;
                                } else if ((float)i3 < i2) {
                                    i4 = Blocks.field_150354_m;
                                } else if (i3 <= 64) {
                                    i4 = Blocks.field_150355_j;
                                }
                                blocks[jj++] = i4;
                            }
                        }
                    }
                    break block49;
                }
                if (this.THEMEID != 2) break block50;
                int jj = 0;
                int i = par1 << 4;
                int j = par2 << 4;
                for (int k = i; k < i + 16; ++k) {
                    for (int m = j; m < j + 16; ++m) {
                        float i2 = this.height;
                        if ((i2 = (float)((double)i2 - (Math.sqrt((0.0 - (double)k) * (0.0 - (double)k) + (0.0 - (double)m) * (0.0 - (double)m)) / this.width + (double)(this.perlin1.turbulence2((float)k / 60.0f, (float)m / 60.0f, 4.0f) * 5.0f)))) < 50.0f) {
                            i2 = 50.0f;
                        }
                        for (int i3 = 0; i3 < 256; ++i3) {
                            Block i4 = Blocks.field_150350_a;
                            if (i2 > 67.0f) {
                                if ((float)i3 < i2 - 3.0f) {
                                    i4 = Blocks.field_150348_b;
                                } else if ((float)i3 < i2 - 1.0f) {
                                    i4 = Blocks.field_150346_d;
                                } else if ((float)i3 < i2) {
                                    i4 = Blocks.field_150349_c;
                                }
                            } else if ((float)i3 < i2 - 6.0f + (float)this.rand.nextInt(3)) {
                                i4 = Blocks.field_150348_b;
                            } else if ((float)i3 < i2 - 3.0f) {
                                i4 = Blocks.field_150322_A;
                            } else if ((float)i3 < i2) {
                                i4 = Blocks.field_150354_m;
                            } else if (i3 <= 64) {
                                i4 = Blocks.field_150355_j;
                            }
                            blocks[jj++] = i4;
                        }
                    }
                }
                break block49;
            }
            if (this.THEMEID == 3) break block49;
            if (this.THEMEID == 4) {
                int jj = 0;
                int i = par1 << 4;
                int j = par2 << 4;
                for (int k = i; k < i + 16; ++k) {
                    for (int m = j; m < j + 16; ++m) {
                        float surface = this.height;
                        float dis = (float)(Math.sqrt((0.0 - (double)k) * (0.0 - (double)k) + (0.0 - (double)m) * (0.0 - (double)m)) / this.width);
                        surface -= dis + this.perlin1.turbulence2((float)k / 60.0f, (float)m / 60.0f, 4.0f) * 5.0f;
                        float ice = this.perlin2.turbulence2((float)k / 20.0f, (float)m / 20.0f, 4.0f) * 10.0f;
                        ice = 1.0f - 2.0f * (ice * ice);
                        for (int i3 = 0; i3 < 256; ++i3) {
                            Block i4 = Blocks.field_150350_a;
                            if (i3 < 63) {
                                i4 = Blocks.field_150355_j;
                            }
                            if (i3 == 63) {
                                i4 = ice < -1.0f ? Blocks.field_150432_aD : Blocks.field_150355_j;
                            }
                            if (surface > -1.0f && (float)i3 < surface + 65.0f && (float)i3 > -(surface * 8.0f) + 61.0f) {
                                i4 = Blocks.field_150433_aE;
                            }
                            blocks[jj++] = i4;
                        }
                    }
                }
            } else {
                int jj = 0;
                int i = par1 << 4;
                int j = par2 << 4;
                float volcanoground = 0.0f;
                float volcanoair = 0.0f;
                float volcanograss = 0.0f;
                for (int k = i; k < i + 16; ++k) {
                    for (int m = j; m < j + 16; ++m) {
                        int i1 = 0;
                        float dis = (float)Math.sqrt((0.0 - (double)k) * (0.0 - (double)k) + (0.0 - (double)m) * (0.0 - (double)m));
                        float stength = -0.33333334f * dis + 100.0f;
                        dis /= 7.0f;
                        float volcanodis = (float)TerrainMath.dis2(k, m, this.volcanoX, this.volcanoY) - 8.0f;
                        if (volcanodis + 8.0f < 100.0f) {
                            float noise = this.perlin2.turbulence2((float)k / 30.0f, (float)m / 30.0f, 4.0f) * 7.0f;
                            if (volcanodis > 0.0f) {
                                volcanoground = 128.0f + noise - volcanodis;
                                volcanoair = 128.0f + noise - volcanodis / 0.25f;
                                volcanograss = 165.0f + -noise * 2.0f - volcanodis / 0.5f;
                            } else {
                                volcanoair = 128.0f;
                                volcanoground = 128.0f;
                                volcanograss = 128.0f;
                            }
                        }
                        for (int i3 = 0; i3 < 256; ++i3) {
                            float n = 0.0f;
                            if (i3 > 50 && stength > 0.0f) {
                                n += this.perlin1.turbulence3((float)k / 90.0f, (float)m / 82.0f, (float)i3 / 90.0f, 4.0f) * stength;
                                n += this.perlin2.turbulence3((float)k / 40.0f, (float)m / 34.0f, (float)i3 / 40.0f, 4.0f) * (stength / 2.0f);
                            }
                            float i2 = (float)(-100 + i3 + i1) + n + dis;
                            Block i4 = Blocks.field_150350_a;
                            if (i2 > 0.0f) {
                                i4 = Blocks.field_150350_a;
                                if (i3 < 64) {
                                    i4 = Blocks.field_150355_j;
                                }
                            } else {
                                i4 = Blocks.field_150348_b;
                            }
                            if (i2 > -10.0f && (float)i3 < volcanoground) {
                                i4 = i2 > -8.0f && (float)i3 < volcanoair ? (i3 < 105 ? Blocks.field_150353_l : Blocks.field_150350_a) : ((float)i3 > volcanograss ? Blocks.field_150348_b : Blocks.field_150343_Z);
                            }
                            blocks[jj++] = i4;
                        }
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, Block[] blocks, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        for (int var5 = 0; var5 < 16; ++var5) {
            for (int var6 = 0; var6 < 16; ++var6) {
                int var7 = 1;
                int var8 = -1;
                Block var9 = Blocks.field_150354_m;
                Block var10 = Blocks.field_150354_m;
                for (int var11 = 255; var11 >= 0; --var11) {
                    int var12 = (var6 * 16 + var5) * 256 + var11;
                    if (var11 <= 0 + this.rand.nextInt(5)) {
                        blocks[var12] = Blocks.field_150357_h;
                        continue;
                    }
                    Block var13 = blocks[var12];
                    if (var13 == Blocks.field_150350_a) {
                        var8 = -1;
                        continue;
                    }
                    if (var13 != Blocks.field_150348_b && var13 != Blocks.field_150343_Z) continue;
                    if (var8 == -1) {
                        var9 = Blocks.field_150354_m;
                        var10 = Blocks.field_150354_m;
                        if (var11 > 66) {
                            var9 = Blocks.field_150349_c;
                            var10 = Blocks.field_150346_d;
                        }
                        if (var13 == Blocks.field_150343_Z) {
                            var9 = Blocks.field_150348_b;
                            var10 = Blocks.field_150348_b;
                        }
                        var8 = var7;
                        if (var11 >= 0) {
                            blocks[var12] = var9;
                            continue;
                        }
                        blocks[var12] = var10;
                        continue;
                    }
                    if (var8 <= 0) continue;
                    blocks[var12] = var10;
                    if (--var8 != 0 || var10 != Blocks.field_150354_m) continue;
                    var8 = this.rand.nextInt(4);
                    var10 = Blocks.field_150322_A;
                }
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Block[] var3 = new Block[65536];
        byte[] metadata = new byte[65536];
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.generateTerrain(par1, par2, var3, this.biomesForGeneration);
        if (this.THEMEID == 5) {
            this.replaceBlocksForBiome(par1, par2, var3, this.biomesForGeneration);
        }
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.world, par1, par2, var3);
        this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.world, par1, par2, var3);
        Chunk var4 = new Chunk(this.world, var3, metadata, par1, par2);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)this.biomesForGeneration[var6].field_76756_M;
        }
        var4.func_76603_b();
        return var4;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockSand.field_149832_M = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        BiomeGenBase var6 = this.world.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.world.func_72905_C());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * l1 + (long)par3 * l2 ^ this.world.func_72905_C());
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.world, this.rand, par2, par3, false));
        this.strongholdGenerator.func_75051_a(this.world, this.rand, par2, par3);
        double dis = Math.sqrt((0.0 - (double)var4) * (0.0 - (double)var4) + (0.0 - (double)var5) * (0.0 - (double)var5));
        int deco_clay = 0;
        int deco_flowerRed = 0;
        int deco_flowerYellow = 0;
        int deco_grass = 0;
        int deco_dungeon = 0;
        int deco_tree = 0;
        boolean mayrandtrees = false;
        int mintree = 0;
        int maxtree = 128;
        if (this.THEMEID == 1) {
            if (par2 == 0 && par3 == 0) {
                new DecoIsland(this.THEMEID).func_76484_a(this.world, this.rand, 0, this.world.func_72976_f(0, 0), 0);
                if (!new DecoDungeons(1, true).func_76484_a(this.world, this.rand, -15 + this.rand.nextInt(30), 40, -15 + this.rand.nextInt(30))) {
                    // empty if block
                }
                if (!new DecoDungeons(2, true).func_76484_a(this.world, this.rand, -15 + this.rand.nextInt(30), 20, -15 + this.rand.nextInt(30))) {
                    // empty if block
                }
            }
            deco_clay = 20;
            deco_dungeon = 20;
        } else if (this.THEMEID == 2) {
            if (par2 == 0 && par3 == 0) {
                new DecoIsland(this.THEMEID).func_76484_a(this.world, this.rand, 0, this.world.func_72976_f(0, 0), 0);
                if (!new DecoDungeons(1, true).func_76484_a(this.world, this.rand, -15 + this.rand.nextInt(30), 40, -15 + this.rand.nextInt(30))) {
                    // empty if block
                }
                if (!new DecoDungeons(2, true).func_76484_a(this.world, this.rand, -15 + this.rand.nextInt(30), 20, -15 + this.rand.nextInt(30))) {
                    // empty if block
                }
            }
            deco_clay = 20;
            deco_dungeon = 20;
            deco_flowerRed = 3;
            deco_flowerYellow = 3;
            deco_grass = 4;
            deco_tree = 10;
            mintree = 70;
        } else if (this.THEMEID != 3 && this.THEMEID != 4 && this.THEMEID == 5) {
            deco_clay = 20;
            deco_dungeon = 20;
            deco_flowerRed = 3;
            deco_flowerYellow = 3;
            deco_grass = 4;
            deco_tree = 10;
            deco_tree = dis < 65.0 ? 20 : (dis < 130.0 ? 15 : 10);
            mintree = 69;
        }
        for (int var42 = 0; var42 < deco_dungeon; ++var42) {
            int var68;
            int var67;
            int var66 = var4 + this.rand.nextInt(16) + 8;
            if (!new DecoDungeons().func_76484_a(this.world, this.rand, var66, var67 = this.rand.nextInt(128), var68 = var5 + this.rand.nextInt(16) + 8)) continue;
        }
        for (int i2 = 0; i2 < deco_clay; ++i2) {
            int k5 = var4 + this.rand.nextInt(16);
            int l8 = this.rand.nextInt(128);
            int k11 = var5 + this.rand.nextInt(16);
            new OldGenClay(32, 2).func_76484_a(this.world, this.rand, k5, l8, k11);
        }
        for (int j2 = 0; j2 < 16; ++j2) {
            int l5 = var4 + this.rand.nextInt(16);
            int i9 = this.rand.nextInt(90);
            int l11 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150346_d, 32, 2).func_76484_a(this.world, this.rand, l5, i9, l11);
        }
        for (int k2 = 0; k2 < 10; ++k2) {
            int i6 = var4 + this.rand.nextInt(16);
            int j9 = this.rand.nextInt(128);
            int i12 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150351_n, 32, 2).func_76484_a(this.world, this.rand, i6, j9, i12);
        }
        for (int i3 = 0; i3 < 20; ++i3) {
            int j6 = var4 + this.rand.nextInt(16);
            int k9 = this.rand.nextInt(128);
            int j12 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150365_q, 16, 2).func_76484_a(this.world, this.rand, j6, k9, j12);
        }
        for (int j3 = 0; j3 < 20; ++j3) {
            int k6 = var4 + this.rand.nextInt(16);
            int l9 = this.rand.nextInt(64);
            int k12 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150366_p, 8, 2).func_76484_a(this.world, this.rand, k6, l9, k12);
        }
        for (int k3 = 0; k3 < 2; ++k3) {
            int l6 = var4 + this.rand.nextInt(16);
            int i10 = this.rand.nextInt(32);
            int l12 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150352_o, 8, 2).func_76484_a(this.world, this.rand, l6, i10, l12);
        }
        for (int l3 = 0; l3 < 8; ++l3) {
            int i7 = var4 + this.rand.nextInt(16);
            int j10 = this.rand.nextInt(16);
            int i13 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150450_ax, 7, 2).func_76484_a(this.world, this.rand, i7, j10, i13);
        }
        for (int i4 = 0; i4 < 1; ++i4) {
            int j7 = var4 + this.rand.nextInt(16);
            int k10 = this.rand.nextInt(16);
            int j13 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150482_ag, 7, 2).func_76484_a(this.world, this.rand, j7, k10, j13);
        }
        for (int j4 = 0; j4 < 1; ++j4) {
            int k7 = var4 + this.rand.nextInt(16);
            int l10 = this.rand.nextInt(16) + this.rand.nextInt(16);
            int k13 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150369_x, 6, 2).func_76484_a(this.world, this.rand, k7, l10, k13);
        }
        for (int l5 = 0; l5 < 3 + this.rand.nextInt(6); ++l5) {
            int k1;
            int j1;
            int i1 = var4 + this.rand.nextInt(16);
            Block s1 = this.world.func_147439_a(i1, j1 = this.rand.nextInt(28) + 4, k1 = var5 + this.rand.nextInt(16));
            if (s1 != Blocks.field_150348_b) continue;
            this.world.func_147465_d(i1, j1, k1, Blocks.field_150412_bA, 0, 2);
        }
        double treedouble = 0.5;
        int l = (int)((this.TreeNoise.func_806_a((double)var4 * treedouble, (double)var5 * treedouble) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        if (l < 0) {
            l = 0;
        }
        l += deco_tree;
        if (!mayrandtrees) {
            l = deco_tree;
        }
        if (this.rand.nextInt(10) == 0) {
            ++l;
        }
        for (int b1 = 0; b1 < l; ++b1) {
            int k10;
            int j6 = var4 + this.rand.nextInt(16) + 8;
            int z52 = this.world.func_72976_f(j6, k10 = var5 + this.rand.nextInt(16) + 8);
            if (z52 < mintree || z52 > maxtree) continue;
            WorldGenerator worldgenerator = dis < 65.0 ? this.getRandomWorldGenForTrees(this.rand, 2) : (dis < 130.0 ? this.getRandomWorldGenForTrees(this.rand, 1) : this.getRandomWorldGenForTrees(this.rand, 0));
            worldgenerator.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator.func_76484_a(this.world, this.rand, j6, z52, k10);
        }
        for (int yf = 0; yf < deco_flowerYellow; ++yf) {
            int yf1 = var4 + this.rand.nextInt(16) + 8;
            int yf2 = this.rand.nextInt(128);
            int yf3 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150327_N).func_76484_a(this.world, this.rand, yf1, yf2, yf3);
        }
        for (int rf = 0; rf < deco_flowerRed; ++rf) {
            int rf1 = var4 + this.rand.nextInt(16) + 8;
            int rf2 = this.rand.nextInt(128);
            int rf3 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150328_O).func_76484_a(this.world, this.rand, rf1, rf2, rf3);
        }
        for (int gr = 0; gr < deco_grass; ++gr) {
            int gr1 = var4 + this.rand.nextInt(16) + 8;
            int gr2 = this.rand.nextInt(128);
            int gr3 = var5 + this.rand.nextInt(16) + 8;
            WorldGenerator grr = var6.func_76730_b(this.rand);
            grr.func_76484_a(this.world, this.rand, gr1, gr2, gr3);
        }
        if (this.rand.nextInt(4) == 0) {
            int nbm1 = var4 + this.rand.nextInt(16) + 8;
            int nbm2 = this.rand.nextInt(128);
            int nbm3 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(this.world, this.rand, nbm1, nbm2, nbm3);
        }
        if (this.rand.nextInt(8) == 0) {
            int nrm1 = var4 + this.rand.nextInt(16) + 8;
            int nrm2 = this.rand.nextInt(128);
            int nrm3 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(this.world, this.rand, nrm1, nrm2, nrm3);
        }
        if (this.THEMEID == 4) {
            SpawnerAnimals.func_77191_a((World)this.world, (BiomeGenBase)var6, (int)(var4 + 8), (int)(var5 + 8), (int)16, (int)16, (Random)this.world.field_73012_v);
        }
        int var7 = var4 + 8;
        int var8 = var5 + 8;
        for (int var12 = 0; var12 < 16; ++var12) {
            for (int var13 = 0; var13 < 16; ++var13) {
                int var14 = this.world.func_72874_g(var7 + var12, var8 + var13);
                if (this.world.func_72884_u(var12 + var7, var14 - 1, var13 + var8)) {
                    this.world.func_147465_d(var12 + var7, var14 - 1, var13 + var8, Blocks.field_150432_aD, 0, 2);
                }
                Block b = this.world.func_147439_a(var12 + var7, var14 - 1, var13 + var8);
                if (!this.world.func_147478_e(var12 + var7, var14, var13 + var8, false) || b == Blocks.field_150432_aD || b == Blocks.field_150355_j) continue;
                this.world.func_147465_d(var12 + var7, var14, var13 + var8, Blocks.field_150433_aE, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.world, this.rand, par2, par3, false));
        BlockSand.field_149832_M = false;
    }

    public WorldGenerator getRandomWorldGenForTrees(Random par1Random, int distance) {
        if (this.THEMEID == 2 || this.THEMEID == 5 && distance == 0) {
            if (par1Random.nextInt(5) == 0) {
                return new DecoBigTree(par1Random.nextInt(4) + 8, 0);
            }
            if (par1Random.nextInt(2) == 0) {
                return new OldGenTrees(2);
            }
            if (par1Random.nextInt(4) == 0) {
                return new WorldGenShrub(3, 0);
            }
            return new DecoSurvival(4);
        }
        if (this.THEMEID == 5 && distance == 1) {
            if (par1Random.nextInt(8) == 0) {
                return new DecoBigTree(8 + par1Random.nextInt(7), 0);
            }
            if (par1Random.nextInt(4) == 0) {
                return new WorldGenShrub(3, 0);
            }
            if (par1Random.nextInt(3) != 0) {
                return new WorldGenMegaJungle(false, 12 + par1Random.nextInt(10), 3, 3, 3);
            }
            if (par1Random.nextInt(2) == 0) {
                return new WorldGenTrees(false, 4 + par1Random.nextInt(7), 3, 3, true);
            }
            return new DecoSurvival(4);
        }
        if (this.THEMEID == 5 && distance == 2) {
            if (par1Random.nextInt(8) == 0) {
                return new DecoBigTree(8 + par1Random.nextInt(7), 0);
            }
            if (par1Random.nextInt(4) == 0) {
                return new WorldGenShrub(3, 0);
            }
            if (par1Random.nextInt(3) != 0) {
                return new WorldGenMegaJungle(false, 25 + par1Random.nextInt(15), 3, 3, 3);
            }
            return new WorldGenTrees(false, 4 + par1Random.nextInt(7), 3, 3, true);
        }
        return new OldGenTrees(2);
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.world.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return "Stronghold".equals(par2Str) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(par1World, par3, par4, par5) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_104112_b() {
    }

    public void func_82695_e(int par1, int par2) {
        this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.world, par1, par2, (Block[])null);
    }
}

