/*
 * Decompiled with CFR 0.152.
 */
package bwg4.world.generators;

import bwg4.deco.DecoDungeons;
import bwg4.deco.DecoIndevHouse;
import bwg4.deco.old.OldGenMinable;
import bwg4.noise.NoiseOctavesIndev;
import bwg4.noise.NoiseOctavesInfdev;
import bwg4.noise.NoisePerlinIndev;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class ChunkGeneratorIndev
implements IChunkProvider {
    private Random rand;
    private NoiseOctavesIndev noiseGen1;
    private NoiseOctavesIndev noiseGen2;
    private NoiseOctavesIndev noiseGen3;
    private NoiseOctavesIndev noiseGen4;
    public NoiseOctavesIndev noiseGen5;
    public NoiseOctavesIndev noiseGen6;
    public NoiseOctavesInfdev mobSpawnerNoise;
    public NoiseOctavesIndev noiseGen10;
    public NoiseOctavesIndev noiseGen11;
    public NoisePerlinIndev perlinGen1;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private double[] noiseArray;
    private double[] stoneNoise = new double[256];
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private BiomeGenBase[] biomesForGeneration;
    double[] noise1;
    double[] noise2;
    double[] noise3;
    double[] noise5;
    double[] noise6;
    float[] parabolicField;
    int[][] field_73219_j = new int[32][32];
    boolean themeHELL = false;
    boolean themePARADISE = false;
    boolean themeWOODS = false;
    boolean themeSNOW = false;
    boolean typeIsland = false;
    boolean typeFloating = false;
    boolean typeInland = false;
    boolean typeFinite = false;
    int size = 1;
    double width = 1.0;
    int layers = 1;

    public ChunkGeneratorIndev(World par1World, long par2, boolean par4, int type, int theme, int s, int l) {
        this.worldObj = par1World;
        this.mapFeaturesEnabled = par4;
        this.rand = new Random(par2);
        this.noiseGen1 = new NoiseOctavesIndev(this.rand, 16);
        this.noiseGen2 = new NoiseOctavesIndev(this.rand, 16);
        this.noiseGen3 = new NoiseOctavesIndev(this.rand, 8);
        this.noiseGen4 = new NoiseOctavesIndev(this.rand, 4);
        this.noiseGen5 = new NoiseOctavesIndev(this.rand, 4);
        this.noiseGen6 = new NoiseOctavesIndev(this.rand, 5);
        this.mobSpawnerNoise = new NoiseOctavesInfdev(this.rand, 8);
        this.noiseGen10 = new NoiseOctavesIndev(this.rand, 6);
        this.noiseGen11 = new NoiseOctavesIndev(this.rand, 8);
        this.perlinGen1 = new NoisePerlinIndev(this.rand);
        if (theme == 2) {
            this.themeHELL = true;
        }
        if (theme == 3) {
            this.themePARADISE = true;
        }
        if (theme == 4) {
            this.themeWOODS = true;
        }
        if (theme == 5) {
            this.themeSNOW = true;
        }
        if (type == 1) {
            this.typeIsland = true;
        }
        if (type == 2) {
            this.typeFloating = true;
        }
        if (type == 3) {
            this.typeInland = true;
        }
        if (type == 4) {
            this.typeFinite = true;
        }
        this.size = s;
        if (this.typeFloating) {
            if (s == 1) {
                this.size = 6;
                this.width = 1.2;
            }
            if (s == 2) {
                this.size = 12;
                this.width = 2.0;
            }
            if (s == 3) {
                this.size = 18;
                this.width = 3.0;
            }
        }
        if (this.typeIsland) {
            if (s == 1) {
                this.size = 3;
            }
            if (s == 2) {
                this.size = 5;
            }
            if (s == 3) {
                this.size = 7;
            }
        }
        this.layers = l;
        System.out.println(this.layers);
    }

    public void generateSkylands(int par1, int par2, Block[] blocks) {
        int seaLevel = 64;
        int i = par1 << 4;
        int j = par2 << 4;
        int jj = 0;
        boolean lx = false;
        boolean lz = false;
        if (par1 > -this.size && par1 < this.size && par2 > -this.size && par2 < this.size) {
            for (int layer = 0; layer < this.layers; ++layer) {
                jj = 0;
                for (int k = i; k < i + 16; ++k) {
                    for (int m = j; m < j + 16; ++m) {
                        float f2 = (float)this.noiseGen5.a(((float)k + (float)layer * 2000.0f) / 4.0f, ((float)m + (float)layer * 2000.0f) / 4.0f);
                        int i2 = 35 + layer * 45 + (int)f2;
                        if (i2 < 1) {
                            i2 = 1;
                        }
                        if ((float)this.noiseGen5.a(k, m) < 0.0f) {
                            i2 = i2 / 2 << 1;
                            if ((float)this.noiseGen5.a(k / 5, m / 5) < 0.0f) {
                                ++i2;
                            }
                        }
                        int thickness = -25;
                        int less = (int)Math.floor(Math.sqrt((k - 0) * (k - 0) + (m - 0) * (m - 0)) / this.width);
                        if (less > 150) {
                            less = 150;
                        }
                        double ovar32 = this.clamp(this.getNoise(8, k + layer * 2000, m + layer * 2000, 50.0, 50.0, 0.0));
                        int var77 = (int)(ovar32 * (double)(seaLevel / 2)) + 20 + layer * 45 + (thickness += less);
                        boolean flagSand = this.noiseGen3.a((float)k + (float)layer * 2000.0f, (float)m + (float)layer * 2000.0f) > 52.0 + (double)less / 3.0;
                        boolean flagGravel = this.noiseGen11.a((float)k + (float)layer * 2000.0f, (float)m + (float)layer * 2000.0f) > 62.0 + (double)less / 3.0;
                        for (int i3 = 0; i3 < 256; ++i3) {
                            ++jj;
                            if (i3 == i2) {
                                if (flagGravel) {
                                    blocks[jj] = Blocks.field_150351_n;
                                    continue;
                                }
                                if (flagSand) {
                                    blocks[jj] = Blocks.field_150354_m;
                                    continue;
                                }
                                if (i3 <= var77) continue;
                                blocks[jj] = Blocks.field_150348_b;
                                continue;
                            }
                            if (i3 <= var77 || i3 >= i2) continue;
                            blocks[jj] = Blocks.field_150348_b;
                        }
                    }
                }
            }
        }
    }

    public void generateSurface(int par1, int par2, Block[] blocks) {
        int jj = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int t = -1;
                boolean air = true;
                jj += 256;
                for (int y = 255; y > -1; --y) {
                    Object b = Blocks.field_150350_a;
                    int l1 = (x * 16 + z) * 256 + y;
                    if (blocks[l1] == null) {
                        b = Blocks.field_150350_a;
                        t = -1;
                    } else if (blocks[l1] == Blocks.field_150348_b) {
                        b = ++t == 0 && air ? Blocks.field_150349_c : (t < 3 ? Blocks.field_150346_d : Blocks.field_150348_b);
                        air = false;
                    } else {
                        ++t;
                        b = blocks[l1];
                    }
                    blocks[--jj] = b;
                }
                jj += 256;
            }
        }
    }

    public void generateTerrain(int par1, int par2, Block[] ba) {
        int height = 128;
        int seaLevel = 64;
        int i = par1 << 4;
        int j = par2 << 4;
        int jj = 0;
        boolean lx = false;
        boolean lz = false;
        for (int k = i; k < i + 16; ++k) {
            for (int m = j; m < j + 16; ++m) {
                boolean flagGravel;
                int n = k / 1024;
                int i1 = m / 1024;
                int i2 = 64;
                if (this.typeIsland) {
                    float f2 = (float)this.noiseGen5.a((float)k / 4.0f, (float)m / 4.0f);
                    i2 = 74 - (int)Math.floor(Math.sqrt((0.0 - (double)k) * (0.0 - (double)k) + (0.0 - (double)m) * (0.0 - (double)m)) / (double)this.size);
                    if (i2 < 50) {
                        i2 = 50;
                    }
                    i2 += (int)f2;
                } else {
                    float f1 = (float)(this.noiseGen1.a((float)k / 0.03125f, 0.0, (float)m / 0.03125f) - this.noiseGen2.a((float)k / 0.015625f, 0.0, (float)m / 0.015625f)) / 512.0f / 4.0f;
                    float f2 = (float)this.noiseGen5.a((float)k / 4.0f, (float)m / 4.0f);
                    float f3 = (float)this.noiseGen6.a((float)k / 8.0f, (float)m / 8.0f) / 8.0f;
                    f2 = f2 > 0.0f ? (float)(this.noiseGen3.a((float)k * 0.2571428f * 2.0f, (float)m * 0.2571428f * 2.0f) * (double)f3 / 4.0) : (float)(this.noiseGen4.a((float)k * 0.2571428f, (float)m * 0.2571428f) * (double)f3);
                    i2 = (int)(f1 + 64.0f + f2);
                }
                if ((float)this.noiseGen5.a(k, m) < 0.0f) {
                    i2 = i2 / 2 << 1;
                    if ((float)this.noiseGen5.a(k / 5, m / 5) < 0.0f) {
                        ++i2;
                    }
                }
                boolean flagSand = this.noiseGen3.a(k, m) > 8.0;
                boolean bl = flagGravel = this.noiseGen11.a(k, m) > 18.0;
                if (this.themePARADISE) {
                    flagSand = this.noiseGen3.a(k, m) > -32.0;
                } else if (this.themeHELL || this.themeWOODS) {
                    boolean bl2 = flagSand = this.noiseGen3.a(k, m) > -8.0;
                }
                if (this.typeIsland) {
                    flagSand = true;
                }
                for (int i3 = 0; i3 < 256; ++i3) {
                    Object i4 = Blocks.field_150350_a;
                    int beachHeight = seaLevel + 1;
                    if (this.themePARADISE) {
                        beachHeight = seaLevel + 3;
                    }
                    if (i3 == 0) {
                        i4 = Blocks.field_150357_h;
                    } else if (i3 == i2 && i2 >= beachHeight) {
                        i4 = this.themeHELL ? Blocks.field_150346_d : Blocks.field_150349_c;
                    } else if (i3 == i2) {
                        if (flagGravel) {
                            i4 = Blocks.field_150351_n;
                            if (this.themeHELL) {
                                i4 = Blocks.field_150346_d;
                            }
                        } else if (flagSand) {
                            i4 = Blocks.field_150354_m;
                            if (this.themeHELL) {
                                i4 = Blocks.field_150346_d;
                            }
                        } else {
                            i4 = i2 > seaLevel - 1 ? Blocks.field_150349_c : Blocks.field_150346_d;
                        }
                    } else if (i3 <= i2 - 2) {
                        i4 = Blocks.field_150348_b;
                    } else if (i3 < i2) {
                        i4 = Blocks.field_150346_d;
                    } else if (i3 <= 64 && !this.typeFloating) {
                        i4 = this.themeHELL ? (i3 == 64 ? Blocks.field_150356_k : Blocks.field_150353_l) : Blocks.field_150355_j;
                    }
                    this.rand.setSeed(n + i1 * 13871);
                    int i5 = (n << 10) + 128 + this.rand.nextInt(512);
                    int i6 = (i1 << 10) + 128 + this.rand.nextInt(512);
                    i5 = k - i5;
                    int i7 = m - i6;
                    if (i5 < 0) {
                        i5 = -i5;
                    }
                    if (i7 < 0) {
                        i7 = -i7;
                    }
                    if (i7 > i5) {
                        i5 = i7;
                    }
                    if ((i5 = 127 - i5) == 255) {
                        i5 = 1;
                    }
                    if (i5 < i2) {
                        i5 = i2;
                    }
                    if (i3 <= i5 && (i4 == Blocks.field_150350_a || i4 == Blocks.field_150355_j || i4 == Blocks.field_150353_l)) {
                        i4 = Blocks.field_150336_V;
                    }
                    ba[jj++] = i4;
                }
            }
        }
    }

    private double clamp(double input) {
        if (input > 1.0) {
            return 1.0;
        }
        if (input < -1.0) {
            return -1.0;
        }
        return input;
    }

    private double getNoise(int level, int x, int y, double xfact, double yfact, double zstart) {
        double output = 0.0;
        for (double l = 1.0; l <= (double)(level * level); l *= 2.0) {
            output += this.perlinGen1.a((double)x / xfact * l, (double)y / yfact * l) / l;
        }
        return output;
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int cx, int cy) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cy * 132897987541L);
        Block[] var3 = new Block[65536];
        byte[] metadata = new byte[65536];
        if (this.typeFloating) {
            this.generateSkylands(cx, cy, var3);
            this.generateSurface(cx, cy, var3);
        } else {
            this.generateTerrain(cx, cy, var3);
        }
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, cx * 16, cy * 16, 16, 16);
        if (!this.typeFloating) {
            this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, var3);
            if (this.mapFeaturesEnabled) {
                this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, var3);
                this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, cx, cy, var3);
            }
        }
        Chunk var4 = new Chunk(this.worldObj, var3, metadata, cx, cy);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)this.biomesForGeneration[var6].field_76756_M;
        }
        var4.func_76603_b();
        return var4;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int k20;
        int k17;
        int k15;
        BlockSand.field_149832_M = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        BiomeGenBase var6 = this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * var7 + (long)par3 * var9 ^ this.worldObj.func_72905_C());
        double d = 0.25;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.rand, par2, par3, false));
        if (this.mapFeaturesEnabled && !this.typeFloating) {
            this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
            this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, par2, par3);
        }
        if (par2 == (int)Math.floor(this.worldObj.func_72912_H().func_76079_c() / 16) && par3 == (int)Math.floor(this.worldObj.func_72912_H().func_76074_e() / 16)) {
            int ix = this.worldObj.func_72912_H().func_76079_c();
            int iz = this.worldObj.func_72912_H().func_76074_e();
            int iy = this.worldObj.func_72825_h(ix, iz);
            new DecoIndevHouse(1).func_76484_a(this.worldObj, this.rand, ix, iy, iz);
        }
        int extraheight = 128;
        int extradeco = 1;
        if (this.typeFloating) {
            extradeco = 2;
            extraheight = 256;
        }
        if (this.typeFloating) {
            if (this.rand.nextInt(30) == 0) {
                int j5 = var4 + this.rand.nextInt(16) + 8;
                int k88 = this.rand.nextInt(15);
                int j11 = var5 + this.rand.nextInt(16) + 8;
                if (this.rand.nextInt(8) == 0) {
                    new DecoDungeons(2, false, false, false, true).func_76484_a(this.worldObj, this.rand, j5, k88, j11);
                } else {
                    new DecoDungeons(2, false, false, true, false).func_76484_a(this.worldObj, this.rand, j5, k88, j11);
                }
            }
        } else {
            for (int k1 = 0; k1 < 12; ++k1) {
                int j5 = var4 + this.rand.nextInt(16) + 8;
                int k88 = this.rand.nextInt(128);
                int j11 = var5 + this.rand.nextInt(16) + 8;
                new DecoDungeons(1, false, true, false, false).func_76484_a(this.worldObj, this.rand, j5, k88, j11);
            }
        }
        for (int k2 = 0; k2 < 5; ++k2) {
            int i6 = var4 + this.rand.nextInt(16);
            int j9 = this.rand.nextInt(64);
            int i12 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150351_n, 32, 2).func_76484_a(this.worldObj, this.rand, i6, j9, i12);
        }
        for (int i3 = 0; i3 < 20 * extradeco; ++i3) {
            int j6 = var4 + this.rand.nextInt(16);
            int k9 = this.rand.nextInt(extraheight);
            int j12 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150365_q, 16, 2).func_76484_a(this.worldObj, this.rand, j6, k9, j12);
        }
        for (int j3 = 0; j3 < 20 * extradeco; ++j3) {
            int k6 = var4 + this.rand.nextInt(16);
            int l9 = this.rand.nextInt(64 * extradeco);
            int k12 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150366_p, 8, 2).func_76484_a(this.worldObj, this.rand, k6, l9, k12);
        }
        int floatingore = 0;
        if (this.typeFloating) {
            floatingore = 16;
        }
        for (int k3 = 0; k3 < 2; ++k3) {
            int l6 = var4 + this.rand.nextInt(16);
            int i10 = this.rand.nextInt(32) + floatingore;
            int l12 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150352_o, 8, 2).func_76484_a(this.worldObj, this.rand, l6, i10, l12);
        }
        for (int l33 = 0; l33 < 8; ++l33) {
            int i7 = var4 + this.rand.nextInt(16);
            int j10 = this.rand.nextInt(16) + floatingore;
            int i13 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150450_ax, 7, 2).func_76484_a(this.worldObj, this.rand, i7, j10, i13);
        }
        for (int i4 = 0; i4 < 1; ++i4) {
            int j7 = var4 + this.rand.nextInt(16);
            int k10 = this.rand.nextInt(16) + floatingore;
            int j13 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150482_ag, 7, 2).func_76484_a(this.worldObj, this.rand, j7, k10, j13);
        }
        for (int j4 = 0; j4 < 1; ++j4) {
            int k7 = var4 + this.rand.nextInt(16);
            int l10 = this.rand.nextInt(16) + floatingore;
            int k13 = var5 + this.rand.nextInt(16);
            new OldGenMinable(Blocks.field_150369_x, 6, 2).func_76484_a(this.worldObj, this.rand, k7, l10, k13);
        }
        d = 0.5;
        int l333 = (int)((this.mobSpawnerNoise.func_806_a((double)var4 * d, (double)var5 * d) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        if (l333 < 0) {
            l333 = 0;
        }
        if (this.rand.nextInt(10) == 0) {
            ++l333;
        }
        if (this.themeWOODS) {
            l333 += 8;
        } else if (this.typeIsland) {
            ++l333;
        }
        WorldGenTrees obj = new WorldGenTrees(false, 5, 0, 0, false);
        for (int k88 = 0; k88 < l333; ++k88) {
            int j133 = var4 + this.rand.nextInt(16) + 8;
            int l155 = var5 + this.rand.nextInt(16) + 8;
            ((WorldGenerator)obj).func_76487_a(1.0, 1.0, 1.0);
            ((WorldGenerator)obj).func_76484_a(this.worldObj, this.rand, j133, this.worldObj.func_72976_f(j133, l155), l155);
        }
        int amount1 = 2;
        if (this.themePARADISE) {
            amount1 = 8;
        }
        for (int i34 = 0; i34 < amount1; ++i34) {
            for (int i14 = 0; i14 < 2 * extradeco; ++i14) {
                int k14 = var4 + this.rand.nextInt(16) + 8;
                int l16 = this.rand.nextInt(extraheight);
                int k19 = var5 + this.rand.nextInt(16) + 8;
                new WorldGenFlowers((Block)Blocks.field_150327_N).func_76484_a(this.worldObj, this.rand, k14, l16, k19);
            }
            if (this.rand.nextInt(2 / extradeco) != 0) continue;
            int j15 = var4 + this.rand.nextInt(16) + 8;
            int j17 = this.rand.nextInt(extraheight);
            int j20 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150328_O).func_76484_a(this.worldObj, this.rand, j15, j17, j20);
        }
        if (this.themeHELL || this.themeWOODS) {
            k15 = var4 + this.rand.nextInt(16) + 8;
            k17 = this.rand.nextInt(extraheight);
            k20 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(this.worldObj, this.rand, k15, k17, k20);
            if (this.rand.nextInt(2 / extradeco) == 0) {
                int l15 = var4 + this.rand.nextInt(16) + 8;
                int l17 = this.rand.nextInt(extraheight);
                int l20 = var5 + this.rand.nextInt(16) + 8;
                new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(this.worldObj, this.rand, l15, l17, l20);
            }
        } else {
            if (this.rand.nextInt(4 / extradeco) == 0) {
                k15 = var4 + this.rand.nextInt(16) + 8;
                k17 = this.rand.nextInt(extraheight);
                k20 = var5 + this.rand.nextInt(16) + 8;
                new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(this.worldObj, this.rand, k15, k17, k20);
            }
            if (this.rand.nextInt(8 / extradeco) == 0) {
                int l15 = var4 + this.rand.nextInt(16) + 8;
                int l17 = this.rand.nextInt(extraheight);
                int l20 = var5 + this.rand.nextInt(16) + 8;
                new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(this.worldObj, this.rand, l15, l17, l20);
            }
        }
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)var6, (int)(var4 + 8), (int)(var5 + 8), (int)16, (int)16, (Random)this.rand);
        BlockSand.field_149832_M = false;
        if (this.themeSNOW) {
            var4 += 8;
            var5 += 8;
            for (int var85 = 0; var85 < 16; ++var85) {
                for (int var86 = 0; var86 < 16; ++var86) {
                    int var87 = this.worldObj.func_72874_g(var4 + var85, var5 + var86);
                    if (this.worldObj.func_72884_u(var85 + var4, var87 - 1, var86 + var5)) {
                        this.worldObj.func_147465_d(var85 + var4, var87 - 1, var86 + var5, Blocks.field_150432_aD, 0, 2);
                    }
                    Block b = this.worldObj.func_147439_a(var85 + var4, var87 - 1, var86 + var5);
                    if (!this.worldObj.func_147478_e(var85 + var4, var87, var86 + var5, false) || b == Blocks.field_150432_aD || b == Blocks.field_150355_j) continue;
                    this.worldObj.func_147465_d(var85 + var4, var87, var86 + var5, Blocks.field_150431_aC, 0, 2);
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.rand, par2, par3, false));
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return "Stronghold".equals(par2Str) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(par1World, par3, par4, par5) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_104112_b() {
    }

    public void func_82695_e(int par1, int par2) {
        if (this.mapFeaturesEnabled && !this.typeFloating) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        }
    }
}

