/*
 * Decompiled with CFR 0.152.
 */
package bettervillages;

import bettervillages.ComponentBetterVillageTorch;
import bettervillages.VillageCreationHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

@Mod(modid="bettervillages", name="Better Villages Mod", useMetadata=true)
public class BetterVillages {
    public static final Block FLAG_ID = Blocks.field_150344_f;
    public static Block pathWay;
    public static Block fieldFence;
    public static boolean lilies;
    public static boolean fields;
    public static boolean gates;
    public static boolean wells;
    public static boolean woodHut;
    public static boolean torch;
    public static boolean big;
    public static String biomeNames;
    public static HashSet<String> villageSpawnBiomes;
    public static HashSet<BiomeDictionary.Type> villageSpawnTypes;
    public static List<VillagerRegistry.IVillageCreationHandler> handlers;

    @Mod.EventHandler
    public void configLoad(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        pathWay = (Block)GameData.blockRegistry.func_82594_a(config.get("general", "Ocean_villages_path", "planks", "Block used for streets of villages built in Ocean biome").getString());
        if (pathWay == Blocks.field_150350_a) {
            pathWay = FLAG_ID;
        }
        StringBuilder build = new StringBuilder("Available biome tags are: ");
        for (BiomeDictionary.Type t : BiomeDictionary.Type.values()) {
            build.append(t);
            build.append(",");
        }
        config.addCustomCategoryComment("general", build.toString());
        this.parseBiome(config.get("General", "Available_biomes", biomeNames, "Biomes where villages should be added, use ALL or * for all biomes, select with biome name or biome tags, prefix with - to exclude").getString().split(","));
        lilies = config.get("general", "Spawn_waterlily", lilies, "Water lilies can be found on water in villages").getBoolean(lilies);
        wells = config.get("general", "Decorate_wells", wells, "Village wells should be improved").getBoolean(wells);
        fields = config.get("general", "Decorate_fields", fields, "Village fields should be improved").getBoolean(fields);
        woodHut = config.get("general", "Decorate_huts", woodHut, "Village wood huts should be improved").getBoolean(woodHut);
        gates = config.get("general", "Add_gates", gates, "Fence gates added to village fields").getBoolean(gates);
        fieldFence = (Block)GameData.blockRegistry.func_82594_a(config.get("general", "Villages_fields_fencing", "fence", "Block used for fencing villages fields").getString());
        if (fieldFence == Blocks.field_150350_a) {
            fieldFence = Blocks.field_150422_aJ;
        }
        torch = config.get("general", "Add_new_torch", torch, "Better torch has a chance to appear in villages").getBoolean(torch);
        big = config.get("general", "Bigger_Villages", big, "Villages generates in clusters").getBoolean(big);
        if (config.hasChanged()) {
            config.save();
        }
        if (event.getSourceFile().getName().endsWith(".jar") && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, String.class, String.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), "https://raw.github.com/GotoLink/BetterVillages/master/update.xml", "https://raw.github.com/GotoLink/BetterVillages/master/changelog.md");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void parseBiome(String[] ID) {
        villageSpawnBiomes = new HashSet();
        villageSpawnTypes = new HashSet();
        for (String txt : ID) {
            if (txt.startsWith("-")) {
                txt = txt.substring(1).trim();
                try {
                    villageSpawnTypes.remove(BiomeDictionary.Type.valueOf((String)txt.toUpperCase()));
                }
                catch (IllegalArgumentException l) {
                    villageSpawnBiomes.remove(txt);
                }
                continue;
            }
            if (txt.equals("*") || txt.equalsIgnoreCase("ALL")) {
                for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                    villageSpawnBiomes.add(biome.field_76791_y);
                }
                for (BiomeGenBase t : BiomeDictionary.Type.values()) {
                    villageSpawnTypes.add((BiomeDictionary.Type)t);
                }
                continue;
            }
            try {
                BiomeDictionary.Type type = BiomeDictionary.Type.valueOf((String)txt.toUpperCase());
                villageSpawnTypes.add(type);
                for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                    villageSpawnBiomes.add(biome.field_76791_y);
                }
            }
            catch (IllegalArgumentException l) {
                for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                    if (biome == null || !biome.field_76791_y.equals(txt)) continue;
                    villageSpawnBiomes.add(txt);
                    BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                    if (types == null) continue;
                    for (BiomeDictionary.Type type : types) {
                        villageSpawnTypes.add(type);
                    }
                }
            }
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (villageSpawnBiomes != null && !villageSpawnBiomes.isEmpty()) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || !villageSpawnBiomes.contains(biome.field_76791_y) || !villageSpawnTypes.containsAll(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)))) continue;
                BiomeManager.addVillageBiome((BiomeGenBase)biome, (boolean)true);
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (villageSpawnBiomes.contains(BiomeGenBase.field_76771_b.field_76791_y) || villageSpawnBiomes.contains(BiomeGenBase.field_150575_M.field_76791_y)) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        }
        if (torch) {
            MapGenStructureIO.func_143031_a(ComponentBetterVillageTorch.class, (String)"BViT");
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCreationHandler(ComponentBetterVillageTorch.class, 15, 0, 1, 1));
        }
        if (big) {
            for (VillagerRegistry.IVillageCreationHandler handler : handlers) {
                VillagerRegistry.instance().registerVillageCreationHandler(handler);
            }
        }
    }

    @SubscribeEvent
    public void onPopulating(PopulateChunkEvent.Post event) {
        if (event.hasVillageGenerated) {
            int i = event.chunkX * 16;
            int k = event.chunkZ * 16;
            BiomeGenBase biome = event.world.func_72807_a(i, k);
            Block borderId = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT) ? Blocks.field_150322_A : Blocks.field_150364_r;
            for (int x = i; x < i + 16; ++x) {
                block5: for (int z = k; z < k + 16; ++z) {
                    int[] field;
                    List<int[]> list;
                    Block id;
                    int y;
                    if (biome instanceof BiomeGenOcean) {
                        y = event.world.func_72825_h(x, z) - 1;
                        id = event.world.func_147439_a(x, y, z);
                        if (id == Blocks.field_150325_L && event.world.func_147439_a(x - 1, y - 1, z) == Blocks.field_150478_aa && event.world.func_147439_a(x + 1, y - 1, z) == Blocks.field_150478_aa && event.world.func_147439_a(x, y - 1, z - 1) == Blocks.field_150478_aa && event.world.func_147439_a(x, y - 1, z + 1) == Blocks.field_150478_aa) {
                            if (!BetterVillages.isReplaceable(event.world, x, y - 4, z)) continue;
                            event.world.func_147449_b(x, y - 4, z, pathWay);
                            continue;
                        }
                        if (id == Blocks.field_150476_ad) {
                            while (event.world.func_147437_c(x, --y, z) || BetterVillages.isWaterId(event.world.func_147439_a(x, y, z))) {
                            }
                            id = event.world.func_147439_a(x, y, z);
                        }
                        if (id == FLAG_ID) {
                            id = event.world.func_147439_a(x, y + 1, z);
                            if (!BetterVillages.isWaterId(id)) continue;
                            event.world.func_147465_d(x, y, z, id, 0, 2);
                            while (!event.world.func_147437_c(x, y, z)) {
                                ++y;
                            }
                            event.world.func_147449_b(x, y, z, pathWay);
                            continue;
                        }
                    }
                    if ((y = event.world.func_72976_f(x, z)) <= 1) continue;
                    id = event.world.func_147439_a(x, --y, z);
                    while (id.isAir((IBlockAccess)event.world, x, y, z) || id.isLeaves((IBlockAccess)event.world, x, y, z)) {
                        id = event.world.func_147439_a(x, --y, z);
                    }
                    if (BetterVillages.isWaterId(id)) {
                        if (lilies && event.world.func_147437_c(x, y + 1, z) && event.rand.nextInt(10) == 0) {
                            event.world.func_147465_d(x, y + 1, z, Blocks.field_150392_bi, 0, 2);
                        }
                        if (!gates || (list = BetterVillages.getBorder(event.world, id, field = new int[]{x, y, z})).size() != 1 || (list = BetterVillages.getBorder(event.world, borderId, field)).size() != 3 || !BetterVillages.isReplaceable(event.world, (field = list.get(1))[0], field[1] + 1, field[2])) continue;
                        int p = 0;
                        if (x - field[0] < 0) {
                            p = 1;
                        } else if (x - field[0] > 0) {
                            p = 3;
                        } else if (z - field[2] < 0) {
                            p = 2;
                        }
                        event.world.func_147465_d(field[0], field[1] + 1, field[2], Blocks.field_150396_be, p, 2);
                        continue;
                    }
                    if (fields && id == Blocks.field_150458_ak) {
                        field = new int[]{x, y, z};
                        list = BetterVillages.getBorder(event.world, borderId, field);
                        if (list.isEmpty()) continue;
                        switch (list.size()) {
                            case 3: {
                                field = list.get(1);
                                if (!BetterVillages.isReplaceable(event.world, field[0], field[1] + 1, field[2])) continue block5;
                                event.world.func_147465_d(field[0], field[1] + 1, field[2], fieldFence, 0, 2);
                                break;
                            }
                            case 5: {
                                field = list.remove(1);
                                if (BetterVillages.isReplaceable(event.world, field[0], field[1] + 1, field[2])) {
                                    event.world.func_147465_d(field[0], field[1] + 1, field[2], fieldFence, 0, 2);
                                }
                                if (BetterVillages.isReplaceable(event.world, (field = list.remove(2))[0], field[1] + 1, field[2])) {
                                    event.world.func_147465_d(field[0], field[1] + 1, field[2], fieldFence, 0, 2);
                                }
                                for (int[] pos : list) {
                                    if (!BetterVillages.isReplaceable(event.world, pos[0], pos[1] + 1, pos[2])) continue;
                                    event.world.func_147465_d(pos[0], pos[1] + 1, pos[2], fieldFence, 0, 2);
                                    if (!BetterVillages.isReplaceable(event.world, pos[0], pos[1] + 2, pos[2]) || !BetterVillages.isCorner(event.world, borderId, pos)) continue;
                                    event.world.func_147465_d(pos[0], pos[1] + 2, pos[2], Blocks.field_150478_aa, 0, 2);
                                }
                                continue block5;
                            }
                        }
                        continue;
                    }
                    if (wells && id == Blocks.field_150347_e) {
                        id = event.world.func_147439_a(x, y - 4, z);
                        if (!BetterVillages.isWaterId(id) || (list = BetterVillages.getBorder(event.world, id, field = new int[]{x, y -= 4, z})).size() != 3 || (list = BetterVillages.getBorder(event.world, Blocks.field_150347_e, field)).size() != 5) continue;
                        field = list.remove(1);
                        event.world.func_147465_d(field[0], field[1] + 1, field[2], (Block)Blocks.field_150333_U, 0, 2);
                        field = list.remove(2);
                        event.world.func_147465_d(field[0], field[1] + 1, field[2], (Block)Blocks.field_150333_U, 0, 2);
                        for (int[] pos : list) {
                            for (int[] posb : BetterVillages.getBorder(event.world, Blocks.field_150351_n, pos)) {
                                event.world.func_147465_d(posb[0], posb[1], posb[2], (Block)Blocks.field_150333_U, 0, 2);
                            }
                        }
                        while (event.world.func_147439_a(x, y, z) == id) {
                            --y;
                        }
                        field = new int[]{x, y, z};
                        list = BetterVillages.getBorder(event.world, Blocks.field_150347_e, field);
                        for (int[] pos : list) {
                            event.world.func_147465_d(pos[0], pos[1], pos[2], Blocks.field_150339_S, 0, 2);
                        }
                        event.world.func_147465_d(field[0], field[1], field[2], Blocks.field_150339_S, 0, 2);
                        continue;
                    }
                    if (!woodHut || id != borderId) continue;
                    while ((id = event.world.func_147439_a(x, --y, z)).isAir((IBlockAccess)event.world, x, y, z) || !id.func_149662_c()) {
                    }
                    if (id != Blocks.field_150346_d) continue;
                    event.world.func_147449_b(x, y, z, borderId);
                    list = BetterVillages.getBorder(event.world, Blocks.field_150347_e, new int[]{x, y, z});
                    for (int[] pos : list) {
                        event.world.func_147465_d(pos[0], pos[1], pos[2], Blocks.field_150348_b, 0, 2);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onSettingGravel(BiomeEvent.GetVillageBlockID event) {
        if (event.biome instanceof BiomeGenOcean && event.original == Blocks.field_150351_n) {
            event.replacement = FLAG_ID;
            event.setResult(Event.Result.DENY);
        }
    }

    private static List<int[]> getBorder(World world, Block id, int[] field) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int x = field[0] - 1; x < field[0] + 2; ++x) {
            for (int z = field[2] - 1; z < field[2] + 2; ++z) {
                if (x == field[0] && z == field[2] || world.func_147439_a(x, field[1], z) != id) continue;
                list.add(new int[]{x, field[1], z});
            }
        }
        return list;
    }

    private static boolean isCorner(World world, Block id, int[] pos) {
        int[] b;
        List<int[]> list = BetterVillages.getBorder(world, id, pos);
        if (list.size() < 2) {
            return false;
        }
        int[] a = list.get(0);
        return a[0] != (b = list.get(1))[0] && a[2] != b[2];
    }

    private static boolean isReplaceable(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    private static boolean isWaterId(Block id) {
        return id.func_149688_o() == Material.field_151586_h;
    }

    static {
        lilies = true;
        fields = true;
        gates = true;
        wells = true;
        woodHut = true;
        torch = true;
        big = true;
        biomeNames = "DesertHills,Extreme Hills,Extreme Hills Edge,Jungle,JungleHills,Ocean,Swampland,Taiga,TaigaHills,Ice Plains,Ice Mountains,Forest";
        handlers = new ArrayList<VillagerRegistry.IVillageCreationHandler>();
        handlers.add(new VillageCreationHandler(StructureVillagePieces.House4Garden.class, 4, 2, 4, 2));
        handlers.add(new VillageCreationHandler(StructureVillagePieces.Church.class, 20, 0, 1, 1));
        handlers.add(new VillageCreationHandler(StructureVillagePieces.WoodHut.class, 3, 2, 5, 3));
        handlers.add(new VillageCreationHandler(StructureVillagePieces.Hall.class, 15, 0, 2, 1));
        handlers.add(new VillageCreationHandler(StructureVillagePieces.Field1.class, 3, 1, 4, 1));
        handlers.add(new VillageCreationHandler(StructureVillagePieces.Field2.class, 3, 2, 4, 2));
        handlers.add(new VillageCreationHandler(StructureVillagePieces.House1.class, 20, 0, 2, 1));
        handlers.add(new VillageCreationHandler(StructureVillagePieces.House2.class, 15, 0, 1, 1));
        handlers.add(new VillageCreationHandler(StructureVillagePieces.House3.class, 8, 0, 3, 2));
    }
}

