/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items.swords;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.packets.PacketSpawnParticlesAround;
import com.chocolate.chocolateQuest.utils.BDHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class ItemBDSword
extends ItemSword {
    protected float weaponAttackDamage;
    protected AttributeModifier damageModifier;
    protected float elementModifier = 1.0f;
    protected float cachedDamage = 0.0f;

    public ItemBDSword(Item.ToolMaterial material) {
        this(material, 4.0f);
    }

    public ItemBDSword(Item.ToolMaterial material, float baseDamage) {
        super(material);
        this.weaponAttackDamage = baseDamage + material.func_78000_c();
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        this.damageModifier = new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponAttackDamage, 0);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)this.damageModifier);
        return multimap;
    }

    public float getWeaponDamage() {
        return this.weaponAttackDamage;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(is, player, list, par4);
        for (Elements elements : Elements.values()) {
            float value = this.getElementDamage(is, elements);
            if (!(value > 0.0f)) continue;
            list.add(BDHelper.StringColor(elements.getStringColor()) + this.getElementString(elements, value));
        }
        for (Awakements awakements : Awakements.awekements) {
            if (!Awakements.hasEnchant(is, awakements)) continue;
            list.add(awakements.getDescription(is));
        }
    }

    protected String getElementString(Elements element, float value) {
        return "+" + this.translateFloat(value) + " " + element.getTranslatedName();
    }

    public String translateFloat(float d) {
        String value = Double.toString(d);
        int index = value.indexOf(".");
        if (index < 3) {
            index += 2;
        }
        value = value.substring(0, index);
        return value;
    }

    public boolean func_77644_a(ItemStack is, EntityLivingBase target, EntityLivingBase entity) {
        this.applyEnchantmentHit(is, target, entity);
        return super.func_77644_a(is, target, entity);
    }

    public void applyEnchantmentHit(ItemStack is, EntityLivingBase target, EntityLivingBase entity) {
        if (target.field_70172_ad == 20 || target.field_70172_ad == 0) {
            for (Elements element : Elements.values()) {
                float damage = this.getElementDamage(is, element);
                if (!(damage > 0.0f)) continue;
                target.field_70172_ad = 0;
                DamageSource ds = element.getDamageSource();
                if (!target.func_70097_a(ds, damage = element.onHitEntity((Entity)entity, (Entity)target, damage)) || target.field_70170_p.field_72995_K) continue;
                byte particle = PacketSpawnParticlesAround.getParticleFromName(element.getParticle());
                PacketSpawnParticlesAround packet = new PacketSpawnParticlesAround(particle, target.field_70165_t, target.field_70163_u + 1.0 + field_77697_d.nextDouble(), target.field_70161_v);
                ChocolateQuest.channel.sendToAllAround((Entity)target, packet, 64);
            }
        }
    }

    public void attackEntityWithItem(EntityPlayer player, Entity e) {
        AttributeModifier cacheDamageModifier = new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.cachedDamage, 0);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.damageModifier);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(cacheDamageModifier);
        player.func_71059_n(e);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(cacheDamageModifier);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(this.damageModifier);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (Awakements.hasEnchant(itemStack, Awakements.property)) {
            Awakements.property.onUpdate(entity, itemStack);
        }
        if (Awakements.hasEnchant(itemStack, Awakements.autoRepair)) {
            Awakements.autoRepair.onUpdate(entity, itemStack);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        Awakements.property.onEntityItemUpdate(entityItem);
        return super.onEntityItemUpdate(entityItem);
    }

    public float getPhysicDamage(ItemStack is) {
        return this.getElementDamage(is, Elements.physic);
    }

    public float getFireDamage(ItemStack is) {
        return this.getElementDamage(is, Elements.fire);
    }

    public float getMagicDamage(ItemStack is) {
        return this.getElementDamage(is, Elements.magic);
    }

    public float getBlastDamage(ItemStack is) {
        return this.getElementDamage(is, Elements.blast);
    }

    public void setPhysicDamage(int i, ItemStack is) {
        this.setElementValue(is, Elements.physic, i);
    }

    public void setFireDamage(int i, ItemStack is) {
        this.setElementValue(is, Elements.fire, i);
    }

    public void setMagicDamage(int i, ItemStack is) {
        this.setElementValue(is, Elements.magic, i);
    }

    public void setBlastDamage(int i, ItemStack is) {
        this.setElementValue(is, Elements.blast, i);
    }

    protected float getElementDamage(ItemStack is, Elements element) {
        return (float)this.getElementValue(is, element) * this.elementModifier;
    }

    public int getElementValue(ItemStack is, Elements element) {
        if (is.field_77990_d == null) {
            return 0;
        }
        return is.field_77990_d.func_74771_c(element.getName());
    }

    public void setElementValue(ItemStack is, Elements element, int value) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74774_a(element.getName(), (byte)value);
    }
}

