/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items.gun;

import com.chocolate.chocolateQuest.API.IRangedWeapon;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.gui.InventoryBag;
import com.chocolate.chocolateQuest.items.gun.ILoadableGun;
import com.chocolate.chocolateQuest.magic.Awakements;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemPistol
extends Item
implements IRangedWeapon,
ILoadableGun {
    final int NONE = -1;
    int cooldownBase = 10;
    final float accuracy;
    final float range;

    public ItemPistol() {
        this(10, 100.0f, 10.0f);
    }

    public ItemPistol(int cooldown, float range, float accuracy) {
        this.cooldownBase = cooldown;
        this.range = range;
        this.accuracy = accuracy;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("chocolatequest:revolver");
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af() && !this.freeAmmo()) {
            entityPlayer.openGui((Object)ChocolateQuest.instance, 3, entityPlayer.field_70170_p, 0, 0, 0);
            return itemstack;
        }
        if (itemstack.func_77960_j() == 0 && this.shoot(itemstack, world, entityPlayer)) {
            itemstack.func_77964_b(this.getCooldown(itemstack));
        }
        return super.func_77659_a(itemstack, world, entityPlayer);
    }

    public boolean shoot(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        int NONE = -1;
        int bulletType = this.getAmmo(itemstack, entityPlayer);
        if (this.freeAmmo()) {
            bulletType = 1;
        }
        if (entityPlayer.field_71075_bZ.field_75098_d && bulletType == -1) {
            bulletType = 1;
        }
        if (bulletType != -1) {
            if (!world.field_72995_K) {
                EntityBaseBall ball = new EntityBaseBall(world, (EntityLivingBase)entityPlayer, 1, bulletType);
                float accuracy = this.accuracy / 100.0f;
                ball.field_70159_w += field_77697_d.nextGaussian() * (double)accuracy;
                ball.field_70181_x += field_77697_d.nextGaussian() * (double)accuracy;
                ball.field_70179_y += field_77697_d.nextGaussian() * (double)accuracy;
                int power = Awakements.getEnchantLevel(itemstack, Awakements.power);
                ball.setDamageMultiplier(1.0f + (float)power / 10.0f);
                world.func_72838_d((Entity)ball);
            }
            return true;
        }
        return false;
    }

    public boolean freeAmmo() {
        return false;
    }

    protected int getAmmo(ItemStack itemstack, EntityPlayer entityPlayer) {
        int bulletType = -1;
        ItemStack[] ammo = InventoryBag.getCargo(itemstack);
        for (int i = 0; i < ammo.length; ++i) {
            if (ammo[i] == null || ammo[i].func_77973_b() != ChocolateQuest.bullet) continue;
            bulletType = ammo[i].func_77960_j();
            int ammoSaver = Awakements.getEnchantLevel(itemstack, Awakements.ammoSaver);
            if (entityPlayer.field_71075_bZ.field_75098_d || ammoSaver != 0 && field_77697_d.nextInt(2 + ammoSaver) < 2) break;
            --ammo[i].field_77994_a;
            if (ammo[i].field_77994_a <= 0) {
                ammo[i] = null;
            }
            InventoryBag.saveCargo(itemstack, ammo);
            break;
        }
        return bulletType;
    }

    @Override
    public int getAmmoLoaderStackSize(ItemStack is) {
        return 8;
    }

    @Override
    public int getAmmoLoaderAmmount(ItemStack is) {
        int loaders = Awakements.getEnchantLevel(is, Awakements.ammoCapacity);
        return 1 + loaders;
    }

    @Override
    public boolean isValidAmmo(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == ChocolateQuest.bullet;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(is, player, list, par4);
        for (Awakements a : Awakements.awekements) {
            if (!Awakements.hasEnchant(is, a)) continue;
            list.add(a.getDescription(is));
        }
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public boolean func_77645_m() {
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (itemStack.func_77960_j() > 0) {
            itemStack.func_77964_b(itemStack.func_77960_j() - 1);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public int func_77612_l() {
        return this.cooldownBase;
    }

    public boolean func_77629_n_() {
        return false;
    }

    public boolean func_77662_d() {
        return false;
    }

    public int getCooldown(ItemStack is) {
        return this.cooldownBase;
    }

    @Override
    public float getRange(EntityLivingBase shooter, ItemStack is) {
        return this.range;
    }

    @Override
    public int getCooldown(EntityLivingBase shooter, ItemStack is) {
        return this.cooldownBase;
    }

    @Override
    public void shootFromEntity(EntityLivingBase shooter, ItemStack is, int angle, Entity target) {
        if (!shooter.field_70170_p.field_72995_K) {
            EntityBaseBall ball;
            double armDist = 2.0;
            double posX = shooter.field_70165_t - Math.sin(Math.toRadians(shooter.field_70177_z + (float)angle)) * 2.0;
            double posY = shooter.field_70163_u + 1.6;
            double posZ = shooter.field_70161_v + Math.cos(Math.toRadians(shooter.field_70177_z + (float)angle)) * 2.0;
            if (target != null) {
                ball = this.getBall(shooter.field_70170_p, shooter, target.field_70165_t - posX, target.field_70163_u + (double)target.field_70131_O - posY, target.field_70161_v - posZ);
            } else {
                double ry = Math.toRadians(shooter.field_70177_z - 180.0f);
                double x = Math.sin(ry);
                double z = -Math.cos(ry);
                double y = -Math.sin(Math.toRadians(shooter.field_70125_A * 2.0f - 1.0f));
                ball = this.getBall(shooter.field_70170_p, shooter, x, y, z);
                ball.field_70163_u -= (double)(shooter.field_70131_O / 2.0f);
            }
            ball.func_70107_b(posX, posY, posZ);
            shooter.field_70170_p.func_72838_d((Entity)ball);
        }
    }

    public EntityBaseBall getBall(World world, EntityLivingBase shooter, double x, double y, double z) {
        float accuracy = 5.0f;
        if (shooter instanceof EntityHumanBase) {
            accuracy += ((EntityHumanBase)shooter).accuracy;
        }
        return new EntityBaseBall(shooter.field_70170_p, shooter, x, y, z, 1, 1, accuracy);
    }

    @Override
    public boolean canBeUsedByEntity(Entity entity) {
        return true;
    }

    @Override
    public boolean isMeleeWeapon(EntityLivingBase shooter, ItemStack is) {
        return false;
    }

    @Override
    public boolean shouldUpdate(EntityLivingBase shooter) {
        return false;
    }

    @Override
    public int startAiming(ItemStack is, EntityLivingBase shooter, Entity target) {
        return this.cooldownBase + 10;
    }
}

