/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.items.IHookLauncher;
import com.chocolate.chocolateQuest.items.ItemArmorHeavy;
import com.chocolate.chocolateQuest.items.ItemHookShoot;
import com.chocolate.chocolateQuest.packets.PacketHookImpact;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityHookShoot
extends EntityThrowable
implements IThrowableEntity {
    public ItemStack item = null;
    int lifeTime = 0;
    EntityLivingBase shootingEntity;
    public double radio = 0.0;
    public boolean returning = false;
    public boolean reeling = false;
    public static final byte hookManual = 2;
    public static final byte hookSpider = 3;
    public static final byte hookWeapon = 4;
    public static final byte hookSpiderBoss = 5;
    public Entity hookedEntity;
    public double hookedAtHeight;
    public double hookedAtDistance;
    public double hookedAtAngle;
    public int blockX;
    public int blockY;
    public int blockZ;

    public EntityHookShoot(World par1World) {
        super(par1World);
    }

    public EntityHookShoot(World world, EntityLivingBase entityliving, int type) {
        super(world, entityliving);
        this.shootingEntity = entityliving;
        this.setHookType(type);
        float s = 0.6f;
        this.func_70105_a(s, s);
        this.field_70170_p.func_72908_a((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v), "random.bow", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    public EntityHookShoot(World world, EntityLivingBase entityliving, int type, ItemStack item) {
        this(world, entityliving, type);
        this.item = item;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(10, (Object)0);
        this.field_70180_af.func_75682_a(11, (Object)0);
    }

    public void setReeling(boolean b) {
        this.field_70180_af.func_75692_b(10, (Object)(b ? (byte)1 : 0));
    }

    public boolean isReeling() {
        return this.field_70180_af.func_75683_a(10) == 1;
    }

    public void setHookType(int par) {
        this.field_70180_af.func_75692_b(11, (Object)((byte)par));
    }

    public byte getHookType() {
        return this.field_70180_af.func_75683_a(11);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.isReeling()) {
            PacketHookImpact packet;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !this.field_70170_p.field_72995_K) {
                this.blockX = mop.field_72311_b;
                this.blockY = mop.field_72312_c;
                this.blockZ = mop.field_72309_d;
                packet = new PacketHookImpact(this.func_145782_y(), mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                ChocolateQuest.channel.sendToAllAround((Entity)this, packet);
                this.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
                this.field_70122_E = true;
            }
            if (mop.field_72308_g instanceof Entity && !this.field_70170_p.field_72995_K) {
                if (mop.field_72308_g instanceof EntityThrowable) {
                    return;
                }
                if (!mop.field_72308_g.func_70028_i((Entity)this.func_85052_h())) {
                    this.hookedEntity = mop.field_72308_g;
                    this.hookedAtHeight = Math.min((double)this.hookedEntity.field_70131_O, this.field_70163_u - this.hookedEntity.field_70163_u);
                    this.hookedAtAngle = Math.atan2(this.hookedEntity.field_70161_v - this.field_70161_v, this.hookedEntity.field_70165_t - this.field_70165_t) * 180.0 / Math.PI + 90.0;
                    this.hookedAtAngle -= (double)this.hookedEntity.field_70177_z;
                    this.hookedAtDistance = Math.min((double)this.hookedEntity.field_70130_N, Math.sqrt(Math.abs(this.hookedEntity.field_70165_t - this.field_70165_t + this.hookedEntity.field_70161_v - this.field_70161_v)));
                    packet = new PacketHookImpact(this.func_145782_y(), this.hookedEntity.func_145782_y(), this.hookedAtAngle, this.hookedAtDistance, this.hookedAtHeight);
                    ChocolateQuest.channel.sendToAllAround((Entity)this, packet);
                    this.returning = true;
                    this.field_70122_E = true;
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70122_E) {
                this.setReeling(true);
                this.onImpact();
            }
        }
    }

    public void onImpact() {
        this.radio += 1.0;
    }

    public void func_70071_h_() {
        if (this.func_85052_h() != null && this.func_85052_h().field_70128_L || !this.field_70170_p.func_72899_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
            if (this.hookedEntity != null) {
                float angle = (float)((this.hookedAtAngle + (double)this.hookedEntity.field_70177_z) * (double)3.1416f / 180.0);
                this.field_70165_t = this.hookedEntity.field_70165_t - (double)MathHelper.func_76126_a((float)angle) * this.hookedAtDistance;
                this.field_70163_u = this.hookedEntity.field_70163_u + this.hookedAtHeight;
                this.field_70161_v = this.hookedEntity.field_70161_v + (double)MathHelper.func_76134_b((float)angle) * this.hookedAtDistance;
                if (!this.hookedEntity.func_70089_S()) {
                    this.hookedEntity = null;
                    this.setReeling(false);
                }
            }
            if (this.isReeling()) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            ++this.lifeTime;
            if (this.func_85052_h() != null) {
                EntityLivingBase shooting = this.func_85052_h();
                double dist = this.func_70032_d((Entity)this.func_85052_h());
                if (dist > this.radio) {
                    this.func_85052_h().field_70143_R = 0.0f;
                }
                if (shooting instanceof EntityPlayer) {
                    if (shooting.func_70093_af() && this.radio > 0.0) {
                        this.radio -= 0.4;
                        if (this.isSpiderHook() && this.isReeling() && this.shootingEntity instanceof EntityPlayer) {
                            this.radio -= 1.0;
                            if (dist >= this.radio) {
                                double maxMotion;
                                double distY = this.field_70163_u - shooting.field_70163_u;
                                if (distY > 0.0) {
                                    shooting.field_70181_x += Math.max(0.02, distY * 0.1);
                                }
                                if (shooting.field_70181_x > (maxMotion = Math.min(1.4, Math.max(1.1, distY / 10.0)))) {
                                    shooting.field_70181_x = maxMotion;
                                }
                            }
                        }
                    }
                } else {
                    this.radio -= 1.2;
                }
                if ((shooting.field_70733_aJ > 0.0f || shooting.func_70051_ag()) && this.radio < (double)this.getMaxRadius() && shooting.func_71124_b(0) != null && shooting.func_71124_b(0).func_77973_b() instanceof ItemHookShoot) {
                    this.radio += 0.5;
                }
                if (this.isReeling()) {
                    if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_147437_c(this.blockX, this.blockY, this.blockZ) && this.hookedEntity == null) {
                        this.setReeling(false);
                    }
                    boolean pullToShooter = false;
                    Entity ride = this.hookedEntity;
                    if (ride != null) {
                        if (ride instanceof EntityPlayer && ride.func_70093_af()) {
                            this.func_70106_y();
                        }
                        float ridenSize = ride.field_70130_N * 2.0f + ride.field_70131_O;
                        float shootingSize = shooting.field_70130_N * 2.0f + shooting.field_70131_O + 0.2f;
                        for (int i = 1; i <= 4; ++i) {
                            ItemStack boots = shooting.func_71124_b(i);
                            if (boots == null || boots.func_77973_b() == null || !(boots.func_77973_b() instanceof ItemArmorHeavy)) continue;
                            shootingSize += 5.0f;
                        }
                        if (shootingSize > ridenSize && this.hookedEntity.func_70104_M()) {
                            pullToShooter = true;
                        }
                    }
                    double pullSpeed = 0.0;
                    if (this.manualPull()) {
                        double playerSpeed = Math.sqrt(shooting.field_70159_w * shooting.field_70159_w + shooting.field_70179_y * shooting.field_70179_y + shooting.field_70181_x * shooting.field_70181_x);
                        playerSpeed *= Math.max(1.0, this.func_70068_e((Entity)shooting) / (this.radio * this.radio));
                        if ((playerSpeed /= 10.0) > (double)shooting.field_70747_aH && !pullToShooter) {
                            shooting.field_70747_aH = (float)Math.min(playerSpeed, 0.14);
                        }
                    } else {
                        float max = shooting.field_70131_O;
                        if (shooting instanceof EntityPlayer) {
                            max = 0.0f;
                        }
                        this.radio = Math.max((double)shooting.field_70131_O, this.radio - Math.min(0.6, this.radio / 30.0));
                    }
                    pullSpeed = dist - 0.2;
                    pullSpeed -= this.radio;
                    if (pullSpeed < 0.0) {
                        pullSpeed = 0.0;
                    }
                    if (pullSpeed > 2.0) {
                        pullSpeed = 2.0;
                    }
                    Vec3 fc = Vec3.func_72443_a((double)(shooting.field_70165_t - this.field_70165_t), (double)(shooting.field_70163_u - this.field_70163_u), (double)(shooting.field_70161_v - this.field_70161_v));
                    fc.func_72432_b();
                    fc.field_72450_a *= (pullSpeed *= 0.03);
                    fc.field_72449_c *= pullSpeed;
                    fc.field_72448_b *= pullSpeed;
                    if (pullToShooter) {
                        if (dist > this.radio || this.radio < 1.0) {
                            double s = 1.0;
                            ride.field_70159_w = fc.field_72450_a;
                            ride.field_70181_x = fc.field_72448_b;
                            ride.field_70179_y = fc.field_72449_c;
                            this.field_70159_w = fc.field_72450_a;
                            this.field_70181_x = fc.field_72448_b;
                            this.field_70179_y = fc.field_72449_c;
                        }
                    } else {
                        shooting.field_70159_w -= fc.field_72450_a;
                        shooting.field_70179_y -= fc.field_72449_c;
                        shooting.field_70181_x -= fc.field_72448_b;
                    }
                } else {
                    if (dist > (double)this.getMaxRadius()) {
                        this.returning = true;
                    }
                    if (this.returning) {
                        this.radio = dist;
                        Vec3 fc = Vec3.func_72443_a((double)(shooting.field_70165_t - this.field_70165_t), (double)(shooting.field_70163_u + 1.4 - this.field_70163_u), (double)(shooting.field_70161_v - this.field_70161_v));
                        fc.func_72432_b();
                        double s = 0.2;
                        if (this.getHookType() == 5) {
                            s = 0.05;
                        }
                        boolean flag = true;
                        this.field_70159_w = fc.field_72450_a * s;
                        this.field_70181_x = fc.field_72448_b * s;
                        this.field_70179_y = fc.field_72449_c * s;
                    } else {
                        double d = this.radio = dist < (double)this.getMaxRadius() ? dist : (double)this.getMaxRadius();
                    }
                }
                if (this.returning && !this.isReeling() && dist <= (double)(shooting.field_70130_N + shooting.field_70131_O)) {
                    this.func_70106_y();
                }
            }
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return true;
    }

    public ItemStack getHookShoot(EntityPlayer ep) {
        if (ep != null) {
            for (int i = 0; i < ep.field_71071_by.func_70302_i_(); ++i) {
                ItemStack is = ep.field_71071_by.func_70301_a(i);
                if (is == null) continue;
                int id = this.func_145782_y();
                if (!(is.func_77973_b() instanceof IHookLauncher) || ((IHookLauncher)is.func_77973_b()).getHookID(is) != id) continue;
                return is;
            }
        }
        return null;
    }

    public void func_70106_y() {
        ItemStack is;
        if (this.func_85052_h() instanceof EntityPlayer && (is = this.getHookShoot((EntityPlayer)this.func_85052_h())) != null) {
            ((IHookLauncher)is.func_77973_b()).setHookID(is, 0);
        }
        super.func_70106_y();
    }

    public double getRadius() {
        return this.radio;
    }

    public int getRopeColor() {
        byte type = this.getHookType();
        return type == 3 || type == 5 ? 0xFFFFFF : 0x444444;
    }

    public int getMaxRadius() {
        if (this.getHookType() == 3) {
            return 40;
        }
        if (this.getHookType() == 2) {
            return 30;
        }
        if (this.getHookType() == 1) {
            return 25;
        }
        if (this.getHookType() == 0) {
            return 15;
        }
        return 40;
    }

    public EntityLivingBase func_85052_h() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.shootingEntity = (EntityLivingBase)entity;
        }
    }

    protected boolean isSpiderHook() {
        byte hookType = this.getHookType();
        return hookType == 3 || hookType == 4;
    }

    private boolean manualPull() {
        byte hookType = this.getHookType();
        return hookType == 2 || hookType == 3 || hookType == 4;
    }
}

