/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class AttackPunch {
    public double[] swingDest = new double[3];
    public double[] swingStart = new double[3];
    public int attackTime = 0;
    public boolean isAttacking = false;
    byte handFlag;
    EntityBaseBoss owner;
    int attackSpeed = 20;
    private float shoulderHeight = 1.0f;
    private float armLength = 1.0f;
    private float distanceToBody = 0.4f;
    private int angleOffset;
    private int heightOffset = -1;
    public double posX;
    public double posY;
    public double posZ;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;

    public AttackPunch(EntityBaseBoss owner, byte handFlag) {
        this.owner = owner;
        this.handFlag = handFlag;
    }

    public AttackPunch(EntityBaseBoss owner, byte handFlag, float shoulderHeight, float armScale) {
        this(owner, handFlag);
        this.shoulderHeight = shoulderHeight;
        this.armLength = armScale;
    }

    public int getSpeed() {
        return this.attackSpeed;
    }

    public void setAngle(int angle, int height, float distanceToBody) {
        this.angleOffset = angle;
        this.heightOffset = height;
        this.distanceToBody = distanceToBody;
    }

    public void swingArmTo(double x, double y, double z) {
        this.attackTime = this.getSpeed();
        this.swingStart[0] = this.swingDest[0];
        this.swingStart[1] = this.swingDest[1];
        this.swingStart[2] = this.swingDest[2];
        this.swingDest[0] = x;
        this.swingDest[1] = y;
        this.swingDest[2] = z;
        this.isAttacking = true;
    }

    public void attackTarget(Entity target) {
        double posY = this.owner.field_70163_u + (double)this.getShoulderHeight();
        double targetY = target.field_70163_u + (double)(target.field_70131_O / 2.0f);
        double dx = target.field_70165_t - this.owner.field_70165_t;
        double dy = targetY - posY;
        double dz = target.field_70161_v - this.owner.field_70161_v;
        Vec3 v = Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
        v = v.func_72432_b();
        double distToHead = this.owner.func_70011_f(target.field_70165_t, targetY - (double)this.getShoulderHeight(), target.field_70161_v);
        double scale = Math.min(this.getArmLength(), distToHead);
        float armSpeed = 5.0f;
        dx = v.field_72450_a * scale;
        dy = v.field_72448_b * scale;
        dz = v.field_72449_c * scale;
        this.owner.attackToXYZ(this.handFlag, dx, dy, dz);
    }

    public void doPunchDamage() {
        double d = this.owner.size / 10.0f;
        double posX = this.owner.field_70165_t + this.posX;
        double posY = this.owner.field_70163_u + (double)this.getShoulderHeight() + this.posY;
        double posZ = this.owner.field_70161_v + this.posZ;
        List list = this.owner.field_70170_p.func_72839_b((Entity)this.owner, AxisAlignedBB.func_72330_a((double)(posX - d), (double)(posY - d), (double)(posZ - d), (double)(posX + d), (double)(posY + d), (double)(posZ + d)));
        for (int j = 0; j < list.size(); ++j) {
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || this.owner.func_70028_i(entity1) || !this.owner.func_70652_k(entity1)) continue;
            entity1.field_70159_w += this.swingDest[0] / 4.0;
            entity1.field_70181_x += this.swingDest[1] / 4.0;
            entity1.field_70179_y += this.swingDest[2] / 4.0;
        }
    }

    public void onUpdate() {
        float scale;
        Vec3 v;
        this.moveHands(this.swingDest, this.swingStart, this.attackTime);
        boolean forceDefensive = false;
        if (this.attackTime > 0) {
            --this.attackTime;
            this.doPunchDamage();
            if (this.isAttacking) {
                if (this.attackTime == 0) {
                    v = this.getDefaultPosition();
                    scale = (float)(this.getArmLength() * (double)this.distanceToBody);
                    this.swingArmTo(v.field_72450_a * (double)scale, v.field_72448_b * (double)scale, v.field_72449_c * (double)scale);
                    this.isAttacking = false;
                }
            } else {
                forceDefensive = true;
            }
        } else {
            forceDefensive = true;
        }
        if (forceDefensive) {
            v = this.getDefaultPosition();
            scale = (float)(this.getArmLength() * (double)this.distanceToBody);
            this.swingDest[0] = v.field_72450_a * (double)scale;
            this.swingDest[1] = v.field_72448_b * (double)scale;
            this.swingDest[2] = v.field_72449_c * (double)scale;
        }
    }

    public void moveHands(double[] dest, double[] start, int armSwing) {
        this.posX = this.owner.field_70165_t;
        this.posY = this.owner.field_70163_u + (double)this.getShoulderHeight();
        this.posZ = this.owner.field_70161_v;
        int swing = this.getSpeed() - armSwing;
        double dx = start[0] + (dest[0] - start[0]) / (double)this.getSpeed() * (double)swing;
        double dy = start[1] + (dest[1] - start[1]) / (double)this.getSpeed() * (double)swing;
        double dz = start[2] + (dest[2] - start[2]) / (double)this.getSpeed() * (double)swing;
        this.setPosition(dx, dy, dz);
    }

    public float getShoulderHeight() {
        return this.owner.size * this.shoulderHeight;
    }

    public double getArmLength() {
        return this.owner.size * this.armLength;
    }

    public void setPosition(double x, double y, double z) {
        this.prevPosX = this.posX;
        this.posX = x;
        this.prevPosY = this.posY;
        this.posY = y;
        this.prevPosZ = this.posZ;
        this.posZ = z;
    }

    public boolean attackInProgress() {
        return this.attackTime > 0;
    }

    protected Vec3 getDefaultPosition() {
        double posX = -Math.sin(Math.toRadians(this.owner.field_70759_as + (float)this.angleOffset));
        double posY = (float)this.heightOffset + MathHelper.func_76134_b((float)((float)this.owner.field_70173_aa / 20.0f)) / 4.0f;
        double posZ = Math.cos(Math.toRadians(this.owner.field_70759_as + (float)this.angleOffset));
        return Vec3.func_72443_a((double)posX, (double)posY, (double)posZ).func_72432_b();
    }
}

