/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder.decorator;

import com.chocolate.chocolateQuest.API.BuilderBlockData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DecoratorRoof {
    public final int PYRAMID = 0;
    public final int FENCE_IRON_FLOOR = 2;
    public final int TRIANGLE = 5;
    public int floorType = 0;
    public BuilderBlockData block = new BuilderBlockData(Blocks.field_150417_aV);
    public BuilderBlockData fence = new BuilderBlockData(Blocks.field_150422_aJ);
    public Block stairs = Blocks.field_150487_bG;
    public Block roofBlock = Blocks.field_150336_V;
    int texasType = 0;
    int walkableType = 0;
    Random random;

    public DecoratorRoof(Random random) {
        this.random = random;
        this.floorType = random.nextInt(6);
        this.texasType = random.nextInt(2);
        this.walkableType = random.nextInt(4);
        int i = random.nextInt(9);
        switch (i) {
            case 0: {
                this.stairs = Blocks.field_150487_bG;
                this.roofBlock = Blocks.field_150336_V;
                break;
            }
            case 1: {
                this.stairs = Blocks.field_150481_bH;
                this.roofBlock = Blocks.field_150344_f;
                break;
            }
            case 2: {
                this.stairs = Blocks.field_150476_ad;
                this.roofBlock = Blocks.field_150344_f;
                break;
            }
            case 3: {
                this.stairs = Blocks.field_150487_bG;
                this.roofBlock = Blocks.field_150344_f;
                break;
            }
            case 4: {
                this.stairs = Blocks.field_150485_bF;
                this.roofBlock = Blocks.field_150344_f;
                break;
            }
            case 5: {
                this.stairs = Blocks.field_150446_ar;
                this.roofBlock = Blocks.field_150347_e;
                break;
            }
            case 6: {
                this.stairs = Blocks.field_150389_bf;
                this.roofBlock = Blocks.field_150336_V;
                break;
            }
            case 7: {
                this.stairs = Blocks.field_150372_bz;
                this.roofBlock = Blocks.field_150322_A;
                break;
            }
            case 8: {
                this.stairs = Blocks.field_150390_bg;
                this.roofBlock = Blocks.field_150417_aV;
            }
        }
        if (random.nextInt(100) == 0) {
            this.stairs = Blocks.field_150370_cb;
            this.roofBlock = Blocks.field_150371_ca;
        }
        if (this.floorType == 2) {
            this.fence = new BuilderBlockData(Blocks.field_150411_aY);
        }
    }

    public void generateRoof(World world, int x, int y, int z, int sizeX, int sizeZ, boolean walkable) {
        if (!walkable && this.random.nextBoolean()) {
            if (this.texasType == 0) {
                this.roofPyramid(world, x, y, z, sizeX, sizeZ, 1000);
            } else {
                this.roofTriangle(world, x, y, z, sizeX, sizeZ);
            }
            return;
        }
        switch (this.floorType) {
            case 1: {
                this.fence(world, x, y, z, sizeX, sizeZ, Blocks.field_150422_aJ);
                break;
            }
            case 2: {
                this.fence(world, x, y, z, sizeX, sizeZ, Blocks.field_150411_aY);
                break;
            }
            case 3: {
                this.roofDoubleSlabsDecorator(world, x, y, z, sizeX, sizeZ, 2);
                break;
            }
            case 4: {
                this.roofDoubleSlabsDecorator(world, x, y, z, sizeX, sizeZ, 1);
                break;
            }
            case 5: {
                if (!walkable) {
                    this.roofTriangle(world, x, y, z, sizeX, sizeZ);
                    break;
                }
                this.addClearRoof(world, x, y, z, sizeX, sizeZ);
                break;
            }
            default: {
                if (!walkable) {
                    this.roofPyramid(world, x, y, z, sizeX, sizeZ, 1000);
                    break;
                }
                this.addClearRoof(world, x, y, z, sizeX, sizeZ);
            }
        }
    }

    public void setRoofBlock(World world, int x, int y, int z) {
        if (this.floorType == 1 || this.floorType == 2) {
            world.func_147449_b(x, y, z, this.fence.id);
        } else {
            int az;
            int ax = Math.abs(x);
            if (ax % 2 == (az = Math.abs(z)) % 2) {
                world.func_147449_b(x, y, z, this.block.id);
            }
        }
    }

    private void addClearRoof(World world, int x, int y, int z, int sizeX, int sizeZ) {
        switch (this.walkableType) {
            case 1: {
                this.fence(world, x, y, z, sizeX, sizeZ, Blocks.field_150422_aJ);
                break;
            }
            case 2: {
                this.fence(world, x, y, z, sizeX, sizeZ, Blocks.field_150411_aY);
                break;
            }
            case 3: {
                this.roofDoubleSlabsDecorator(world, x, y, z, sizeX, sizeZ, 2);
                break;
            }
            default: {
                this.roofDoubleSlabsDecorator(world, x, y, z, sizeX, sizeZ, 1);
            }
        }
    }

    private void fence(World world, int x, int y, int z, int sizeX, int sizeZ, Block block) {
        for (int i = 0; i <= sizeX; ++i) {
            world.func_147449_b(x + i, y, z, block);
            world.func_147449_b(x + i, y, z + sizeZ, block);
        }
        for (int k = 0; k <= sizeZ; ++k) {
            world.func_147449_b(x, y, z + k, block);
            world.func_147449_b(x + sizeX, y, z + k, block);
        }
    }

    public void roofPyramid(World world, int x, int y, int z, int sizeX, int sizeZ, int height) {
        int minSize = Math.min(sizeX, sizeZ) / 2 + 1;
        minSize = Math.min(height, minSize);
        minSize -= 1 - minSize % 2;
        for (int j = 0; j <= minSize; ++j) {
            world.func_147465_d(x + j - 1, y + j, z + j - 1, this.stairs, 2, 3);
            world.func_147465_d(x + sizeX - j + 1, y + j, z + j - 1, this.stairs, 2, 3);
            world.func_147465_d(x + j - 1, y + j, z + sizeZ - j + 1, this.stairs, 3, 3);
            world.func_147465_d(x + sizeX - j + 1, y + j, z + sizeZ - j + 1, this.stairs, 3, 3);
            for (int i = j; i <= sizeX - j; ++i) {
                world.func_147449_b(x + i, y + j, z + j, this.block.id);
                world.func_147465_d(x + i, y + j, z + j - 1, this.stairs, 2, 3);
                world.func_147449_b(x + i, y + j, z + sizeZ - j, this.block.id);
                world.func_147465_d(x + i, y + j, z + sizeZ - j + 1, this.stairs, 3, 3);
            }
            for (int k = j; k <= sizeZ - j; ++k) {
                world.func_147449_b(x + j, y + j, z + k, this.block.id);
                world.func_147449_b(x + j - 1, y + j, z + k, this.stairs);
                world.func_147449_b(x + sizeX - j, y + j, z + k, this.block.id);
                world.func_147465_d(x + sizeX - j + 1, y + j, z + k, this.stairs, 1, 3);
            }
        }
    }

    private void roofTriangle(World world, int x, int y, int z, int sizeX, int sizeZ) {
        if (sizeX < sizeZ) {
            int minSize = sizeX / 2;
            for (int j = 0; j <= minSize; ++j) {
                int k;
                for (k = 0; k <= sizeZ; ++k) {
                    world.func_147465_d(x + j, y + j, z + k, this.stairs, 0, 3);
                    world.func_147465_d(x + sizeX - j, y + j, z + k, this.stairs, 1, 3);
                }
                for (k = j + 1; k < sizeX - j; ++k) {
                    world.func_147449_b(x + k, y + j, z, this.block.id);
                    world.func_147449_b(x + k, y + j, z + sizeZ, this.block.id);
                }
            }
        } else {
            int minSize = sizeZ / 2;
            for (int j = 0; j <= minSize; ++j) {
                int k;
                for (k = 0; k <= sizeX; ++k) {
                    world.func_147465_d(x + k, y + j, z + j, this.stairs, 2, 3);
                    world.func_147465_d(x + k, y + j, z + sizeZ - j, this.stairs, 3, 3);
                }
                for (k = j + 1; k < sizeZ - j; ++k) {
                    world.func_147449_b(x, y + j, z + k, this.block.id);
                    world.func_147449_b(x + sizeX, y + j, z + k, this.block.id);
                }
            }
        }
    }

    private void roofDoubleSlabsDecorator(World world, int x, int y, int z, int sizeX, int sizeZ, int width) {
        int w;
        for (int i = 0; i < sizeX; i += width * 2) {
            for (w = 0; w < width; ++w) {
                world.func_147449_b(x + i + w, y, z, this.block.id);
                world.func_147449_b(x + i + w, y, z + sizeZ, this.block.id);
            }
        }
        for (int k = 0; k <= sizeZ; k += width * 2) {
            for (w = 0; w < width; ++w) {
                world.func_147449_b(x, y, z + k + w, this.block.id);
                world.func_147449_b(x + sizeX, y, z + k + w, this.block.id);
            }
        }
    }
}

