/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.DungeonBase;
import com.chocolate.chocolateQuest.API.DungeonRegister;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.mob.registry.DungeonMonstersBase;
import com.chocolate.chocolateQuest.entity.mob.registry.RegisterDungeonMobs;
import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGeneratorNew
implements IWorldGenerator {
    int dungeonSeparation = 5;

    public WorldGeneratorNew(int dungeonSeparation) {
        this.dungeonSeparation = dungeonSeparation;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_72995_K) {
            return;
        }
        Random rnd = new Random();
        rnd.setSeed(WorldGeneratorNew.getSeed(world, chunkX, chunkZ));
        Block block = Blocks.field_150342_X;
        if (chunkX % this.dungeonSeparation == 0 && chunkZ % this.dungeonSeparation == 0) {
            this.generateSurface(world, rnd, chunkX * 16 + 1, chunkZ * 16 + 1);
        }
    }

    public static long getSeed(World world, int chunkX, int chunkZ) {
        long mix = WorldGeneratorNew.xorShift64(chunkX) + Long.rotateLeft(WorldGeneratorNew.xorShift64(chunkZ), 32) + -1094792450L;
        long result = WorldGeneratorNew.xorShift64(mix);
        return world.func_72905_C() + result;
    }

    public static long xorShift64(long x) {
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        return x;
    }

    public static void createChunks(World world, int posX, int posZ, int sizeX, int sizeZ) {
        sizeX = Math.max(1, sizeX / 16);
        sizeZ = Math.max(1, sizeX / 16);
        int chunkX = posX / 16;
        int chunkZ = posZ / 16;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                if (world.func_72964_e(chunkX + x, chunkZ + z) != null) continue;
                world.func_72863_F().func_73158_c(chunkX + x, chunkZ + z);
            }
        }
    }

    public void generateSurface(World world, Random random, int i, int k) {
        if (world.func_72912_H().func_76067_t().func_77127_a() == "flat" && !ChocolateQuest.config.dungeonsInFlat) {
            return;
        }
        this.generateBigDungeon(world, random, i, k, true);
    }

    public void generateBigDungeon(World world, Random random, int i, int k, boolean addDungeon) {
        BuilderBase builder = null;
        BiomeGenBase biome = world.func_72807_a(i, k);
        DungeonBase dungeon = null;
        block0: for (DungeonBase d : DungeonRegister.dungeonList) {
            String[] b;
            int[] dimension = d.getDimension();
            boolean dimensionPass = false;
            for (int a = 0; a < dimension.length; ++a) {
                if (dimension[a] != world.field_73011_w.field_76574_g) continue;
                dimensionPass = true;
                break;
            }
            if (d.getChance() <= 0 || !dimensionPass) continue;
            for (String currentName : b = d.getBiomes()) {
                if (!this.isValidBiome(currentName, biome)) continue;
                if (random.nextInt(d.getChance()) != 0) continue block0;
                dungeon = d;
                continue block0;
            }
        }
        if (dungeon != null) {
            builder = dungeon.getBuilder();
            int idMob = RegisterDungeonMobs.mobList.get(dungeon.getMobID()).getDungeonMonster(world, i, 60, k).getID();
            builder.generate(random, world, i, k, idMob);
            BDHelper.println("Generatig " + dungeon.getName() + " at x: " + i + ",  z:" + k);
        }
    }

    public boolean isValidBiome(String biomeName, BiomeGenBase biome) {
        if (biomeName.equals("ALL")) {
            return true;
        }
        if (biomeName.equals("NONWATER")) {
            return !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER);
        }
        if (biome.field_76791_y.equals(biomeName)) {
            return true;
        }
        BiomeDictionary.Type type = null;
        if (biomeName.equals("BEACH")) {
            type = BiomeDictionary.Type.BEACH;
        } else if (biomeName.equals("DESERT")) {
            type = BiomeDictionary.Type.DESERT;
        } else if (biomeName.equals("END")) {
            type = BiomeDictionary.Type.END;
        } else if (biomeName.equals("FOREST")) {
            type = BiomeDictionary.Type.FOREST;
        } else if (biomeName.equals("FROZEN")) {
            type = BiomeDictionary.Type.FROZEN;
        } else if (biomeName.equals("HILLS")) {
            type = BiomeDictionary.Type.HILLS;
        } else if (biomeName.equals("JUNGLE")) {
            type = BiomeDictionary.Type.JUNGLE;
        } else if (biomeName.equals("MAGICAL")) {
            type = BiomeDictionary.Type.MAGICAL;
        } else if (biomeName.equals("MOUNTAIN")) {
            type = BiomeDictionary.Type.MOUNTAIN;
        } else if (biomeName.equals("MUSHROOM")) {
            type = BiomeDictionary.Type.MUSHROOM;
        } else if (biomeName.equals("NETHER")) {
            type = BiomeDictionary.Type.NETHER;
        } else if (biomeName.equals("PLAINS")) {
            type = BiomeDictionary.Type.PLAINS;
        } else if (biomeName.equals("SWAMP")) {
            type = BiomeDictionary.Type.SWAMP;
        } else if (biomeName.equals("WASTELAND")) {
            type = BiomeDictionary.Type.WASTELAND;
        } else if (biomeName.equals("WATER")) {
            type = BiomeDictionary.Type.WATER;
        }
        if (type != null) {
            return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)type);
        }
        return false;
    }

    public static int getMobIndex(ArrayList<DungeonMonstersBase> chestList, Random random) {
        int[] weights = new int[chestList.size()];
        int maxNum = 0;
        for (int i = 0; i < chestList.size(); ++i) {
            weights[i] = chestList.get(i).getWeight();
            maxNum += weights[i];
        }
        int randomNum = random.nextInt(maxNum);
        int index = 0;
        for (int weightSum = weights[0]; weightSum <= randomNum; weightSum += weights[++index]) {
        }
        return index;
    }
}

