/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.packets;

import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.packets.PacketBase;
import com.chocolate.chocolateQuest.particles.EffectManager;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSpawnParticlesAround
extends PacketBase {
    public static final byte HEARTS = 0;
    public static final byte CRIT = 1;
    public static final byte FLAME_LAUNCH = 2;
    public static final byte FLAMES = 3;
    public static final byte SPARK = 4;
    public static final byte SMOKE = 5;
    public static final byte WITCH_MAGIC = 6;
    public static final byte FIRE = 100;
    public static final byte BLAST = 101;
    public static final byte MAGIC = 102;
    public static final byte PHYSIC = 103;
    public static final byte LIGHT = 104;
    public static final byte DARK = 105;
    byte type;
    double x;
    double y;
    double z;

    public PacketSpawnParticlesAround() {
    }

    public PacketSpawnParticlesAround(byte animType, double x, double y, double z) {
        this.type = animType;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void execute(EntityPlayer player) {
        if (this.type == 2) {
            Entity e = player.field_70170_p.func_73045_a((int)this.x);
            Random itemRand = new Random();
            if (e != null) {
                float x = (float)(-Math.sin(Math.toRadians(e.field_70177_z)));
                float z = (float)Math.cos(Math.toRadians(e.field_70177_z));
                float y = (float)(-Math.sin(Math.toRadians(e.field_70125_A)));
                x *= 1.0f - Math.abs(y);
                z *= 1.0f - Math.abs(y);
                for (int i = 0; i < 50; ++i) {
                    double flameRandomMotion = itemRand.nextDouble() + 0.2;
                    float height = e.field_70131_O * 0.7f;
                    if (e instanceof EntityPlayer) {
                        height = 0.0f;
                    }
                    EffectManager.spawnParticle(3, e.field_70170_p, e.field_70165_t, e.field_70163_u + (double)height, e.field_70161_v, ((double)x + (itemRand.nextDouble() - 0.5) / 3.0) * flameRandomMotion, ((double)y + (itemRand.nextDouble() - 0.5) / 3.0) * flameRandomMotion, ((double)z + (itemRand.nextDouble() - 0.5) / 3.0) * flameRandomMotion);
                }
            }
            return;
        }
        if (this.type >= 100) {
            Random rand = player.field_70170_p.field_73012_v;
            double motion = 0.05;
            double posVar = 3.0;
            Elements element = Elements.fire;
            if (this.type == 101) {
                element = Elements.blast;
            }
            if (this.type == 102) {
                element = Elements.magic;
            }
            if (this.type == 103) {
                element = Elements.physic;
            }
            if (this.type == 104) {
                element = Elements.light;
            }
            if (this.type == 105) {
                element = Elements.darkness;
            }
            for (int i = 0; i < 8; ++i) {
                EffectManager.spawnElementParticle(0, player.field_70170_p, this.x + rand.nextGaussian() / posVar, this.y + rand.nextGaussian() / posVar, this.z + rand.nextGaussian() / posVar, rand.nextGaussian() * motion, rand.nextGaussian() * motion, rand.nextGaussian() * motion, element);
            }
        } else {
            String part = null;
            int ammount = 8;
            double motion = 0.25;
            double posVar = 3.0;
            switch (this.type) {
                case 0: {
                    part = "heart";
                    ammount = 4;
                    break;
                }
                case 1: {
                    part = "crit";
                    break;
                }
                case 3: {
                    part = "flame";
                    motion = 0.08;
                    break;
                }
                case 6: {
                    part = "witchMagic";
                    break;
                }
                case 5: {
                    part = "smoke";
                    motion = 0.02;
                    posVar = 6.0;
                    break;
                }
                case 4: {
                    part = "fireworksSpark";
                    break;
                }
                default: {
                    part = "crit";
                }
            }
            Random rand = player.field_70170_p.field_73012_v;
            for (int i = 0; i < ammount; ++i) {
                player.field_70170_p.func_72869_a(part, this.x + rand.nextGaussian() / posVar, this.y + rand.nextGaussian() / posVar, this.z + rand.nextGaussian() / posVar, rand.nextGaussian() * motion, rand.nextGaussian() * motion, rand.nextGaussian() * motion);
            }
        }
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        this.type = bytes.readByte();
        this.x = bytes.readDouble();
        this.y = bytes.readDouble();
        this.z = bytes.readDouble();
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.type);
        bytes.writeDouble(this.x);
        bytes.writeDouble(this.y);
        bytes.writeDouble(this.z);
    }

    public static byte getParticleFromName(String name) {
        if (name.equals("smoke")) {
            return 101;
        }
        if (name.equals("flame")) {
            return 3;
        }
        if (name.equals("witchMagic")) {
            return 102;
        }
        if (name.equals("fireworksSpark")) {
            return 103;
        }
        if (name.equals("crit")) {
            return 1;
        }
        if (name.equals("heart")) {
            return 0;
        }
        if (name.equals("fire")) {
            return 100;
        }
        if (name.equals("blast")) {
            return 101;
        }
        if (name.equals("magic")) {
            return 102;
        }
        if (name.equals("physic")) {
            return 103;
        }
        if (name.equals("light")) {
            return 104;
        }
        if (name.equals("dark")) {
            return 105;
        }
        if (name.equals("fireE")) {
            return 100;
        }
        if (name.equals("blastE")) {
            return 101;
        }
        if (name.equals("magicE")) {
            return 102;
        }
        if (name.equals("physicE")) {
            return 103;
        }
        return 0;
    }
}

