/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items;

import com.chocolate.chocolateQuest.API.ICooldownTracker;
import com.chocolate.chocolateQuest.API.IRangedWeapon;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.gui.InventoryBag;
import com.chocolate.chocolateQuest.items.CoolDownTracker;
import com.chocolate.chocolateQuest.items.gun.ILoadableGun;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.magic.SpellBase;
import com.chocolate.chocolateQuest.utils.BDHelper;
import com.chocolate.chocolateQuest.utils.HelperPlayer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemStaffBase
extends Item
implements ILoadableGun,
IRangedWeapon,
ICooldownTracker {
    int cooldown = 10;
    Elements element;
    CoolDownTracker cachedTracker;

    public ItemStaffBase() {
        this.func_77625_d(1);
    }

    public ItemStaffBase(Elements element) {
        this();
        this.element = element;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("chocolatequest:" + this.func_77658_a().replace("item.", ""));
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(is, player, list, par4);
        for (Awakements a : Awakements.awekements) {
            if (!Awakements.hasEnchant(is, a)) continue;
            list.add(a.getDescription(is));
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            ItemStack[] ammo = InventoryBag.getCargo(itemstack);
            boolean isEmpty = true;
            for (int i = 0; i < ammo.length; ++i) {
                if (ammo[i] == null) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) {
                ItemStack[] ammoNew = InventoryBag.getCargo(itemstack);
                int last = 0;
                ItemStack lastItem = ammo[0];
                for (int i = 1; i < ammo.length; ++i) {
                    if (ammo[i] == null) continue;
                    ammoNew[last] = ammo[i];
                    ++last;
                }
                ammoNew[last] = lastItem;
                InventoryBag.saveCargo(itemstack, ammoNew);
            } else {
                entityPlayer.openGui((Object)ChocolateQuest.instance, 3, entityPlayer.field_70170_p, 0, 0, 0);
            }
            return itemstack;
        }
        ItemStack[] cargo = InventoryBag.getCargo(itemstack);
        if (cargo[0] != null && cargo[0].field_77990_d == null) {
            SpellBase spell = this.getSpell(itemstack);
            spell.onCastStart((EntityLivingBase)entityPlayer, this.element, itemstack);
            entityPlayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return super.func_77659_a(itemstack, world, entityPlayer);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityPlayer, int useTime) {
        useTime = this.func_77626_a(itemstack) - useTime;
        useTime = Math.min(useTime + 1, 60);
        SpellBase spell = this.getSpell(itemstack);
        if (spell != null && spell.isProjectile()) {
            spell.onShoot((EntityLivingBase)entityPlayer, this.getElement(itemstack), itemstack, useTime);
            ItemStack[] spellsStack = InventoryBag.getCargo(itemstack);
            if (spellsStack[0].field_77990_d == null) {
                spellsStack[0].field_77990_d = new NBTTagCompound();
            }
            spellsStack[0].field_77990_d.func_74768_a("cd", spell.getCoolDown());
            InventoryBag.saveCargo(itemstack, spellsStack);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.func_71039_bw() && player.func_71011_bu() == itemStack) {
                SpellBase spell = this.getSpell(itemStack);
                if (spell != null && spell.shouldUpdate()) {
                    spell.onUpdate((EntityLivingBase)entity, this.getElement(itemStack), itemStack, 30);
                }
            } else {
                NBTTagCompound tag = itemStack.field_77990_d;
                if (tag != null) {
                    ItemStack[] cargo = InventoryBag.getCargo(itemStack);
                    for (int i = 0; i < cargo.length; ++i) {
                        if (cargo[i] == null || cargo[i].field_77990_d == null) continue;
                        int cd = cargo[i].field_77990_d.func_74762_e("cd");
                        if (cd > 0) {
                            cargo[i].field_77990_d.func_74768_a("cd", cd - 1);
                            continue;
                        }
                        cargo[i].field_77990_d = null;
                    }
                    InventoryBag.saveCargo(itemStack, cargo);
                    if (cargo[0] != null) {
                        if (cargo[0].field_77990_d != null) {
                            int cd = cargo[0].field_77990_d.func_74762_e("cd");
                            if (cd > 0) {
                                itemStack.func_77964_b(cd);
                            } else {
                                itemStack.func_77964_b(-1);
                            }
                        } else {
                            itemStack.func_77964_b(-1);
                        }
                    }
                }
            }
        } else {
            this.onUpdateEntity(itemStack, world, entity, par4, par5);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int func_77612_l() {
        return 100;
    }

    public int getDisplayDamage(ItemStack stack) {
        ItemStack[] cargo = InventoryBag.getCargo(stack);
        if (cargo[0] != null) {
            if (cargo[0].field_77990_d != null) {
                SpellBase spell = this.getSpell(stack);
                int damage = cargo[0].field_77990_d.func_74762_e("cd");
                int maxCD = spell.getCoolDown();
                return damage * 100 / maxCD;
            }
            return 100;
        }
        return 0;
    }

    public String func_77653_i(ItemStack itemstack) {
        return BDHelper.StringColor(this.element.stringColor) + super.func_77653_i(itemstack) + BDHelper.StringColor("r");
    }

    public Entity getTarget(EntityPlayer ep, World world) {
        return HelperPlayer.getTarget((EntityLivingBase)ep, world, 30.0);
    }

    public boolean func_77662_d() {
        return true;
    }

    public CreativeTabs func_77640_w() {
        return ChocolateQuest.tabItems;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public SpellBase getSpell(ItemStack is) {
        ItemStack[] ammo = InventoryBag.getCargo(is);
        if (ammo[0] == null) {
            return null;
        }
        return SpellBase.getSpellByID(ammo[0].func_77960_j());
    }

    public Elements getElement(ItemStack is) {
        if (this.element != null) {
            return this.element;
        }
        return Elements.light;
    }

    @Override
    public int getAmmoLoaderStackSize(ItemStack is) {
        return 1;
    }

    @Override
    public int getAmmoLoaderAmmount(ItemStack is) {
        return 4;
    }

    @Override
    public boolean isValidAmmo(ItemStack is) {
        return is.func_77973_b() == ChocolateQuest.spell;
    }

    @Override
    public float getRange(EntityLivingBase shooter, ItemStack is) {
        int maxRange = 0;
        if (this.cachedTracker != null && this.cachedTracker.castingSpell != null) {
            maxRange = this.cachedTracker.castingSpell.getRange(is);
        } else {
            ItemStack[] spells = InventoryBag.getCargo(is);
            for (int i = 0; i < spells.length; ++i) {
                if (spells[i] == null) continue;
                maxRange = Math.max(maxRange, SpellBase.getSpellByID(spells[i].func_77960_j()).getRange(is));
            }
        }
        return maxRange * maxRange;
    }

    @Override
    public int getCooldown(EntityLivingBase shooter, ItemStack is) {
        return 10;
    }

    @Override
    public void shootFromEntity(EntityLivingBase shooter, ItemStack is, int angle, Entity target) {
        if (this.cachedTracker.castingSpell != null) {
            shooter.field_70177_z = shooter.field_70759_as;
            this.cachedTracker.castingSpell.onShoot(shooter, this.getElement(is), is, 5);
        }
        this.cachedTracker.castingSpell = null;
    }

    @Override
    public boolean canBeUsedByEntity(Entity entity) {
        return true;
    }

    @Override
    public boolean isMeleeWeapon(EntityLivingBase shooter, ItemStack is) {
        return false;
    }

    @Override
    public boolean shouldUpdate(EntityLivingBase shooter) {
        return true;
    }

    @Override
    public int startAiming(ItemStack is, EntityLivingBase shooter, Entity target) {
        for (int i = 0; i < this.cachedTracker.spells.length; ++i) {
            double dist;
            SpellBase spell;
            if (this.cachedTracker.cooldowns[i] != 0 || (spell = this.cachedTracker.spells[i]) == null || !((dist = shooter.func_70068_e(target)) < (double)(spell.getRange(is) * spell.getRange(is)))) continue;
            this.cachedTracker.castingSpell = spell;
            int n = i;
            this.cachedTracker.cooldowns[n] = this.cachedTracker.cooldowns[n] + (spell.getCoolDown() * 2 + 10);
            spell.onCastStart(shooter, this.getElement(is), is);
            return spell.getCastingTime();
        }
        return -1;
    }

    private void onUpdateEntity(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        SpellBase spell;
        if (this.cachedTracker != null && (spell = this.cachedTracker.castingSpell) != null && spell.shouldUpdate()) {
            spell.onUpdate((EntityLivingBase)entity, this.getElement(itemStack), itemStack, par4);
        }
    }

    @Override
    public Object getCooldownTracker(ItemStack is, Entity entity) {
        return new CoolDownTracker(is);
    }

    @Override
    public void onUpdateCooldown(ItemStack is, Entity entity, Object tracker) {
        this.cachedTracker = (CoolDownTracker)tracker;
        this.cachedTracker.onUpdate();
    }
}

