/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import java.util.Properties;
import java.util.Random;
import net.minecraft.world.World;

public class BuilderTemplate
extends BuilderBase {
    String folderName;
    int posY;

    @Override
    public BuilderBase load(Properties prop) {
        this.folderName = prop.getProperty("folder").trim();
        if (this.folderName == null) {
            return null;
        }
        this.posY = HelperReadConfig.getIntegerProperty(prop, "posY", 64);
        return this;
    }

    @Override
    public String getName() {
        return "templateFloating";
    }

    @Override
    public void generate(Random random, World world, int x, int z, int mob) {
        this.posY = Math.max(1, this.posY);
        Schematic schematic = BuilderHelper.getRandomNBTMap(this.folderName, random);
        short maxX = schematic.width;
        short maxY = schematic.length;
        this.generate(random, schematic, world, x - maxX / 2, this.posY, z - maxY / 2, mob);
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int idMob) {
        Schematic schematic = BuilderHelper.getRandomNBTMap(this.folderName, random);
        this.generate(random, schematic, world, i, j, k, idMob);
    }

    public void generate(Random random, Schematic schematic, World world, int i, int j, int k, int idMob) {
        BuilderHelper builderHelper = BuilderHelper.builderHelper;
        builderHelper.initialize();
        builderHelper.putSchematicInWorld(random, world, schematic, i, j, k, idMob);
        builderHelper.flush(world);
    }
}

