/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels.server.packetHandelers;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import need4speed402.mods.barrels.server.packet.PacketBarrel;
import need4speed402.mods.barrels.server.packet.PacketBarrelClient;
import need4speed402.mods.barrels.server.packet.PacketBarrelServer;
import need4speed402.mods.barrels.server.packetHandelers.PacketHandler;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketHandlerCustomPayload
extends PacketHandler {
    public static final String NETWORK_CHANNEL = "mod_barrels";
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private final Codec codec = new Codec();

    @Override
    public void init() {
        this.channels = NetworkRegistry.INSTANCE.newChannel(NETWORK_CHANNEL, new ChannelHandler[]{this.codec});
    }

    @Override
    public void sendPacket(PacketBarrel packet, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    @Override
    public void sendPacketToServer(PacketBarrel packet) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    @ChannelHandler.Sharable
    private class Codec
    extends MessageToMessageCodec<FMLProxyPacket, PacketBarrel> {
        private Codec() {
        }

        protected void encode(ChannelHandlerContext ctx, PacketBarrel msg, List<Object> out) throws Exception {
            ByteBuf buffer = Unpooled.buffer();
            msg.toBytes(buffer);
            out.add(new FMLProxyPacket(buffer, PacketHandlerCustomPayload.NETWORK_CHANNEL));
        }

        protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
            PacketBarrel packet = null;
            switch (msg.getTarget()) {
                case CLIENT: {
                    packet = new PacketBarrelClient();
                    break;
                }
                case SERVER: {
                    packet = new PacketBarrelServer();
                    break;
                }
            }
            if (packet != null) {
                packet.fromBytes(msg.payload());
                packet.func_148833_a(msg.handler());
                out.add((Object)packet);
            }
        }
    }
}

