/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels.server.packet;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.lib.Slot;
import need4speed402.mods.barrels.server.PacketType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;

public abstract class PacketBarrel
extends Packet {
    protected int x;
    protected int y;
    protected int z;
    protected ItemStack item;
    protected Slot[] playerSlots;
    protected int orientation = -1;
    protected int blockMetadata = -1;
    protected boolean[] frames = null;
    protected Object map = null;
    protected int itemMapID = -1;
    protected PacketType mode;

    public void func_148837_a(PacketBuffer in) throws IOException {
        this.fromBytes((ByteBuf)in);
    }

    public void fromBytes(ByteBuf in) throws IOException {
        Object[] o = Barrels.getPacketHandler().decode(new ByteBufInputStream(in));
        this.mode = (PacketType)((Object)o[0]);
        if (this.mode != PacketType.PLAYER && this.mode != PacketType.REQUEST_PLAYER) {
            this.x = (Integer)o[1];
            this.y = (Integer)o[2];
            this.z = (Integer)o[3];
        }
        switch (this.mode) {
            case REQUEST_MAP: 
            case REQUEST_ITEM: {
                break;
            }
            case METADATA: {
                this.blockMetadata = (Integer)o[4];
                break;
            }
            case FRAME: {
                this.frames = (boolean[])o[4];
                break;
            }
            case ORIENTATION: {
                this.orientation = (Integer)o[4];
                break;
            }
            case ITEM: 
            case ITEM_ALL: {
                this.item = (ItemStack)o[4];
                this.orientation = (Integer)o[5];
                this.frames = (boolean[])o[6];
                break;
            }
            case ITEM_PLAYER: 
            case ITEM_PLAYER_ALL: {
                this.item = (ItemStack)o[4];
                this.orientation = (Integer)o[5];
                this.frames = (boolean[])o[6];
                this.playerSlots = (Slot[])o[7];
                break;
            }
            case REQUEST_ITEM_PLAYER: {
                this.playerSlots = (Slot[])o[4];
                break;
            }
            case PLAYER: 
            case REQUEST_PLAYER: {
                this.playerSlots = (Slot[])o[1];
                break;
            }
            case MAP: {
                this.map = o[4];
                this.itemMapID = (Integer)o[5];
                break;
            }
            case COUNT_PLAYER: {
                this.playerSlots = (Slot[])o[5];
            }
            case COUNT: {
                this.item = new ItemStack((Item)null, ((Integer)o[4]).intValue(), 0);
            }
        }
    }

    public void func_148840_b(PacketBuffer out) throws IOException {
        this.toBytes((ByteBuf)out);
    }

    public void toBytes(ByteBuf out) throws IOException {
        this.mode.serialize(new ByteBufOutputStream(out), this);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Slot[] getPlayerSlots() {
        return this.playerSlots;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Object getMap() {
        return this.map;
    }

    public int getBlockMetadata() {
        return this.blockMetadata;
    }

    public boolean[] getFrames() {
        return this.frames;
    }

    public int getItemMapID() {
        return this.itemMapID;
    }

    private class ByteBufOutputStream
    extends OutputStream {
        private final ByteBuf buf;

        public ByteBufOutputStream(ByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public void write(int i) throws IOException {
            this.buf.writeByte(i);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.buf.writeBytes(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.buf.writeBytes(b, off, len);
        }
    }

    private class ByteBufInputStream
    extends InputStream {
        private final ByteBuf buf;

        public ByteBufInputStream(ByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            return this.buf.readByte() & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = Math.min(this.buf.readableBytes(), b.length);
            this.buf.readBytes(b);
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = Math.min(this.buf.readableBytes(), len);
            this.buf.readBytes(b, off, read);
            return read;
        }

        @Override
        public int available() throws IOException {
            return this.buf.readableBytes();
        }

        @Override
        public long skip(long n) throws IOException {
            long read = Math.min((long)this.buf.readableBytes(), n);
            this.buf.skipBytes((int)n);
            return read;
        }
    }
}

