/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.TileEntityBarrel;
import need4speed402.mods.barrels.client.BarrelStepSound;
import need4speed402.mods.barrels.lib.BarrelType;
import need4speed402.mods.barrels.lib.ClickMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBarrel
extends BlockContainer {
    public static final int STARTING_TIME = 20;
    public static final int CONTINOUS_TIME = 5;
    public static final int DOUBLE_CLICK_TIME = 10;
    public static final int FILL_TIME = 20;
    public static final int DELAY_PICKUP_TIME = 20;
    public static final int EMPLY_BARREL_TIME = 5;
    public static final boolean RELY_ON_SERVER = true;
    private final String name;

    public BlockBarrel(int id, String name) {
        super(Material.field_151575_d);
        this.name = name;
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(2.0f);
        this.func_149663_c("barrel");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 0 || side == 1) {
            return this.func_149691_a(side, world.func_72805_g(x, y, z));
        }
        TileEntityBarrel barrel = BlockBarrel.getTileEntity(world, x, y, z);
        if (barrel != null) {
            if (!(barrel.getItem() == null || barrel.getFrames()[Direction.field_71579_d[side]] || Barrels.renderOneSide() && barrel.getOrientation() != Direction.field_71579_d[side])) {
                return Barrels.getBarrels()[barrel.func_145832_p()].getTextures()[2];
            }
            return Barrels.getBarrels()[barrel.func_145832_p()].getTextures()[1];
        }
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return Barrels.getBarrels()[metadata].getTextures()[0];
        }
        return Barrels.getBarrels()[metadata].getTextures()[1];
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (BarrelType barrel : Barrels.getBarrels()) {
            IIcon[] icons = new IIcon[3];
            String barrelCode = Integer.toString(barrel.getStack().func_77960_j() + 1);
            icons[0] = register.func_94245_a("barrels:T" + barrelCode + "Top");
            icons[1] = register.func_94245_a("barrels:T" + barrelCode + "Side");
            String s = "T" + barrelCode + "RenderSide";
            icons[2] = ((Object)((Object)this)).getClass().getResource("assets/barrels/textures/blocks/" + s + ".png") != null ? register.func_94245_a("barrels:" + s) : icons[1];
            barrel.setTextures(icons);
        }
    }

    public static TileEntityBarrel getTileEntity(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == Barrels.getActiveBlock()) {
            TileEntity entity = world.func_147438_o(x, y, z);
            if (entity instanceof TileEntityBarrel) {
                return (TileEntityBarrel)entity;
            }
            if (world instanceof World) {
                entity = new TileEntityBarrel();
                entity.func_145834_a((World)world);
                entity.field_145851_c = x;
                entity.field_145848_d = y;
                entity.field_145849_e = z;
                ((World)world).func_147455_a(x, y, z, entity);
                return (TileEntityBarrel)entity;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        return barrel != null && barrel.getLastClicked() > 0;
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (barrel != null && player.func_70093_af() && barrel.getLastClicked() == 5) {
            barrel.setLastClicked(6);
            ItemStack item = barrel.getItem();
            if (item != null) {
                ItemStack item2 = null;
                if (item.field_77994_a > 1) {
                    item2 = item.func_77946_l();
                    --item2.field_77994_a;
                }
                item.field_77994_a = 1;
                ArrayList<Integer> changed = new ArrayList<Integer>(1);
                if (BlockBarrel.spawnItem(player, item, changed) == null) {
                    barrel.setItem(item2);
                    barrel.addChangedSlots(player, changed.toArray(new Integer[changed.size()]));
                }
            }
            if (world.field_72995_K) {
                ((BarrelStepSound)this.field_149762_H).ignoreNextCall(true);
            }
            return 0.0f;
        }
        float value = super.func_149737_a(player, world, x, y, z);
        if (value <= 0.0f && world.field_72995_K) {
            ((BarrelStepSound)this.field_149762_H).ignoreNextCall(true);
        }
        return value;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (barrel != null) {
            barrel.resetLastClicked();
            if (barrel.getLastClicked() > 0) {
                return -1.0f;
            }
        }
        return super.func_149712_f(world, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (barrel != null) {
            int side = 0;
            for (int i = 0; i < 4; ++i) {
                Block block = world.func_147439_a(x + Direction.field_71583_a[i], y, z + Direction.field_71581_b[i]);
                if (block == null) {
                    side = i;
                    break;
                }
                if (block.func_149662_c()) continue;
                side = i;
            }
            barrel.setOrientation(side);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (item.func_77942_o()) {
            barrel.read(item.func_77978_p());
        }
        if (barrel != null) {
            barrel.setOrientation(Direction.field_71580_e[Math.round(player.field_70177_z / 90.0f) & 3]);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        int powerInput = (world.func_72805_g(x + Direction.field_71583_a[side], y, z + Direction.field_71581_b[side]) & 4) == 0 ? 0 : world.func_94577_B(x, y, z);
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (barrel != null && barrel.getItem() != null) {
            int result = (int)Math.round((double)barrel.getItem().field_77994_a / (double)barrel.getInventorySize() * 15.0);
            if (result == 0) {
                result = 1;
            }
            if (result == 15 && barrel.getItem().field_77994_a != barrel.getInventorySize()) {
                result = 14;
            }
            return Math.max(powerInput, result);
        }
        return powerInput;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float blockX, float blockY, float blockZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (barrel == null) {
            return false;
        }
        int currentItem = player.field_71071_by.field_70461_c;
        if (currentItem < 0 || currentItem > 8) {
            return true;
        }
        ItemStack playerItem = player.field_71071_by.field_70462_a[currentItem];
        ItemStack item = barrel.getItem();
        ArrayList<Integer> changedSlots = new ArrayList<Integer>(1);
        if (barrel.isTimerActive()) {
            barrel.resetTimer();
            if (item != null) {
                if (barrel.getMode() == ClickMode.UPGRADE && barrel.getSelectedSlot() == currentItem) {
                    if (playerItem != null && playerItem.field_77994_a > 0 && Block.func_149634_a((Item)playerItem.func_77973_b()) == this && playerItem.func_77960_j() > barrel.func_145832_p()) {
                        playerItem = playerItem.func_77946_l();
                        if (playerItem.field_77994_a == 1) {
                            player.field_71071_by.field_70462_a[currentItem] = null;
                        } else {
                            --player.field_71071_by.field_70462_a[currentItem].field_77994_a;
                        }
                        if (BlockBarrel.spawnItem(player, new ItemStack((Block)this, 1, barrel.func_145832_p()), changedSlots) != null) {
                            player.field_71071_by.field_70462_a[currentItem] = playerItem;
                        } else {
                            world.func_72921_c(x, y, z, playerItem.func_77960_j(), 1);
                            barrel.field_145847_g = playerItem.func_77960_j();
                            if (world.field_72995_K) {
                                world.func_147471_g(x, y, z);
                            } else {
                                Barrels.getPacketHandler().sendClientsBlockChange(barrel, (Entity[])new EntityPlayer[]{player});
                            }
                            playerItem = player.field_71071_by.field_70462_a[currentItem];
                            changedSlots.add(currentItem);
                        }
                    }
                } else if (barrel.getMode() == ClickMode.INSERT && barrel.getSelectedSlot() == currentItem && (playerItem == null || barrel.equals(playerItem))) {
                    for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
                        ItemStack original = player.field_71071_by.func_70301_a(slot);
                        ItemStack newItem = barrel.addItem(original);
                        if (newItem != original) {
                            changedSlots.add(slot);
                        }
                        player.field_71071_by.func_70299_a(slot, newItem);
                    }
                } else if (playerItem != null) {
                    if (Block.func_149634_a((Item)playerItem.func_77973_b()) == this && playerItem.func_77960_j() > barrel.func_145832_p()) {
                        barrel.setClick(currentItem, ClickMode.UPGRADE, 10);
                        playerItem = barrel.addItem(playerItem);
                        changedSlots.add(currentItem);
                    } else if (item == null || barrel.equals(playerItem)) {
                        barrel.setClick(currentItem, ClickMode.INSERT, 10);
                        playerItem = barrel.addItem(playerItem);
                        changedSlots.add(currentItem);
                    }
                }
            }
        } else if (playerItem != null) {
            if (Block.func_149634_a((Item)playerItem.func_77973_b()) == this && item != null && Block.func_149634_a((Item)item.func_77973_b()) != this && playerItem.func_77960_j() > barrel.func_145832_p()) {
                barrel.setClick(currentItem, ClickMode.UPGRADE, 10);
                playerItem = barrel.addItem(playerItem);
                changedSlots.add(currentItem);
            } else if (barrel.getItem() == null || barrel.equals(playerItem)) {
                barrel.setClick(currentItem, ClickMode.INSERT, 10);
                playerItem = barrel.addItem(playerItem);
                changedSlots.add(currentItem);
            }
        }
        if (changedSlots.size() > 0) {
            player.field_71071_by.field_70462_a[currentItem] = playerItem;
            barrel.addChangedSlots(player, changedSlots.toArray(new Integer[changedSlots.size()]));
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (barrel == null) {
            return;
        }
        if (barrel.isAbrupted()) {
            ItemStack item = barrel.getItem();
            ItemStack playerItem = player.field_71071_by.func_70448_g();
            ArrayList<Integer> changedSlots = new ArrayList<Integer>(1);
            if (item != null) {
                if (barrel.isTimerActive() && barrel.getSelectedSlot() != player.field_71071_by.field_70461_c && playerItem == null && barrel.getMode() == ClickMode.FAST_EXTRACT && !player.func_70093_af()) {
                    barrel.resetTimer();
                    barrel.setItem(BlockBarrel.spawnItem(player, item, changedSlots));
                } else {
                    if (playerItem == null && !player.func_70093_af()) {
                        barrel.setClick(player.field_71071_by.field_70461_c, ClickMode.FAST_EXTRACT, 20);
                    } else {
                        barrel.resetTimer();
                    }
                    if (player.func_70093_af()) {
                        ItemStack item2 = item.func_77946_l();
                        --item2.field_77994_a;
                        item.field_77994_a = 1;
                        if ((item = BlockBarrel.spawnItem(player, item, changedSlots)) == null) {
                            item = item2;
                        } else {
                            item.field_77994_a += item2.field_77994_a;
                        }
                        if (item.field_77994_a <= 0) {
                            barrel.setItem(null);
                        } else {
                            barrel.setItem(item);
                        }
                    } else {
                        int maxStackSize = Math.min(player.field_71071_by.func_70297_j_(), item.func_77976_d());
                        ItemStack item2 = item.func_77946_l();
                        if (item.field_77994_a > maxStackSize) {
                            item2.field_77994_a -= maxStackSize;
                            item.field_77994_a = maxStackSize;
                        } else if (item.field_77994_a != 1 && Barrels.leaveOneItem()) {
                            item2.field_77994_a = 1;
                            --item.field_77994_a;
                        } else {
                            item2 = null;
                        }
                        item = BlockBarrel.spawnItem(player, item, changedSlots);
                        if (item2 != null) {
                            if (item == null) {
                                item = item2;
                            } else {
                                item.field_77994_a += item2.field_77994_a;
                            }
                        }
                        barrel.setItem(item);
                    }
                    if (barrel.getItem() == null) {
                        barrel.resetTimer();
                    }
                }
                barrel.setLastClicked(20);
            } else {
                barrel.resetTimer();
                barrel.setLastClicked(5);
            }
            if (changedSlots.size() > 0) {
                barrel.addChangedSlots(player, changedSlots.toArray(new Integer[changedSlots.size()]));
            }
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        this.dropBlockItems(world, player, x, y, z, world.func_72805_g(x, y, z));
        return super.removedByPlayer(world, player, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>(0);
    }

    private void dropBlockItems(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity == null || !(entity instanceof TileEntityBarrel)) {
            return;
        }
        TileEntityBarrel tile = (TileEntityBarrel)entity;
        if (!world.field_72995_K) {
            ItemStack item;
            ItemStack itemStack = item = player.field_71075_bZ.field_75098_d ? null : new ItemStack((Block)this, 1, metadata);
            if (Barrels.keepItemsWhenBroken()) {
                if (item != null) {
                    NBTTagCompound tag;
                    if (tile.getItem() == null) {
                        tag = null;
                    } else {
                        tag = new NBTTagCompound();
                        tile.write(tag);
                    }
                    item.func_77982_d(tag);
                }
            } else if (world.func_82736_K().func_82766_b("doTileDrops") && !player.field_71075_bZ.field_75098_d) {
                BlockBarrel.spawnItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, tile.getItem());
                int frameCount = 0;
                for (int i = 0; i < tile.getFrames().length; ++i) {
                    if (!tile.getFrames()[i]) continue;
                    ++frameCount;
                }
                if (frameCount != 0) {
                    BlockBarrel.spawnItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(Items.field_151160_bD, frameCount, 0));
                }
            }
            if (item != null) {
                BlockBarrel.spawnItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, item);
            }
        }
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        return new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (barrel != null && Arrays.binarySearch(this.getValidRotations(world, x, y, z), axis) != -1 && barrel.getOrientation() != Direction.field_71579_d[axis.ordinal()]) {
            barrel.setOrientation(Direction.field_71579_d[axis.ordinal()]);
            if (!world.field_72995_K) {
                Barrels.getPacketHandler().sendClientsOrientationChange(barrel);
            } else {
                world.func_147471_g(x, y, z);
            }
            return true;
        }
        return false;
    }

    public static ItemStack spawnItem(EntityPlayer player, ItemStack item, List<Integer> changedSlots) {
        if (player.field_70170_p.field_72995_K) {
            return item;
        }
        int currentSlot = player.field_71071_by.field_70461_c;
        if (currentSlot < 0 || currentSlot > 8) {
            return item;
        }
        int inventorySize = player.field_71071_by.field_70462_a.length;
        int maxStackSize = Math.min(player.field_71071_by.func_70297_j_(), item.func_77976_d());
        int pass = 0;
        int slot = 0;
        while (item != null) {
            if (pass == 0) {
                slot = currentSlot;
            } else if (slot == currentSlot) {
                ++slot;
            }
            ItemStack playerItem = player.field_71071_by.field_70462_a[slot];
            if (!(pass != 0 && pass != 2 || playerItem != null && playerItem.field_77994_a >= 1)) {
                playerItem = item.func_77946_l();
                if (item.field_77994_a > maxStackSize) {
                    playerItem.field_77994_a = maxStackSize;
                    item.field_77994_a -= playerItem.field_77994_a;
                } else {
                    item = null;
                }
                playerItem.field_77992_b = 5;
                if (changedSlots != null) {
                    changedSlots.add(slot);
                }
            } else if ((pass == 0 || pass == 1) && TileEntityBarrel.equals(playerItem, item) && playerItem.field_77994_a < maxStackSize) {
                if (item.field_77994_a + playerItem.field_77994_a > maxStackSize) {
                    int len = Math.min(item.field_77994_a, maxStackSize - playerItem.field_77994_a);
                    playerItem.field_77994_a += len;
                    item.field_77994_a -= len;
                } else {
                    playerItem.field_77994_a += item.field_77994_a;
                    item = null;
                }
                playerItem.field_77992_b = 5;
                if (changedSlots != null) {
                    changedSlots.add(slot);
                }
            }
            player.field_71071_by.field_70462_a[slot] = playerItem;
            if (pass == 0) {
                pass = 1;
                slot = 0;
                continue;
            }
            if (slot >= inventorySize - 1) {
                if (pass > 2) break;
                slot = -1;
                ++pass;
            }
            ++slot;
        }
        return item;
    }

    public static void spawnItem(World world, double x, double y, double z, ItemStack item) {
        if (item != null && !world.field_72995_K && item.field_77994_a > 0) {
            int stackSize = (int)Math.ceil((float)item.field_77994_a / (float)item.func_77976_d());
            int stacksToSpawn = stackSize < 64 ? stackSize : 64;
            int itemsPerStack = (int)Math.floor((float)item.field_77994_a / (float)stacksToSpawn);
            item = item.func_77946_l();
            while (item.field_77994_a >= itemsPerStack) {
                ItemStack newStack = item.func_77946_l();
                newStack.field_77994_a = itemsPerStack;
                item.field_77994_a -= newStack.field_77994_a;
                EntityItem entity = new EntityItem(world, x, y, z, newStack);
                entity.field_145804_b = 20;
                world.func_72838_d((Entity)entity);
            }
            if (item.field_77994_a > 0) {
                EntityItem entity = new EntityItem(world, x, y, z, item);
                entity.field_145804_b = 20;
                world.func_72838_d((Entity)entity);
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityBarrel();
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        boolean pickedItemFrame = false;
        TileEntityBarrel barrel = BlockBarrel.getTileEntity((IBlockAccess)world, x, y, z);
        if (barrel != null && Direction.field_71579_d[target.field_72310_e] != -1 && barrel.getFrames()[Direction.field_71579_d[target.field_72310_e]]) {
            Vec3 vector = target.field_72307_f;
            double xHit = vector.field_72450_a - Math.floor(vector.field_72450_a);
            double yHit = vector.field_72448_b - Math.floor(vector.field_72448_b);
            double zHit = vector.field_72449_c - Math.floor(vector.field_72449_c);
            if (yHit > 0.0625 && yHit < 0.8125) {
                double d = xHit == 0.0 ? zHit : xHit;
                if (d > 0.125) {
                    double d2 = xHit == 0.0 ? zHit : xHit;
                    if (d2 < 0.875) {
                        return new ItemStack(Items.field_151160_bD, 1, 0);
                    }
                }
            }
        }
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (BarrelType barrel : Barrels.getBarrels()) {
            if (barrel == null) continue;
            list.add(barrel.getStack());
        }
    }
}

