/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels.server.packetHandelers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import need4speed402.mods.barrels.TileEntityBarrel;
import need4speed402.mods.barrels.lib.Slot;
import need4speed402.mods.barrels.server.PacketType;
import need4speed402.mods.barrels.server.packet.PacketBarrel;
import need4speed402.mods.barrels.server.packet.PacketBarrelClient;
import need4speed402.mods.barrels.server.packet.PacketBarrelServer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public abstract class PacketHandler {
    public void updateClients(TileEntityBarrel barrel, boolean sendAdditional) {
        this.updateClients(barrel, sendAdditional, null);
    }

    public void updateClients(TileEntityBarrel barrel, boolean sendAdditional, Entity[] exclude) {
        this.sendPacket(barrel.field_145851_c, barrel.field_145849_e, barrel.func_145831_w(), new PacketBarrelClient(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e, barrel.getRawItem(), barrel.getOrientation(), barrel.getFrames(), sendAdditional, null), exclude);
    }

    public void updateClientsItemCount(TileEntityBarrel barrel, Entity[] exclude) {
        this.sendPacket(barrel.field_145851_c, barrel.field_145849_e, barrel.func_145831_w(), new PacketBarrelClient(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e, barrel.getRawItem().field_77994_a, null), exclude);
    }

    public void updateClientItemCount(EntityPlayerMP player, TileEntityBarrel barrel, Slot[] slots) {
        this.sendPacket(new PacketBarrelClient(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e, barrel.getRawItem().field_77994_a, slots), player);
    }

    public void updateClient(EntityPlayerMP player, TileEntityBarrel barrel, boolean sendAdditional, Slot[] slots) {
        this.sendPacket(new PacketBarrelClient(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e, barrel.getRawItem(), barrel.getOrientation(), barrel.getFrames(), sendAdditional, slots), player);
    }

    public void sendClientsOrientationChange(TileEntityBarrel barrel) {
        this.sendClientsOrientationChange(barrel, null);
    }

    public void sendClientsOrientationChange(TileEntityBarrel barrel, Entity[] exception) {
        this.sendPacket(barrel.field_145851_c, barrel.field_145849_e, barrel.func_145831_w(), new PacketBarrelClient(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e, barrel.getOrientation(), false), exception);
    }

    public void sendClientsFrameChange(TileEntityBarrel barrel) {
        this.sendClientsFrameChange(barrel, null);
    }

    public void sendClientsFrameChange(TileEntityBarrel barrel, Entity[] player) {
        this.sendPacket(barrel.field_145851_c, barrel.field_145849_e, barrel.func_145831_w(), new PacketBarrelClient(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e, barrel.getFrames()), player);
    }

    public void sendServerRequestForItem(int x, int y, int z) {
        this.sendPacketToServer(new PacketBarrelServer(x, y, z, true));
    }

    public void sendServerRequestForPlayerInventory(int x, int y, int z, Slot[] slots) {
        this.sendPacketToServer(new PacketBarrelServer(x, y, z, slots));
    }

    public void encode(OutputStream out, int x, int y, int z, ItemStack item, int side, boolean[] attachedFrames, boolean sendAll, Slot[] playerSlots) throws IOException {
        if (playerSlots != null && playerSlots.length == 0) {
            playerSlots = null;
        }
        DataOutputStream data = new DataOutputStream(out);
        int itemID = item == null ? 0 : Item.func_150891_b((Item)item.func_77973_b());
        int sizeStack = 0;
        int sizeMeta = 0;
        boolean sendAsBlock = item != null && (itemID & 0xFFFFF000) == 0 && (item.func_77960_j() & 0xFFFFFFF0) == 0;
        boolean sendExtraByte = item != null && sendAll;
        boolean sendNBTData = item != null && (item.func_77978_p() != null || playerSlots != null);
        int sendFrames = -1;
        int packed = 0;
        if (item == null) {
            int mode = 0;
            int frameBits = 0;
            for (int i = 0; i < attachedFrames.length; ++i) {
                if (!attachedFrames[i]) continue;
                frameBits = (byte)(frameBits | 1 << i);
            }
            if (frameBits == 15) {
                mode = 1;
            } else if (frameBits == 0) {
                mode = 2;
            } else if (sendAll) {
                mode = 3;
                sendFrames = frameBits;
            }
            packed |= 0xC0 | side & 3 | mode << 4 | (playerSlots != null ? 8 : 0);
        } else {
            sizeMeta = this.getLength(item.func_77960_j());
            if ((itemID & 0xFFFF0000) == 0 && (item.func_77960_j() & 0xFFFFFFF0) == 0) {
                sendExtraByte = true;
                sendAsBlock = true;
            } else if (!sendAsBlock && (itemID & 0x100) != 0 && (itemID & 0xFFFFFE00) == 0) {
                sendExtraByte = true;
                sendAsBlock = false;
            } else if (!sendAsBlock && item.func_77960_j() == 0) {
                sendExtraByte = true;
            }
            if (sendExtraByte) {
                packed |= 0x80;
            }
            if (sendNBTData) {
                packed |= 0x20;
            }
            if (sendAsBlock) {
                packed |= 0x10;
            }
            sizeStack = this.getLength(item.field_77994_a);
            packed |= sizeStack << 2;
            packed = sendAsBlock ? (packed |= side & 3) : (packed |= sizeMeta);
        }
        data.write(packed);
        out.write(this.encodeCoordinates(x, y, z));
        if (item == null) {
            if (sendFrames != -1) {
                data.write(sendFrames);
            }
            if (playerSlots != null) {
                this.encodePlayerInventory(data, playerSlots, item);
            }
        } else {
            int i;
            boolean ignoreMeta = false;
            if (sendExtraByte) {
                int packed2 = 0;
                if (!sendAsBlock) {
                    packed2 |= (side & 3) << 6;
                }
                if (sendAsBlock) {
                    packed2 |= (itemID & 0xF000) >> 8;
                } else if ((itemID & 0xFFFFFE00) == 0) {
                    packed2 |= 0x20 | (itemID & 0x100) >> 4;
                } else {
                    ignoreMeta = item.func_77960_j() == 0;
                    packed2 |= ignoreMeta ? 16 : 0;
                }
                for (int i2 = 0; i2 < attachedFrames.length; ++i2) {
                    if (!attachedFrames[i2]) continue;
                    packed2 |= 1 << i2;
                }
                data.write(packed2);
            }
            if (sendAsBlock) {
                data.write(itemID >> 4);
                data.write(itemID << 4 | item.func_77960_j() & 0xF);
            } else {
                if (sendExtraByte && (itemID & 0xFFFFFE00) == 0) {
                    data.write(itemID);
                } else {
                    data.writeShort(itemID);
                }
                if (!ignoreMeta) {
                    for (i = 0; i <= sizeMeta; ++i) {
                        data.write(item.func_77960_j() >> i * 8);
                    }
                }
            }
            for (i = 0; i <= sizeStack; ++i) {
                data.write(item.field_77994_a >> i * 8);
            }
            if (sendNBTData) {
                data.write((playerSlots != null ? 1 : 0) | (item.func_77978_p() != null ? 2 : 0));
                Object tag = null;
                if (playerSlots != null) {
                    this.encodePlayerInventory(data, playerSlots, item);
                }
                if (item.func_77978_p() != null) {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)item.func_77978_p(), (OutputStream)data);
                }
            }
        }
    }

    private int getLength(int i) {
        if ((i & 0xFFFFFF00) == 0) {
            return 0;
        }
        if ((i & 0xFFFF0000) == 0) {
            return 1;
        }
        if ((i & 0xFF000000) == 0) {
            return 2;
        }
        return 3;
    }

    public void encodeCount(OutputStream out, int x, int y, int z, int count) throws IOException {
        out.write(115);
        out.write(this.encodeCoordinates(x, y, z));
        int len = this.getLength(count);
        out.write(len);
        for (int i = 0; i <= len; ++i) {
            out.write(count >> i * 8);
        }
    }

    public void encodeCount(OutputStream out, int x, int y, int z, int count, Slot[] playerSlots) throws IOException {
        out.write(119);
        out.write(this.encodeCoordinates(x, y, z));
        int len = this.getLength(count);
        out.write(len);
        for (int i = 0; i <= len; ++i) {
            out.write(count >> i * 8);
        }
        this.encodePlayerInventory(out, playerSlots, null);
    }

    private void encodePlayerInventory(OutputStream data, Slot[] slots, ItemStack def) throws IOException {
        if (slots != null && slots.length > 0) {
            int itemIDSize = 0;
            boolean itemStackSize = false;
            int itemMetadataSize = 0;
            int encoded = 0;
            boolean[] encodedSlots = new boolean[slots.length];
            do {
                Slot slot = new Slot(-1, def);
                boolean itemDoesNotMatch = true;
                int slotIndex = -1;
                Slot goTo = null;
                for (int i = 0; i < slots.length; ++i) {
                    if (encodedSlots[i]) continue;
                    if (TileEntityBarrel.equals(slots[i].getItem(), slot.getItem())) {
                        slotIndex = i;
                        slot = slots[i];
                        itemDoesNotMatch = false;
                        break;
                    }
                    if (goTo != null) continue;
                    slotIndex = i;
                    goTo = slots[i];
                }
                if (itemDoesNotMatch) {
                    slot = goTo;
                }
                ++encoded;
                if (slotIndex != -1) {
                    encodedSlots[slotIndex] = true;
                }
                data.write(slot.getSlot() & 0x3F | (slot.getSlot() > 63 || encoded >= slots.length ? 64 : 0) | (itemDoesNotMatch || slot.getItem() != null && (slot.getItem().field_77994_a & 0xFFFFFF00) != 0 ? 128 : 0));
                if (slot.getSlot() > 63 || encoded >= slots.length) {
                    data.write(slot.getSlot() >> 6 & 0x7F | (encoded >= slots.length ? 128 : 0));
                }
                if (itemDoesNotMatch || slot.getItem() != null && (slot.getItem().field_77994_a & 0xFFFFFF00) != 0) {
                    if (slot.getItem() != null) {
                        int slotItemID = Item.func_150891_b((Item)slot.getItem().func_77973_b());
                        if ((slot.getItem().field_77994_a & 0xFFFFFF00) != 0) {
                            int ii;
                            int stackLen = this.getLength(slot.getItem().field_77994_a);
                            data.write(stackLen | 0x40 | (itemDoesNotMatch ? 32 : 0));
                            if (itemDoesNotMatch) {
                                itemIDSize = this.getLength(slotItemID);
                                itemMetadataSize = this.getLength(slot.getItem().func_77960_j());
                                data.write(itemIDSize | (slot.getItem().func_77960_j() == 0 ? 16 : 0) | itemMetadataSize << 5 | (slot.getItem().func_77978_p() == null ? 0 : 128));
                                for (ii = 0; ii <= itemIDSize; ++ii) {
                                    data.write(slotItemID >> ii * 8);
                                }
                                if (slot.getItem().func_77960_j() != 0) {
                                    for (ii = 0; ii <= itemMetadataSize; ++ii) {
                                        data.write(slot.getItem().func_77960_j() >> ii * 8);
                                    }
                                }
                                if (slot.getItem().func_77978_p() != null) {
                                    byte[] buf = CompressedStreamTools.func_74798_a((NBTTagCompound)slot.getItem().func_77978_p());
                                    data.write(buf.length >> 8);
                                    data.write(buf.length);
                                    data.write(buf);
                                }
                            }
                            for (ii = 0; ii <= stackLen; ++ii) {
                                data.write(slot.getItem().field_77994_a >> ii * 8);
                            }
                        } else {
                            int ii;
                            itemIDSize = this.getLength(slotItemID);
                            itemMetadataSize = this.getLength(slot.getItem().func_77960_j());
                            data.write(itemIDSize | (slot.getItem().func_77960_j() == 0 ? 16 : 0) | itemMetadataSize << 5 | (slot.getItem().func_77978_p() == null ? 0 : 128));
                            for (ii = 0; ii <= itemIDSize; ++ii) {
                                data.write(slotItemID >> ii * 8);
                            }
                            if (slot.getItem().func_77960_j() != 0) {
                                for (ii = 0; ii <= itemMetadataSize; ++ii) {
                                    data.write(slot.getItem().func_77960_j() >> ii * 8);
                                }
                            }
                            if (slot.getItem().func_77978_p() != null) {
                                byte[] buf = CompressedStreamTools.func_74798_a((NBTTagCompound)slot.getItem().func_77978_p());
                                data.write(buf.length >> 8);
                                data.write(buf.length);
                                data.write(buf);
                            }
                        }
                    } else {
                        data.write(192);
                    }
                }
                if (slot.getItem() == null || (slot.getItem().field_77994_a & 0xFFFFFF00) != 0) continue;
                data.write(slot.getItem().field_77994_a);
            } while (encoded < slots.length);
        }
    }

    private Slot[] decodeSlots(InputStream data, ItemStack startingItem) throws IOException {
        int itemID = 0;
        int stacksize = 0;
        int metadata = 0;
        ItemStack playerItem = startingItem;
        ArrayList<Slot> slots = new ArrayList<Slot>();
        boolean end = false;
        do {
            int slot;
            if (((slot = data.read()) & 0x40) != 0) {
                int packed = data.read();
                slot |= (packed & 0x7F) << 6;
                if ((packed & 0x80) != 0) {
                    end = true;
                }
            }
            if ((slot & 0x80) != 0) {
                int info = data.read();
                if ((info & 0x40) == 0) {
                    int i;
                    for (i = 0; i <= (info & 3); ++i) {
                        itemID |= data.read() << i * 8;
                    }
                    if ((info & 0x10) == 0) {
                        for (i = 0; i <= (info >> 2 & 3); ++i) {
                            metadata |= data.read() << i * 8;
                        }
                    }
                    playerItem = new ItemStack(Item.func_150899_d((int)itemID), 0, metadata);
                    if ((info & 0x80) != 0) {
                        byte[] buf = new byte[data.read() << 8 | data.read()];
                        data.read(buf);
                        playerItem.func_77982_d(CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(buf)));
                    }
                    if (playerItem != null) {
                        stacksize = data.read();
                    }
                } else if ((info & 0x80) == 0) {
                    if ((info & 0x20) != 0) {
                        int i;
                        int newInfo = data.read();
                        for (i = 0; i <= (newInfo & 3); ++i) {
                            itemID |= data.read() << i * 8;
                        }
                        if ((newInfo & 0x10) == 0) {
                            for (i = 0; i <= (newInfo >> 2 & 3); ++i) {
                                metadata |= data.read() << i * 8;
                            }
                        }
                        playerItem = new ItemStack(Item.func_150899_d((int)itemID), 0, metadata);
                        if ((newInfo & 0x80) != 0) {
                            byte[] buf = new byte[data.read() << 8 | data.read()];
                            data.read(buf);
                            playerItem.func_77982_d(CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(buf)));
                        }
                    }
                    stacksize = 0;
                    for (int i = 0; i <= (info & 3); ++i) {
                        stacksize |= data.read() << i * 8;
                    }
                } else {
                    playerItem = null;
                }
            } else if (playerItem != null) {
                stacksize = data.read();
            }
            if (playerItem != null) {
                ItemStack temp = playerItem.func_77946_l();
                temp.field_77994_a = stacksize;
                slots.add(new Slot(slot & 0x3F, temp));
                continue;
            }
            slots.add(new Slot(slot & 0x3F, null));
        } while (!end);
        return slots.toArray(new Slot[slots.size()]);
    }

    private byte[] encodeCoordinates(int x, int y, int z) {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int lengthX = this.getLength(Math.abs(x));
        int lengthY = this.getLength(Math.abs(y));
        int lengthZ = this.getLength(Math.abs(z));
        out.write(lengthX | lengthY << 2 | lengthZ << 4 | (x < 0 ? 64 : 0) | (z < 0 ? 128 : 0));
        for (i = 0; i <= lengthX; ++i) {
            out.write(Math.abs(x) >> i * 8);
        }
        for (i = 0; i <= lengthY; ++i) {
            out.write(Math.abs(y) >> i * 8);
        }
        for (i = 0; i <= lengthZ; ++i) {
            out.write(Math.abs(z) >> i * 8);
        }
        return out.toByteArray();
    }

    private int[] decodeCoordinates(InputStream in) throws IOException {
        int i;
        int x = 0;
        int y = 0;
        int z = 0;
        int packed = in.read();
        int lengthX = packed >> 0 & 3;
        int lengthY = packed >> 2 & 3;
        int lengthZ = packed >> 4 & 3;
        for (i = 0; i <= lengthX; ++i) {
            x |= in.read() << i * 8;
        }
        for (i = 0; i <= lengthY; ++i) {
            y |= in.read() << i * 8;
        }
        for (i = 0; i <= lengthZ; ++i) {
            z |= in.read() << i * 8;
        }
        if ((packed & 0x40) != 0) {
            x = -x;
        }
        if ((packed & 0x80) != 0) {
            z = -z;
        }
        return new int[]{x, y, z};
    }

    public void encodeFrames(OutputStream out, int x, int y, int z, boolean[] frames) throws IOException {
        int frame = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i]) continue;
            frame |= 1 << i;
        }
        out.write(0x40 | frame);
        out.write(this.encodeCoordinates(x, y, z));
    }

    public void sendClientsBlockChange(TileEntityBarrel barrel) {
        this.sendClientsBlockChange(barrel, null);
    }

    public void sendClientsBlockChange(TileEntityBarrel barrel, Entity[] exception) {
        this.sendPacket(barrel.field_145851_c, barrel.field_145849_e, barrel.func_145831_w(), new PacketBarrelClient(barrel.field_145851_c, barrel.field_145848_d, barrel.field_145849_e, barrel.func_145832_p(), true), exception);
    }

    public void encodeMetadata(OutputStream out, int x, int y, int z, int metadata) throws IOException {
        DataOutputStream data = new DataOutputStream(out);
        data.write(0x50 | metadata);
        out.write(this.encodeCoordinates(x, y, z));
    }

    public void encodeOrientaion(OutputStream out, int x, int y, int z, int orientation) throws IOException {
        DataOutputStream data = new DataOutputStream(out);
        data.write(0x60 | orientation);
        out.write(this.encodeCoordinates(x, y, z));
    }

    public void encodeMapData(OutputStream out, int x, int y, int z, MapData map, int mapID) throws IOException {
        out.write(118);
        out.write(this.encodeCoordinates(x, y, z));
        DataOutputStream data = new DataOutputStream(out);
        int len = this.getLength(mapID);
        data.write(len);
        for (int i = 0; i <= len; ++i) {
            data.write(mapID >> i * 8);
        }
        NBTTagCompound tag = new NBTTagCompound();
        map.func_76187_b(tag);
        CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)out);
    }

    public void encodeRequestMapData(OutputStream out, int x, int y, int z) {
        try {
            out.write(117);
            out.write(this.encodeCoordinates(x, y, z));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void encodeRequestPlayerSlot(OutputStream out, Slot[] slots) throws IOException {
        out.write(115);
        int index = 0;
        for (Slot i : slots) {
            out.write(i.getSlot() & 0x7F | (++index >= slots.length ? 128 : 0));
        }
    }

    public void encodeRequestItem(OutputStream out, int x, int y, int z, Slot[] slots, boolean sendItem) {
        try {
            out.write(0x70 | (slots != null ? (sendItem ? 2 : 1) : 4));
            out.write(this.encodeCoordinates(x, y, z));
            if (slots != null) {
                int index = 0;
                for (Slot i : slots) {
                    out.write(i.getSlot() & 0x7F | (++index >= slots.length ? 128 : 0));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Someting that sould never happen happens", e);
        }
    }

    public void encodePlayer(OutputStream out, Slot[] slots) throws IOException {
        out.write(120);
        this.encodePlayerInventory(out, slots, null);
    }

    protected void sendPacket(int x, int z, World world, PacketBarrel packet, Entity[] exception) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            boolean found = false;
            if (exception != null) {
                for (Entity e : exception) {
                    if (e != player) continue;
                    found = true;
                }
            }
            if (found || player.field_70170_p != world || !player.func_71121_q().func_73040_p().func_72694_a(player, chunkX, chunkZ)) continue;
            this.sendPacket(packet, player);
        }
    }

    public abstract void sendPacket(PacketBarrel var1, EntityPlayerMP var2);

    public abstract void sendPacketToServer(PacketBarrel var1);

    public Object[] decode(InputStream stream) throws IOException {
        Slot[] playerSlots;
        int mapID;
        NBTTagCompound map;
        int orentation;
        int itemCount;
        ItemStack item;
        int blockMetadata;
        boolean[] frames;
        PacketType type;
        int z;
        int y;
        int x;
        block62: {
            int packed;
            DataInputStream data;
            block61: {
                x = 0;
                y = 0;
                z = 0;
                type = null;
                frames = null;
                blockMetadata = -1;
                item = null;
                itemCount = -1;
                orentation = -1;
                map = null;
                mapID = -1;
                playerSlots = null;
                data = new DataInputStream(stream);
                packed = data.read();
                if ((packed & 0xFE) != 112) {
                    int[] coords = this.decodeCoordinates(data);
                    x = coords[0];
                    y = coords[1];
                    z = coords[2];
                }
                if ((packed & 0xC0) != 64) break block61;
                block0 : switch ((packed & 0x30) >> 4) {
                    case 0: {
                        type = PacketType.FRAME;
                        frames = new boolean[4];
                        for (int i = 0; i < frames.length; ++i) {
                            frames[i] = (packed & 1 << i) != 0;
                        }
                        break block62;
                    }
                    case 1: {
                        type = PacketType.METADATA;
                        blockMetadata = packed & 0xF;
                        break;
                    }
                    case 2: {
                        type = PacketType.ORIENTATION;
                        orentation = packed & 3;
                        break;
                    }
                    case 3: {
                        switch (packed & 0xF) {
                            case 0: {
                                type = PacketType.PLAYER;
                                playerSlots = this.decodeSlots(data, null);
                                break block0;
                            }
                            case 1: {
                                int slot;
                                type = PacketType.REQUEST_PLAYER;
                                ArrayList<Slot> slots = new ArrayList<Slot>();
                                do {
                                    slot = data.readUnsignedByte();
                                    slots.add(new Slot(slot & 0x7F, null));
                                } while ((slot & 0x80) == 0);
                                playerSlots = slots.toArray(new Slot[slots.size()]);
                                break block0;
                            }
                            case 2: {
                                int slot;
                                type = PacketType.REQUEST_ITEM_PLAYER;
                                ArrayList<Slot> slots = new ArrayList();
                                do {
                                    slot = data.readUnsignedByte();
                                    slots.add(new Slot(slot & 0x7F, null));
                                } while ((slot & 0x80) == 0);
                                playerSlots = slots.toArray(new Slot[slots.size()]);
                                break block0;
                            }
                            case 3: {
                                type = PacketType.COUNT;
                                itemCount = 0;
                                int amount = data.read();
                                for (int i = 0; i <= amount; ++i) {
                                    itemCount |= data.read() << i * 8;
                                }
                                break block62;
                            }
                            case 4: {
                                type = PacketType.REQUEST_ITEM;
                                break block0;
                            }
                            case 5: {
                                type = PacketType.REQUEST_MAP;
                                break block0;
                            }
                            case 6: {
                                type = PacketType.MAP;
                                mapID = 0;
                                int amount = data.read();
                                for (int i = 0; i <= amount; ++i) {
                                    mapID |= data.read() << i * 8;
                                }
                                map = CompressedStreamTools.func_74796_a((InputStream)data);
                                break block0;
                            }
                            case 7: {
                                type = PacketType.COUNT_PLAYER;
                                itemCount = 0;
                                int amount = data.read();
                                for (int i = 0; i <= amount; ++i) {
                                    itemCount |= data.read() << i * 8;
                                }
                                playerSlots = this.decodeSlots(data, null);
                            }
                        }
                    }
                }
                break block62;
            }
            type = PacketType.ITEM;
            if ((packed & 0x40) != 0) {
                item = null;
                orentation = packed & 3;
                int mode = (packed & 0x30) >> 4;
                switch (mode) {
                    case 1: {
                        frames = new boolean[4];
                        Arrays.fill(frames, true);
                        break;
                    }
                    case 2: {
                        frames = new boolean[4];
                        break;
                    }
                    case 3: {
                        int f = data.read();
                        frames = new boolean[4];
                        for (int i = 0; i < frames.length; ++i) {
                            frames[i] = (f & 1 << i) != 0;
                        }
                        break;
                    }
                }
                if ((packed & 8) != 0) {
                    playerSlots = this.decodeSlots(data, null);
                }
            } else {
                int additionalData = -1;
                if ((packed & 0x80) != 0) {
                    additionalData = data.read();
                }
                int blockid = 0;
                int metadata = 0;
                int stackSize = 0;
                if ((packed & 0x10) != 0) {
                    blockid = data.read() << 4;
                    int blah = data.read();
                    blockid |= blah >> 4;
                    if (additionalData != -1) {
                        blockid |= (additionalData & 0xF0) << 8;
                    }
                    metadata = blah & 0xF;
                    orentation = packed & 3;
                } else {
                    boolean ignoreMeta = false;
                    if (additionalData != -1 && (additionalData & 0x20) != 0) {
                        blockid = data.readUnsignedByte() | (additionalData & 0x10) << 4;
                    } else {
                        blockid = data.readUnsignedShort();
                        if (additionalData != -1) {
                            boolean bl = ignoreMeta = (additionalData & 0x10) != 0;
                        }
                    }
                    if (!ignoreMeta) {
                        for (int i = 0; i <= (packed & 3); ++i) {
                            metadata |= data.read() << i * 8;
                        }
                    }
                    if (additionalData != -1) {
                        orentation = (additionalData & 0xC0) >> 6;
                    }
                }
                for (int i = 0; i <= (packed & 0xC) >> 2; ++i) {
                    stackSize |= data.read() << i * 8;
                }
                item = new ItemStack(Item.func_150899_d((int)blockid), stackSize, metadata);
                if (additionalData != -1) {
                    frames = new boolean[4];
                    for (int i = 0; i < frames.length; ++i) {
                        frames[i] = (additionalData & 1 << i) != 0;
                    }
                }
                if ((packed & 0x20) != 0) {
                    boolean readPlayerSlots;
                    int mode = data.read();
                    boolean bl = readPlayerSlots = (mode & 1) != 0;
                    if (readPlayerSlots) {
                        type = PacketType.ITEM_PLAYER;
                        playerSlots = this.decodeSlots(data, item);
                    }
                    if ((mode & 2) != 0) {
                        item.func_77982_d(CompressedStreamTools.func_74796_a((InputStream)data));
                    }
                }
            }
        }
        switch (type) {
            case REQUEST_MAP: 
            case REQUEST_ITEM: {
                return new Object[]{type, x, y, z};
            }
            case REQUEST_PLAYER: 
            case PLAYER: {
                return new Object[]{type, playerSlots};
            }
            case REQUEST_ITEM_PLAYER: {
                return new Object[]{type, x, y, z, playerSlots};
            }
            case ITEM: 
            case ITEM_ALL: {
                return new Object[]{type, x, y, z, item, orentation, frames};
            }
            case ITEM_PLAYER: 
            case ITEM_PLAYER_ALL: {
                return new Object[]{type, x, y, z, item, orentation, frames, playerSlots};
            }
            case METADATA: {
                return new Object[]{type, x, y, z, blockMetadata};
            }
            case FRAME: {
                return new Object[]{type, x, y, z, frames};
            }
            case ORIENTATION: {
                return new Object[]{type, x, y, z, orentation};
            }
            case MAP: {
                return new Object[]{type, x, y, z, map, mapID};
            }
            case COUNT: {
                return new Object[]{type, x, y, z, itemCount};
            }
            case COUNT_PLAYER: {
                return new Object[]{type, x, y, z, itemCount, playerSlots};
            }
        }
        throw new IOException("Invalid type: " + (Object)((Object)type));
    }

    public abstract void init();

    private class ItemIdentifyer {
        private final String name;
        private final int id;

        public ItemIdentifyer(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

