/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.TileEntityBarrel;
import need4speed402.mods.barrels.lib.EntityItemFrame;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureCompass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BarrelRender
extends TileEntitySpecialRenderer {
    private static final BarrelRender instance = new BarrelRender();
    private final Map<ItemIdentifyer, String> OVERLAY_CHACHE = new HashMap<ItemIdentifyer, String>(1000);
    private final Minecraft mc = Minecraft.func_71410_x();
    private final GameSettings settings;
    private final Tessellator tessellator;
    private final Render frameRender;
    private final EntityItemFrame dummyFrame;
    private final EntityItem dummyItem;
    private final ResourceLocation itemGlint;
    private final ResourceLocation mapBackround;
    private final DynamicTexture mapTexture;
    public final RenderBlocks blockRender;
    public final int MAX_STRING_WIDTH = 90;
    public final String INFINITY = "\u221e";

    public static BarrelRender getInstance() {
        return instance;
    }

    private BarrelRender() {
        this.settings = this.mc.field_71474_y;
        this.tessellator = Tessellator.field_78398_a;
        this.frameRender = (Render)RenderManager.field_78727_a.field_78729_o.get(net.minecraft.entity.item.EntityItemFrame.class);
        this.dummyFrame = new EntityItemFrame(null, 0, 0, 0, 0);
        this.dummyItem = new EntityItem(null);
        this.itemGlint = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        this.mapBackround = new ResourceLocation("textures/map/map_background.png");
        this.mapTexture = new DynamicTexture(128, 128);
        this.blockRender = new RenderBlocks();
        this.MAX_STRING_WIDTH = 90;
        this.INFINITY = "\u221e";
    }

    private void renderText(String text) {
        if (text != null) {
            int stringWidth = this.func_147498_b().func_78256_a(text);
            if (stringWidth >= 90) {
                text = "\u221e";
                stringWidth = this.func_147498_b().func_78256_a(text);
                GL11.glTranslatef((float)0.0f, (float)0.21f, (float)0.0f);
                GL11.glScalef((float)0.04f, (float)0.04f, (float)1.0f);
            } else {
                GL11.glScalef((float)0.01f, (float)0.01f, (float)1.0f);
            }
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_147498_b().func_78276_b(text, -stringWidth / 2, 2, -1);
        }
    }

    private void renderTextWithResize(String text) {
        if (text != null) {
            int stringWidth = this.func_147498_b().func_78256_a(text);
            float scale = Math.min(1.0f / (float)(stringWidth + 10), 0.01f);
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_147498_b().func_78276_b(text, -stringWidth / 2, 2, -1);
        }
    }

    public void renderItem(World world, ItemStack stack) {
        TextureManager manager = this.mc.field_71446_o;
        GL11.glTranslatef((float)0.0f, (float)-0.0625f, (float)0.0f);
        float scale = 0.3125f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        IItemRenderer.ItemRenderType type = Barrels.renderIn3D() ? IItemRenderer.ItemRenderType.ENTITY : IItemRenderer.ItemRenderType.INVENTORY;
        IItemRenderer.ItemRendererHelper helper = Barrels.renderIn3D() ? IItemRenderer.ItemRendererHelper.BLOCK_3D : IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK;
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)stack, (IItemRenderer.ItemRenderType)type);
        Item item = stack.func_77973_b();
        int color = item.func_82790_a(stack, 0);
        float a = 1.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        if (customRenderer != null) {
            manager.func_110577_a(TextureMap.field_110575_b);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.005f);
            GL11.glScalef((float)1.3f, (float)1.3f, (float)1.3f);
            if (customRenderer.shouldUseRenderHelper(type, stack, helper)) {
                if (Barrels.renderIn3D()) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glScalef((float)1.0f, (float)1.0f, (float)0.001f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            if (Barrels.renderIn3D() && !customRenderer.shouldUseRenderHelper(type, stack, IItemRenderer.ItemRendererHelper.ENTITY_BOBBING)) {
                GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
            }
            RenderItem.field_82407_g = Barrels.renderIn3D();
            this.blockRender.field_147844_c = true;
            if (Barrels.renderIn3D()) {
                this.dummyItem.func_70029_a(world);
                this.dummyItem.field_71093_bK = world.field_73011_w.field_76574_g;
                this.dummyItem.field_70290_d = 0.0f;
                this.dummyItem.field_70292_b = 0;
                this.dummyItem.func_92058_a(stack);
                customRenderer.renderItem(type, stack, new Object[]{this.blockRender, this.dummyItem});
            } else {
                customRenderer.renderItem(type, stack, new Object[]{this.blockRender});
            }
            RenderItem.field_82407_g = false;
        } else if (item instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)stack.func_77973_b()).func_149645_b())) {
            manager.func_110577_a(TextureMap.field_110575_b);
            GL11.glScalef((float)1.3f, (float)1.3f, (float)1.3f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            if (Barrels.renderIn3D()) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glScalef((float)1.0f, (float)1.0f, (float)0.001f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.blockRender.func_147800_a(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j(), 1.0f);
        } else {
            float offset;
            GL11.glScalef((float)1.0f, (float)1.0f, (float)0.125f);
            GL11.glDisable((int)2896);
            boolean reloadTexture = true;
            IIcon def = stack.func_77954_c();
            if (def == null) {
                def = ((TextureMap)manager.func_110581_b(TextureMap.field_110576_c)).getTextureExtry("missingno");
            }
            for (int pass = 0; pass < (item.func_77623_v() ? item.getRenderPasses(stack.func_77960_j()) : 1); ++pass) {
                if (reloadTexture) {
                    manager.func_110577_a(stack.func_77973_b() == Items.field_151098_aY ? this.mapBackround : manager.func_130087_a(stack.func_94608_d()));
                }
                if (pass > 0) {
                    int color2 = item.func_82790_a(stack, pass);
                    float a2 = 1.0f;
                    float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
                    float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
                    float b2 = (float)(color2 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)r2, (float)g2, (float)b2, (float)a2);
                }
                IIcon icon = null;
                if (item.func_77623_v()) {
                    icon = item.getIcon(stack, pass);
                }
                if (icon == null) {
                    icon = def;
                }
                if (stack.func_77973_b() == Items.field_151098_aY) {
                    this.renderItem(0.0f, 1.0f, 0.0f, 1.0f, GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096), GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097));
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.mapTexture.func_110564_a();
                    offset = this.settings.field_74347_j ? 0.55f : 0.15f;
                    this.tessellator.func_78382_b();
                    this.tessellator.func_78374_a(-1.0, 1.0, (double)(-offset), 1.0, 0.0);
                    this.tessellator.func_78374_a(1.0, 1.0, (double)(-offset), 0.0, 0.0);
                    this.tessellator.func_78374_a(1.0, -1.0, (double)(-offset), 0.0, 1.0);
                    this.tessellator.func_78374_a(-1.0, -1.0, (double)(-offset), 1.0, 1.0);
                    this.tessellator.func_78381_a();
                } else if (stack.func_77973_b() == Items.field_151111_aL) {
                    TextureAtlasSprite texture = ((TextureMap)manager.func_110581_b(TextureMap.field_110576_c)).func_110572_b(stack.func_77954_c().func_94215_i());
                    if (texture != null && texture instanceof TextureCompass) {
                        TextureCompass compass = (TextureCompass)texture;
                        double angle = compass.field_94244_i;
                        double delta = compass.field_94242_j;
                        compass.field_94244_i = 6.0;
                        compass.field_94242_j = 0.0;
                        compass.func_94241_a(null, 0.0, 0.0, 0.0, false, false);
                        this.renderItem(icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h(), icon.func_94211_a(), icon.func_94216_b());
                        compass.field_94244_i = angle;
                        compass.field_94242_j = delta;
                        compass.func_94219_l();
                    } else {
                        this.renderItem(icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h(), icon.func_94211_a(), icon.func_94216_b());
                    }
                } else {
                    this.renderItem(icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h(), icon.func_94211_a(), icon.func_94216_b());
                }
                reloadTexture = stack.hasEffect(pass);
                if (!reloadTexture) continue;
                manager.func_110577_a(this.itemGlint);
                GL11.glDepthFunc((int)514);
                GL11.glColor3f((float)0.5f, (float)0.25f, (float)0.8f);
                GL11.glMatrixMode((int)5890);
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)768, (int)1);
                GL11.glEnable((int)3042);
                GL11.glDisable((int)3008);
                for (int dir = 0; dir < 2; ++dir) {
                    float phrase = (float)(System.currentTimeMillis() % (long)(3000 + dir * 1873)) / (float)(3000 + dir * 1873) * 256.0f;
                    float uoffset = dir == 1 ? -1.0f : 4.0f;
                    float multi = 0.00390625f;
                    int size = 20;
                    float u1 = (phrase + (float)size) * multi;
                    float u2 = phrase * multi;
                    float u3 = (phrase + (float)size * uoffset) * multi;
                    float u4 = (phrase + (float)size + (float)size * uoffset) * multi;
                    float v1 = 0.0f;
                    float v2 = 0.0f;
                    float v3 = 1.0f;
                    float v4 = 1.0f;
                    this.renderItem(u1, u2, u3, u4, v1, v2, v3, v4, icon.func_94211_a(), icon.func_94216_b());
                }
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glDepthMask((boolean)true);
                GL11.glMatrixMode((int)5888);
                GL11.glDepthFunc((int)515);
            }
            if (stack.func_77951_h()) {
                GL11.glDisable((int)3553);
                int damage = (int)Math.round(13.0 - (double)stack.func_77952_i() * 13.0 / (double)stack.func_77958_k());
                int color3 = (int)Math.round(255.0 - (double)stack.func_77952_i() * 255.0 / (double)stack.func_77958_k());
                this.tessellator.func_78382_b();
                offset = 0.001f;
                if (damage > 0) {
                    this.renderQuad(-0.125f * (float)(damage - 6) - (damage < 13 ? 0.0f : offset), -0.75f, 0.125f * (float)damage + (damage < 13 ? offset : offset * 2.0f), 0.125f + offset, offset + 0.15f, 255 - color3 << 16 | color3 << 8);
                }
                if (damage < 13) {
                    if (damage < 12) {
                        this.renderQuad(-0.75f, -0.75f, 0.125f * (float)(13 - damage - 1), 0.125f + offset, offset + 0.15f, (255 - color3) / 4 << 16 | 0x3F00);
                    }
                    this.renderQuad(-0.875f - offset, -0.75f, 0.125f + offset, 0.125f + offset, offset + 0.15f, 0);
                }
                this.renderQuad(-0.875f - offset, -0.875f - offset, 1.625f + offset * 2.0f, 0.125f + offset, offset + 0.15f, 0);
                this.tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
        }
    }

    private void renderItem(float u1, float u2, float u3, float u4, float v1, float v2, float v3, float v4, int width, int height) {
        if (this.settings.field_74347_j) {
            int i;
            float offset = 0.5f;
            this.tessellator.func_78382_b();
            this.tessellator.func_78374_a(-1.0, 1.0, (double)(-offset), (double)u1, (double)v1);
            this.tessellator.func_78374_a(1.0, 1.0, (double)(-offset), (double)u2, (double)v2);
            this.tessellator.func_78374_a(1.0, -1.0, (double)(-offset), (double)u3, (double)v3);
            this.tessellator.func_78374_a(-1.0, -1.0, (double)(-offset), (double)u4, (double)v4);
            this.tessellator.func_78381_a();
            float w1 = (u1 - u2) / (float)width;
            float w2 = (u4 - u3) / (float)width;
            float h1 = (v3 - v2) / (float)height;
            float h2 = (v4 - v1) / (float)height;
            float indent = 5.0E-5f;
            this.tessellator.func_78382_b();
            for (i = 0; i < width; ++i) {
                this.tessellator.func_78374_a((double)((float)i / (float)width * 2.0f - 1.0f), 1.0, 0.0, (double)(u1 - w1 * (float)i - indent), (double)((v1 - v2) / (float)height * (float)i + v2));
                this.tessellator.func_78374_a((double)((float)i / (float)width * 2.0f - 1.0f), 1.0, (double)(-offset), (double)(u1 - w1 * (float)i - indent), (double)((v1 - v2) / (float)height * (float)i + v2));
                this.tessellator.func_78374_a((double)((float)i / (float)width * 2.0f - 1.0f), -1.0, (double)(-offset), (double)(u4 - w2 * (float)i - indent), (double)((v3 - v4) / (float)height * (float)i + v4));
                this.tessellator.func_78374_a((double)((float)i / (float)width * 2.0f - 1.0f), -1.0, 0.0, (double)(u4 - w2 * (float)i - indent), (double)((v3 - v4) / (float)height * (float)i + v4));
            }
            this.tessellator.func_78381_a();
            this.tessellator.func_78382_b();
            for (i = 1; i <= width; ++i) {
                this.tessellator.func_78374_a((double)((float)i / (float)width * 2.0f - 1.0f), 1.0, (double)(-offset), (double)(u1 - w1 * (float)i + indent), (double)((v1 - v2) / (float)height * (float)i + v2));
                this.tessellator.func_78374_a((double)((float)i / (float)width * 2.0f - 1.0f), 1.0, 0.0, (double)(u1 - w1 * (float)i + indent), (double)((v1 - v2) / (float)height * (float)i + v2));
                this.tessellator.func_78374_a((double)((float)i / (float)width * 2.0f - 1.0f), -1.0, 0.0, (double)(u4 - w2 * (float)i + indent), (double)((v3 - v4) / (float)height * (float)i + v4));
                this.tessellator.func_78374_a((double)((float)i / (float)width * 2.0f - 1.0f), -1.0, (double)(-offset), (double)(u4 - w2 * (float)i + indent), (double)((v3 - v4) / (float)height * (float)i + v4));
            }
            this.tessellator.func_78381_a();
            this.tessellator.func_78382_b();
            for (i = 0; i < height; ++i) {
                this.tessellator.func_78374_a(-1.0, (double)((float)i / (float)height * 2.0f - 1.0f), (double)(-offset), (double)((u1 - u4) / (float)height * (float)i + u4), (double)(v3 - h1 * (float)i - indent));
                this.tessellator.func_78374_a(1.0, (double)((float)i / (float)height * 2.0f - 1.0f), (double)(-offset), (double)((u2 - u3) / (float)height * (float)i + u3), (double)(v4 - h2 * (float)i - indent));
                this.tessellator.func_78374_a(1.0, (double)((float)i / (float)height * 2.0f - 1.0f), 0.0, (double)((u2 - u3) / (float)height * (float)i + u3), (double)(v4 - h2 * (float)i - indent));
                this.tessellator.func_78374_a(-1.0, (double)((float)i / (float)height * 2.0f - 1.0f), 0.0, (double)((u1 - u4) / (float)height * (float)i + u4), (double)(v3 - h1 * (float)i - indent));
            }
            this.tessellator.func_78381_a();
            this.tessellator.func_78382_b();
            for (i = 1; i <= height; ++i) {
                this.tessellator.func_78374_a(-1.0, (double)((float)i / (float)height * 2.0f - 1.0f), 0.0, (double)((u1 - u4) / (float)height * (float)i + u4), (double)(v3 - h1 * (float)i + indent));
                this.tessellator.func_78374_a(1.0, (double)((float)i / (float)height * 2.0f - 1.0f), 0.0, (double)((u2 - u3) / (float)height * (float)i + u3), (double)(v4 - h2 * (float)i + indent));
                this.tessellator.func_78374_a(1.0, (double)((float)i / (float)height * 2.0f - 1.0f), (double)(-offset), (double)((u2 - u3) / (float)height * (float)i + u3), (double)(v4 - h2 * (float)i + indent));
                this.tessellator.func_78374_a(-1.0, (double)((float)i / (float)height * 2.0f - 1.0f), (double)(-offset), (double)((u1 - u4) / (float)height * (float)i + u4), (double)(v3 - h1 * (float)i + indent));
            }
            this.tessellator.func_78381_a();
        } else {
            float offset = 0.1f;
            this.tessellator.func_78382_b();
            this.tessellator.func_78374_a(-1.0, 1.0, (double)(-offset), (double)u1, (double)v1);
            this.tessellator.func_78374_a(1.0, 1.0, (double)(-offset), (double)u2, (double)v2);
            this.tessellator.func_78374_a(1.0, -1.0, (double)(-offset), (double)u3, (double)v3);
            this.tessellator.func_78374_a(-1.0, -1.0, (double)(-offset), (double)u4, (double)v4);
            this.tessellator.func_78381_a();
        }
    }

    private void renderItem(float minU, float maxU, float minV, float maxV, int width, int height) {
        this.renderItem(maxU, minU, minU, maxU, minV, minV, maxV, maxV, width, height);
    }

    private void renderQuad(float x, float y, float width, float height, float offset, int color) {
        this.tessellator.func_78376_a(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        if (this.settings.field_74347_j) {
            this.tessellator.func_78377_a((double)x, (double)y, (double)(-(offset += 0.5f)));
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)(-offset));
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)(-offset));
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)(-offset));
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)(-offset));
            this.tessellator.func_78377_a((double)x, (double)(y + height), 0.0);
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), 0.0);
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)(-offset));
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)(-offset));
            this.tessellator.func_78377_a((double)(x + width), (double)y, 0.0);
            this.tessellator.func_78377_a((double)x, (double)y, 0.0);
            this.tessellator.func_78377_a((double)x, (double)y, (double)(-offset));
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)(-offset));
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), 0.0);
            this.tessellator.func_78377_a((double)(x + width), (double)y, 0.0);
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)(-offset));
            this.tessellator.func_78377_a((double)x, (double)y, (double)(-offset));
            this.tessellator.func_78377_a((double)x, (double)y, 0.0);
            this.tessellator.func_78377_a((double)x, (double)(y + height), 0.0);
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)(-offset));
        } else {
            this.tessellator.func_78377_a((double)x, (double)y, (double)(-offset));
            this.tessellator.func_78377_a((double)x, (double)(y + height), (double)(-offset));
            this.tessellator.func_78377_a((double)(x + width), (double)(y + height), (double)(-offset));
            this.tessellator.func_78377_a((double)(x + width), (double)y, (double)(-offset));
        }
    }

    public void func_147500_a(TileEntity entity, double x, double y, double z, float counter) {
        TileEntityBarrel tile = (TileEntityBarrel)entity;
        ItemStack item = tile.getRawItem();
        GL11.glEnable((int)2884);
        if (item != null && item.func_77973_b() instanceof ItemMap) {
            MapData data = (MapData)tile.func_145831_w().func_72943_a(MapData.class, "map_" + item.func_77960_j());
            this.setMap(data);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        this.render(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.getOrientation(), tile.getItem(), tile.getFrames(), false, false);
        GL11.glPopMatrix();
    }

    public void render(World world, int x, int y, int z, int orientation, ItemStack item, boolean[] frames, boolean ignoreLighting, boolean ignoreRenderCheck) {
        String overlay = this.getOverlay(item);
        if (Barrels.renderOneSide()) {
            int side = orientation;
            if (ignoreRenderCheck || this.canRender(world, x, y, z, (side + orientation + 1) % 4)) {
                this.renderOnSide(item, world, (side + orientation + 1) % 4, x, y, z, overlay, frames[side], ignoreLighting);
            }
            for (side = 0; side < 4; ++side) {
                if (side == orientation || !ignoreRenderCheck && !this.canRender(world, x, y, z, (side + orientation + 1) % 4) || !frames[side]) continue;
                this.renderOnSide(item, world, (side + orientation + 1) % 4, x, y, z, overlay, frames[side], ignoreLighting);
            }
        } else {
            for (int side = 0; side < 4; ++side) {
                if (!ignoreRenderCheck && !this.canRender(world, x, y, z, (side + orientation + 1) % 4)) continue;
                this.renderOnSide(item, world, (side + orientation + 1) % 4, x, y, z, overlay, frames[side], ignoreLighting);
            }
        }
    }

    private boolean canRender(World world, int x, int y, int z, int side) {
        return Barrels.getActiveBlock().func_149646_a((IBlockAccess)world, x + Direction.field_71583_a[side], y, z + Direction.field_71581_b[side], 0);
    }

    public void renderOnSide(ItemStack item, World world, int side, int x, int y, int z, String overlay, boolean renderFrame, boolean ignoreLighting) {
        boolean render = item != null;
        GL11.glPushMatrix();
        boolean enableLighting = GL11.glIsEnabled((int)2896);
        boolean resacleNormal = GL11.glIsEnabled((int)32826);
        boolean blend = GL11.glIsEnabled((int)3042);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)3042);
        if (render) {
            if (!ignoreLighting) {
                this.setLight(world, side, x, y, z);
            }
            GL11.glDisable((int)2896);
            GL11.glPushMatrix();
            GL11.glRotatef((float)(-90 * Direction.field_71580_e[side]), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.41f, (float)-0.505f);
            if (overlay != null) {
                GL11.glPushMatrix();
                this.renderText(overlay);
                GL11.glPopMatrix();
            }
            if (Barrels.renderName() && !renderFrame) {
                GL11.glTranslatef((float)0.0f, (float)-0.79f, (float)0.0f);
                this.renderTextWithResize(item.func_82833_r());
            }
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        if (renderFrame) {
            if (!render && !ignoreLighting) {
                this.setLight(world, side, x, y, z);
            }
            GL11.glTranslatef((float)0.0f, (float)(0.0625f * (item != null && item.func_77973_b() == Items.field_151098_aY ? 8.0f : 7.0f) - 0.5f), (float)0.0f);
            GL11.glRotatef((float)(-90 * (side - 1)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5625f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(90 * (side - 1)), (float)0.0f, (float)1.0f, (float)0.0f);
            EntityItemFrame frame = this.dummyFrame;
            frame.field_70170_p = world;
            frame.field_146063_b = x;
            frame.field_146064_c = y;
            frame.field_146062_d = z;
            if (item != null) {
                frame.func_82334_a(item);
            } else {
                frame.func_82334_a(null);
            }
            frame.func_82328_a(side);
            this.frameRender.func_76986_a((Entity)frame, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        } else if (render) {
            GL11.glRotatef((float)(-90 * Direction.field_71580_e[side]), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
            GL11.glPushMatrix();
            this.renderItem(world, item);
            GL11.glPopMatrix();
        }
        if (enableLighting) {
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
        }
        if (resacleNormal) {
            GL11.glEnable((int)32826);
        } else {
            GL11.glDisable((int)32826);
        }
        if (blend) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    public void setMap(MapData data) {
        if (data != null) {
            for (int i = 0; i < data.field_76198_e.length; ++i) {
                byte color = data.field_76198_e[i];
                this.mapTexture.func_110565_c()[i] = color / 4 == 0 ? (i * 2 / 128 & 1) * 8 + 16 << 24 : MapColor.field_76281_a[color / 4].func_151643_b(color & 3);
            }
        }
    }

    private String getOverlay(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (Map.Entry<ItemIdentifyer, String> entry : this.OVERLAY_CHACHE.entrySet()) {
            if (entry.getKey().getMaxStackSize() != item.func_77973_b().getItemStackLimit(item) || entry.getKey().getStackSize() != item.field_77994_a) continue;
            return entry.getValue();
        }
        StringBuilder overlay = new StringBuilder();
        int maxSize = item.func_77976_d();
        int stackCount = item.field_77994_a / maxSize;
        if (maxSize == 1) {
            overlay.append(stackCount);
        } else {
            int excess = item.field_77994_a % maxSize;
            if (stackCount > 0) {
                if (stackCount > 1) {
                    overlay.append(stackCount).append(" x ");
                }
                overlay.append(maxSize);
                if (excess > 0) {
                    overlay.append(" + ");
                }
            }
            if (excess > 0) {
                overlay.append(excess);
            }
        }
        String so = overlay.toString();
        ItemIdentifyer ident = new ItemIdentifyer(item.func_77973_b().getItemStackLimit(item), item.field_77994_a);
        if (this.OVERLAY_CHACHE.size() >= 1000) {
            this.OVERLAY_CHACHE.clear();
        }
        this.OVERLAY_CHACHE.put(ident, so);
        return so;
    }

    public FontRenderer func_147498_b() {
        if (super.func_147498_b() != null) {
            return super.func_147498_b();
        }
        return this.mc.field_71466_p;
    }

    private void setLight(World world, int side, int x, int y, int z) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(world.func_72925_a(EnumSkyBlock.Block, x + Direction.field_71583_a[side], y, z + Direction.field_71581_b[side]) * 16), (float)(world.func_72925_a(EnumSkyBlock.Sky, x + Direction.field_71583_a[side], y, z + Direction.field_71581_b[side]) * 16));
    }

    private class ItemIdentifyer {
        private final int maxStackSize;
        private final int stackSize;

        public ItemIdentifyer(int maxStackSize, int stackSize) {
            this.maxStackSize = maxStackSize;
            this.stackSize = stackSize;
        }

        public int getMaxStackSize() {
            return this.maxStackSize;
        }

        public int getStackSize() {
            return this.stackSize;
        }
    }
}

