/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.BlockBarrel;
import need4speed402.mods.barrels.lib.ClickMode;
import need4speed402.mods.barrels.lib.InventoryType;
import need4speed402.mods.barrels.lib.Slot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileEntityBarrel
extends TileEntity
implements ISidedInventory,
IDeepStorageUnit {
    private ItemStack item;
    private int doubleClickTimer;
    private int selectedSlot;
    private ClickMode mode;
    private int lastClicked;
    private int lastClickedExpected = -1;
    private Stack[] stackCache = new Stack[2];
    private int orientation = 0;
    private final boolean[] frames = new boolean[4];
    private UpdateType update = null;
    private boolean requiresCheck = false;
    private HashMap<EntityPlayer, int[]> changedSlots = null;
    private int frameCheckTime = 0;
    private static final int[][] ROTATION_MATRIX = new int[][]{{1, 1, 1, 1}, {0, 0, 0, 0}, {2, 5, 3, 4}, {3, 4, 2, 5}, {5, 3, 4, 2}, {4, 2, 5, 3}};

    public boolean[] getFrames() {
        return this.frames;
    }

    public int getLastClicked() {
        return this.lastClicked;
    }

    public boolean isAbrupted() {
        return this.lastClickedExpected == -1;
    }

    public void resetLastClicked() {
        this.lastClickedExpected = 1;
    }

    public void setLastClicked(int lastClicked) {
        this.lastClicked = lastClicked;
        this.resetLastClicked();
    }

    public int[] getChangedSlots(EntityPlayer player) {
        if (this.changedSlots != null) {
            return this.changedSlots.get(player);
        }
        return null;
    }

    public void clearChangedSlots() {
        this.changedSlots = null;
    }

    public void addChangedSlots(EntityPlayer player, Integer[] slots) {
        if (slots != null && slots.length != 0) {
            int[] ar = new int[slots.length];
            for (int i = 0; i < slots.length; ++i) {
                ar[i] = slots[i];
            }
            this.addChangedSlots(player, ar);
        }
    }

    public void addChangedSlots(EntityPlayer player, int[] slots) {
        if (slots != null && slots.length != 0) {
            if (this.changedSlots == null) {
                this.changedSlots = new HashMap();
                this.changedSlots.put(player, slots);
            } else if (this.changedSlots.containsKey(player)) {
                boolean found;
                int[] lastSlots = this.changedSlots.remove(player);
                int[] newSlots = new int[lastSlots.length + slots.length];
                int newSlotsIndex = 0;
                for (int x = 0; x < lastSlots.length; ++x) {
                    found = false;
                    for (int y = 0; y < slots.length; ++y) {
                        if (lastSlots[x] != slots[y]) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    newSlots[newSlotsIndex++] = lastSlots[x];
                }
                for (int y = 0; y < slots.length; ++y) {
                    found = false;
                    for (int x = 0; x < lastSlots.length; ++x) {
                        if (lastSlots[x] != slots[y]) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    newSlots[newSlotsIndex++] = slots[y];
                }
                int[] finalList = new int[newSlotsIndex];
                System.arraycopy(newSlots, 0, finalList, 0, newSlotsIndex);
                this.changedSlots.put(player, finalList);
            } else {
                this.changedSlots.put(player, slots);
            }
        }
    }

    public void setClick(int selectedSlot, ClickMode mode, int time) {
        this.selectedSlot = selectedSlot;
        this.mode = mode;
        this.doubleClickTimer = time;
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public ClickMode getMode() {
        return this.mode;
    }

    public void resetTimer() {
        this.doubleClickTimer = 0;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public ItemStack getRawItem() {
        return this.item;
    }

    public void setRawItem(ItemStack item) {
        this.item = item;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.localUpdate();
        }
    }

    public ItemStack getItem() {
        ItemStack item;
        ItemStack itemStack = item = this.getRawItem() == null ? null : this.getRawItem().func_77946_l();
        if (this.requiresCheck) {
            for (int slot = 0; slot < this.stackCache.length; ++slot) {
                if (this.stackCache[slot] == null || !this.stackCache[slot].hasChanged()) continue;
                if (item == null) {
                    item = this.stackCache[slot].getItem();
                }
                item.field_77994_a += this.stackCache[slot].getItem().field_77994_a - this.stackCache[slot].getIntitialSize();
            }
        }
        return item;
    }

    public void setItem(ItemStack item) {
        for (int slot = 0; slot < this.stackCache.length; ++slot) {
            this.stackCache[slot] = null;
        }
        if (TileEntityBarrel.equals(item, this.getRawItem())) {
            if (item != null) {
                this.requiresUpdate(UpdateType.COUNT);
            }
        } else {
            this.requiresUpdate(UpdateType.ITEM);
        }
        this.setRawItem(item);
        this.requiresCheck = false;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            Barrels.getPacketHandler().sendServerRequestForItem(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getInventorySize() {
        return this.getStackLimit() * this.getRawItem().func_77976_d();
    }

    public int getStackLimit() {
        return Barrels.getBarrels()[this.func_145832_p()].getStorageCompacity();
    }

    public int func_70302_i_() {
        return this.stackCache.length;
    }

    public void func_145845_h() {
        if (this.isTimerActive()) {
            --this.doubleClickTimer;
        }
        if (this.lastClickedExpected >= 0) {
            --this.lastClickedExpected;
            if (this.lastClicked > 0) {
                --this.lastClicked;
            }
            if (this.lastClickedExpected == -1) {
                this.lastClicked = 0;
            }
        }
        if (this.requiresCheck) {
            this.flush();
        }
        if (!this.field_145850_b.field_72995_K && Barrels.connectWithItemFrames() && this.frameCheckTime++ >= 20) {
            this.detectFrames();
        }
        if (this.update != null) {
            this.update(false);
        }
    }

    private void detectFrames() {
        int y = this.field_145848_d;
        List list = this.field_145850_b.func_72872_a(EntityItemFrame.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)y, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(y + 1), (double)(this.field_145849_e + 2)));
        for (int i = 0; i < this.frames.length; ++i) {
            int x = this.field_145851_c + Direction.field_71583_a[i];
            int z = this.field_145849_e + Direction.field_71581_b[i];
            if (list == null) continue;
            for (int size = 0; size < list.size(); ++size) {
                EntityItemFrame frame = (EntityItemFrame)list.get(size);
                if (Math.floor(frame.field_70165_t) != (double)x || Math.floor(frame.field_70161_v) != (double)z || frame.field_82332_a != i) continue;
                int side = (i - this.getOrientation() + 3) % 4;
                if (this.frames[side]) {
                    BlockBarrel.spawnItem(this.field_145850_b, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, new ItemStack(Items.field_151160_bD, 2, 0));
                }
                this.frames[side] = !this.frames[side];
                frame.func_70106_y();
                if (this.update != null) {
                    this.update(true);
                    continue;
                }
                Barrels.getPacketHandler().sendClientsFrameChange(this);
            }
        }
    }

    private void flush() {
        for (int slot = 0; slot < this.stackCache.length; ++slot) {
            if (this.stackCache[slot] == null) continue;
            if (this.stackCache[slot].hasChanged()) {
                ItemStack lastItem = this.getRawItem();
                if (this.getRawItem() == null) {
                    this.setRawItem(this.stackCache[slot].getItem());
                }
                if (this.stackCache[slot].getIntitialSize() - this.stackCache[slot].getItem().field_77994_a >= this.getRawItem().field_77994_a) {
                    this.setRawItem(null);
                } else {
                    ItemStack item = this.getRawItem();
                    item.field_77994_a += this.stackCache[slot].getItem().field_77994_a - this.stackCache[slot].getIntitialSize();
                    this.setRawItem(item);
                }
                if (this.field_145850_b.field_72995_K) {
                    this.localUpdate();
                }
                if (this.update != UpdateType.ITEM) {
                    this.update = this.getRawItem() != lastItem ? UpdateType.ITEM : UpdateType.COUNT;
                }
            }
            this.stackCache[slot] = null;
        }
        this.requiresCheck = false;
    }

    private void resizeCache() {
        ArrayList ores;
        int id;
        ItemStack item = this.getItem();
        int num = 2;
        if (item != null && Barrels.useOreDictionary() && (id = OreDictionary.getOreID((ItemStack)item)) != -1 && TileEntityBarrel.isInOreDictionaryWhitelist(OreDictionary.getOreName((int)id)) && (ores = OreDictionary.getOres((Integer)id)) != null) {
            num = ores.size() + 1;
        }
        if (this.stackCache == null || this.stackCache.length != num) {
            this.stackCache = new Stack[num];
        } else {
            for (int slot = 0; slot < this.stackCache.length; ++slot) {
                this.stackCache[slot] = null;
            }
        }
    }

    private void update(boolean sendFrames) {
        if (this.update == UpdateType.ITEM) {
            this.resizeCache();
        }
        if (this.field_145850_b.field_72995_K) {
            this.localUpdate();
        } else if (this.changedSlots == null) {
            if (this.update == UpdateType.ITEM || sendFrames) {
                Barrels.getPacketHandler().updateClients(this, sendFrames);
            } else if (this.update == UpdateType.COUNT) {
                Barrels.getPacketHandler().updateClientsItemCount(this, null);
            }
        } else {
            EntityPlayer[] players = new EntityPlayer[this.changedSlots.size()];
            Iterator<Map.Entry<EntityPlayer, int[]>> iter = this.changedSlots.entrySet().iterator();
            int index = 0;
            while (iter.hasNext()) {
                Map.Entry<EntityPlayer, int[]> entry = iter.next();
                players[index] = entry.getKey();
                int[] islots = entry.getValue();
                Slot[] slots = new Slot[islots.length];
                for (int i = 0; i < islots.length; ++i) {
                    ItemStack playerSlot = players[index].field_71071_by.field_70462_a[islots[i]];
                    slots[i] = new Slot(islots[i], playerSlot == null ? null : playerSlot.func_77946_l());
                }
                if (this.update == UpdateType.ITEM || sendFrames) {
                    Barrels.getPacketHandler().updateClient((EntityPlayerMP)players[index], this, sendFrames, slots);
                } else if (this.update == UpdateType.COUNT) {
                    Barrels.getPacketHandler().updateClientItemCount((EntityPlayerMP)players[index], this, slots);
                }
                ++index;
            }
            if (this.update == UpdateType.ITEM || sendFrames) {
                Barrels.getPacketHandler().updateClients(this, sendFrames, (Entity[])players);
            } else if (this.update == UpdateType.COUNT) {
                Barrels.getPacketHandler().updateClientsItemCount(this, (Entity[])players);
            }
            this.clearChangedSlots();
        }
        this.func_70296_d();
        this.update = null;
    }

    @SideOnly(value=Side.CLIENT)
    private void localUpdate() {
    }

    private void requiresUpdate(UpdateType type) {
        if (this.update != UpdateType.ITEM) {
            this.update = type;
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.localUpdate();
        }
    }

    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.write(NBT);
        NBT.func_74774_a("side", (byte)this.getOrientation());
    }

    public void write(NBTTagCompound NBT) {
        ItemStack item = this.getItem();
        if (item != null) {
            NBT.func_74768_a("item", Item.func_150891_b((Item)item.func_77973_b()));
            NBT.func_74768_a("size", item.field_77994_a);
            NBT.func_74768_a("metadata", item.func_77960_j());
            if (item.func_77978_p() != null) {
                NBT.func_74782_a("tag", (NBTBase)item.func_77978_p());
            }
        }
        byte packed = 0;
        for (int i = 0; i < this.frames.length; ++i) {
            if (!this.frames[i]) continue;
            packed = (byte)(packed | 1 << i);
        }
        if (packed != 0) {
            NBT.func_74768_a("dim", this.field_145850_b.field_73011_w.field_76574_g);
            NBT.func_74774_a("frame", packed);
        }
    }

    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.read(NBT);
        this.setOrientation(NBT.func_74771_c("side"));
    }

    public void read(NBTTagCompound NBT) {
        if (this.field_145850_b == null && NBT.func_74764_b("dim")) {
            this.field_145850_b = DimensionManager.getWorld((int)DimensionManager.getProviderType((int)NBT.func_74762_e("dim")));
        }
        if (NBT.func_74764_b("item")) {
            int itemID = NBT.func_74762_e("item");
            ItemStack item = itemID == -1 || Item.func_150899_d((int)itemID) == null ? null : new ItemStack(Item.func_150899_d((int)itemID), NBT.func_74762_e("size"), NBT.func_74762_e("metadata"));
            if (NBT.func_74764_b("tag")) {
                item.func_77982_d(NBT.func_74775_l("tag"));
            }
            this.setItem(item);
        } else {
            this.setItem(null);
        }
        this.resizeCache();
        if (NBT.func_74764_b("frame")) {
            byte packed = NBT.func_74771_c("frame");
            for (int i = 0; i < this.frames.length; ++i) {
                if ((packed & 1 << i) == 0) continue;
                this.frames[i] = true;
            }
        }
    }

    public boolean isTimerActive() {
        return this.doubleClickTimer > 0;
    }

    private int getStackSizeInSlot(int slot) {
        ItemStack item = this.getItem();
        if (item != null) {
            int off;
            int n = off = Barrels.leaveOneItem() ? -1 : 0;
            if (slot == 0) {
                return item.field_77994_a + off - this.getStackSizeInSlot(1);
            }
            return Math.max(item.field_77994_a + off - (this.getInventorySize() + off) + item.func_77976_d(), 0);
        }
        return 0;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            throw new IndexOutOfBoundsException("Max size: " + (this.func_70302_i_() - 1) + ", slot: " + slot);
        }
        ItemStack item = this.getItem();
        if (item != null) {
            ArrayList ores;
            int id;
            if (this.getRawItem() == null) {
                this.flush();
            }
            int slotSize = this.getStackSizeInSlot(slot);
            if (this.stackCache[slot] != null) {
                if (this.stackCache[slot].hasChanged()) {
                    ItemStack item2 = this.getRawItem();
                    item2.field_77994_a += this.stackCache[slot].getItem().field_77994_a - this.stackCache[slot].getIntitialSize();
                    this.setRawItem(item2);
                    this.requiresUpdate(UpdateType.COUNT);
                    this.stackCache[slot].setSize(slotSize);
                } else if (this.stackCache[slot].getIntitialSize() != slotSize) {
                    this.stackCache[slot].setSize(slotSize);
                }
                this.requiresCheck = true;
                return this.stackCache[slot].getItem();
            }
            ItemStack use = item;
            if (Barrels.useOreDictionary() && slot > 0 && this.stackCache.length > 2 && (id = OreDictionary.getOreID((ItemStack)item)) != -1 && (ores = OreDictionary.getOres((Integer)id)) != null) {
                use = ((ItemStack)ores.get(slot - 1)).func_77946_l();
            }
            use.field_77994_a = slotSize;
            this.stackCache[slot] = new Stack(use);
            this.requiresCheck = true;
            return use;
        }
        if (this.getRawItem() != null) {
            this.flush();
            return this.func_70301_a(slot);
        }
        this.stackCache[slot] = null;
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            throw new IndexOutOfBoundsException();
        }
        ItemStack item = this.getItem();
        if (item == null) {
            if (stack != null) {
                if (this.stackCache[slot] == null || stack != this.stackCache[slot].getItem()) {
                    this.flush();
                    this.setRawItem(stack.func_77946_l());
                    if (this.stackCache[slot] == null) {
                        this.stackCache[slot] = new Stack(stack);
                    } else {
                        this.stackCache[slot].setItem(stack);
                    }
                    this.requiresUpdate(UpdateType.ITEM);
                }
            } else {
                this.stackCache[slot] = null;
            }
        } else {
            int fakeStack;
            if (this.getRawItem() == null) {
                this.flush();
            }
            if (this.stackCache[slot] != null) {
                if (this.stackCache[slot].getItem() != stack) {
                    this.stackCache[slot].getItem().field_77994_a = this.stackCache[slot].getIntitialSize();
                }
                fakeStack = this.stackCache[slot].getIntitialSize();
            } else {
                fakeStack = this.getStackSizeInSlot(slot);
            }
            if (fakeStack - (stack == null ? 0 : stack.field_77994_a) != 0) {
                UpdateType type;
                if (stack == null) {
                    if (this.getRawItem().field_77994_a > fakeStack) {
                        ItemStack item2 = this.getRawItem();
                        item2.field_77994_a -= fakeStack;
                        this.setRawItem(item2);
                        type = UpdateType.COUNT;
                    } else {
                        this.setRawItem(null);
                        type = UpdateType.ITEM;
                    }
                    this.stackCache[slot] = null;
                } else {
                    if (TileEntityBarrel.equals(stack, item)) {
                        ItemStack item2 = this.getRawItem();
                        item2.field_77994_a += stack.field_77994_a - fakeStack;
                        this.setRawItem(item2);
                        type = UpdateType.COUNT;
                    } else {
                        ItemStack item2 = stack.func_77946_l();
                        item2.field_77994_a = this.getRawItem().field_77994_a + item2.field_77994_a - fakeStack;
                        this.setRawItem(item2);
                        type = UpdateType.ITEM;
                    }
                    if (this.stackCache[slot] == null) {
                        this.stackCache[slot] = new Stack(stack);
                    } else {
                        this.stackCache[slot].setItem(stack);
                    }
                }
                this.requiresUpdate(type);
            }
        }
        if (stack != null) {
            this.requiresCheck = true;
        }
    }

    public ItemStack addItem(ItemStack item) {
        if (item != null && item.field_77994_a > 0) {
            int inventorySize = this.getRawItem() == null ? this.getStackLimit() * item.func_77976_d() : this.getInventorySize();
            ItemStack item2 = this.getItem();
            if (item2 == null) {
                if (item.field_77994_a > inventorySize) {
                    ItemStack item1 = item.func_77946_l();
                    item1.field_77994_a = inventorySize;
                    this.setItem(item1);
                    item.field_77994_a -= inventorySize;
                } else {
                    this.setItem(item.func_77946_l());
                    item = null;
                }
            } else if (this.equals(item)) {
                if (item2.field_77994_a + item.field_77994_a > inventorySize) {
                    item.field_77994_a -= inventorySize - item2.field_77994_a;
                    item2.field_77994_a = inventorySize;
                    this.setItem(item2);
                } else {
                    item2.field_77994_a += item.field_77994_a;
                    this.setItem(item2);
                    item = null;
                }
            }
            return item;
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int value) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.getRawItem() != null && value != 0) {
            if (value > this.getRawItem().field_77994_a - (Barrels.leaveOneItem() ? 1 : 0)) {
                value = this.getRawItem().field_77994_a - (Barrels.leaveOneItem() ? 1 : 0);
            }
            ItemStack excess = this.getRawItem().func_77946_l();
            this.func_70301_a((int)slot).field_77994_a -= value;
            excess.field_77994_a = value;
            return excess;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public boolean equals(ItemStack item) {
        return TileEntityBarrel.equalsUseOreDictionary(item, this.getItem());
    }

    public static boolean equalsUseOreDictionary(ItemStack item, ItemStack item2) {
        ArrayList ores;
        int id;
        if (Barrels.useOreDictionary() && (id = OreDictionary.getOreID((ItemStack)item)) != -1 && TileEntityBarrel.isInOreDictionaryWhitelist(OreDictionary.getOreName((int)id)) && (ores = OreDictionary.getOres((Integer)id)) != null) {
            Iterator iter = ores.iterator();
            while (iter.hasNext()) {
                if (!TileEntityBarrel.equals((ItemStack)iter.next(), item2)) continue;
                return true;
            }
        }
        return TileEntityBarrel.equals(item, item2);
    }

    public static boolean equals(ItemStack item, ItemStack item2) {
        return item == item2 || item != null && item2 != null && item.func_77969_a(item2) && (item.func_77978_p() == item2.func_77978_p() || item.func_77978_p() != null && item2.func_77978_p() != null && item.func_77978_p().equals((Object)item.func_77978_p()));
    }

    public static boolean isInOreDictionaryWhitelist(String ore) {
        String[] whitelist;
        for (String s : whitelist = Barrels.getOreDictionaryWhitelist()) {
            if (!ore.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        ItemStack item2 = this.getItem();
        return item2 == null || TileEntityBarrel.equalsUseOreDictionary(item, item2);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return "container.barrel";
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public InventoryType getModeForSide(int side) {
        return Barrels.getInteraction()[ROTATION_MATRIX[side][this.orientation]];
    }

    public int[] func_94128_d(int side) {
        switch (this.getModeForSide(side)) {
            case IN: {
                return new int[]{0};
            }
            case OUT: {
                int[] scSlots = new int[this.func_70302_i_() - 1];
                for (int i = 0; i < scSlots.length; ++i) {
                    scSlots[i] = i + 1;
                }
                return scSlots;
            }
            case INOUT: {
                int[] scSlots = new int[this.func_70302_i_()];
                for (int i = 0; i < scSlots.length; ++i) {
                    scSlots[i] = i;
                }
                return scSlots;
            }
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return slot != 0 && this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 0 && this.func_94041_b(slot, item);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - 0.3f), (double)this.field_145848_d, (double)((float)this.field_145849_e - 0.3f), (double)((float)this.field_145851_c + 1.3f), (double)((float)this.field_145848_d + 1.0f), (double)((float)this.field_145849_e + 1.3f));
    }

    @Override
    public ItemStack getStoredItemType() {
        return this.getRawItem();
    }

    @Override
    public void setStoredItemCount(int count) {
        ItemStack item = this.getRawItem();
        if (item != null) {
            if (count <= 0) {
                this.setRawItem(null);
                this.requiresUpdate(UpdateType.ITEM);
            } else {
                item.field_77994_a = count;
                this.setRawItem(item);
                this.requiresUpdate(UpdateType.COUNT);
            }
        }
    }

    @Override
    public void setStoredItemType(ItemStack item, int count) {
        ItemStack stack;
        if (item == null || count <= 0) {
            stack = null;
        } else {
            stack = item.func_77946_l();
            stack.field_77994_a = count;
        }
        this.setRawItem(stack);
        this.requiresUpdate(UpdateType.ITEM);
    }

    @Override
    public int getMaxStoredCount() {
        return this.getInventorySize();
    }

    private static enum UpdateType {
        ITEM,
        COUNT;

    }

    private class Stack {
        private int intitialSize;
        private ItemStack item;

        public Stack(ItemStack item) {
            this.intitialSize = item.field_77994_a;
            this.item = item;
        }

        public int getIntitialSize() {
            return this.intitialSize;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public boolean hasChanged() {
            return this.item.field_77994_a != this.intitialSize;
        }

        public void setItem(ItemStack item) {
            this.item = item;
            this.intitialSize = item.field_77994_a;
        }

        public void setSize(int size) {
            this.item.field_77994_a = this.intitialSize = size;
        }
    }
}

