/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import need4speed402.mods.barrels.BlockBarrel;
import need4speed402.mods.barrels.ItemBarrel;
import need4speed402.mods.barrels.TileEntityBarrel;
import need4speed402.mods.barrels.lib.BarrelType;
import need4speed402.mods.barrels.lib.InventoryType;
import need4speed402.mods.barrels.lib.LanguagePreSuf;
import need4speed402.mods.barrels.proxy.Proxy;
import need4speed402.mods.barrels.server.packetHandelers.PacketHandler;
import need4speed402.mods.barrels.server.packetHandelers.PacketHandlerCustomPayload;
import need4speed402.mods.barrels.server.packetHandelers.PacketHandlerDefault;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="barrels", name="The Barrels Mod", version="3.4")
public class Barrels {
    @Mod.Instance(value="barrels")
    private static Barrels instance;
    @SidedProxy(serverSide="need4speed402.mods.barrels.proxy.ProxyServer", clientSide="need4speed402.mods.barrels.proxy.ProxyClient")
    public static Proxy proxy;
    private PacketHandler packetHandler;
    private BlockBarrel barrel;
    private BarrelType[] barrels;
    private final int DEFUALT_NETWORK_ID = 245;
    private final int T1BARREL_MAX_STORAGE = 64;
    private final int T2BARREL_MAX_STORAGE = 1024;
    private final int T3BARREL_MAX_STORAGE = 4096;
    private final String T1_BARREL_CRAFTING = "shaped;logWood;logWood;logWood;item,iron_ingot;nothing;item,iron_ingot;logWood;logWood;logWood";
    private final String T2_BARREL_CRAFTING = "shaped;item,blaze_rod;block,obsidian;item,blaze_rod;item,ender_pearl;barrel,T1barrel;item,ender_pearl;item,blaze_rod;block,obsidian;item,blaze_rod";
    private final String T3_BARREL_CRAFTING = "shaped;block,obsidian;item,blaze_rod;block,obsidian;item,diamond;barrel,T2barrel;item,diamond;block,obsidian;item,blaze_rod;block,obsidian";
    private final List<LanguagePreSuf> presuf = new ArrayList<LanguagePreSuf>();
    private boolean onlyRenderOneSide = false;
    private boolean renderIn3D = true;
    private boolean renderName = false;
    private boolean useOreDictionary = false;
    private boolean connectWithItemFrames = true;
    private boolean keepItemsWhenBroken = false;
    private boolean leaveOneItem = false;
    private final InventoryType[] interaction = new InventoryType[6];
    private String[] oreDictionaryWhitelist = null;
    private static final char[] NUMBERS;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        instance = this;
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            int id = cfg.get("block", "Barrel", 4000, "The block ID for barrels.").getInt();
            String name = cfg.get("block", "Barrel Name", "mod-barrel", "This is a name barrels will use to distinguish itself from other blocks.\nThis will rarly need to be changed.").getString();
            if (id <= 0) {
                throw new IndexOutOfBoundsException("Block id is too small! Must be above 0!");
            }
            if (Block.field_149771_c.func_148753_b(id)) {
                throw new IllegalArgumentException("The block-id is occupied.");
            }
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("The name of barrels cannot be nothing!");
            }
            if (Block.field_149771_c.func_148741_d(name)) {
                throw new IllegalArgumentException("The barrel name is already assigned to a block!");
            }
            this.barrel = new BlockBarrel(id, name);
            int t1max = cfg.get("BarrelStorage", "T1BarrelMaxStorage", this.T1BARREL_MAX_STORAGE, "The maximum stacks of items that a barrel can hold.\n Set any value to -1 and that type of barrel will be disabled.").getInt();
            int t2max = cfg.get("BarrelStorage", "T2BarrelMaxStorage", 1024).getInt();
            int t3max = cfg.get("BarrelStorage", "T3BarrelMaxStorage", 4096).getInt();
            String t1recipe = null;
            String t2recipe = null;
            String t3recipe = null;
            if (t1max > 0) {
                t1recipe = cfg.get("crafting", "T1barrelCrafting", "shaped;logWood;logWood;logWood;item,iron_ingot;nothing;item,iron_ingot;logWood;logWood;logWood", "This allowes you to chage the crafting recipeis.\n Look on the forum for tutorials on setting this up.").getString();
            }
            if (t2max > 0) {
                t2recipe = cfg.get("crafting", "T2barrelCrafting", "shaped;item,blaze_rod;block,obsidian;item,blaze_rod;item,ender_pearl;barrel,T1barrel;item,ender_pearl;item,blaze_rod;block,obsidian;item,blaze_rod").getString();
            }
            if (t3max > 0) {
                t3recipe = cfg.get("crafting", "T3barrelCrafting", "shaped;block,obsidian;item,blaze_rod;block,obsidian;item,diamond;barrel,T2barrel;item,diamond;block,obsidian;item,blaze_rod;block,obsidian").getString();
            }
            this.barrels = new BarrelType[3];
            if (t1max > 0) {
                this.barrels[0] = new BarrelType((Block)this.barrel, 0, t1max, t1recipe);
            }
            if (t2max > 0) {
                this.barrels[1] = new BarrelType((Block)this.barrel, 1, t2max, t2recipe);
            }
            if (t3max > 0) {
                this.barrels[2] = new BarrelType((Block)this.barrel, 2, t3max, t3recipe);
            }
            int packetIDClient = cfg.get("block", "networkIDClient", 245, "This is not a regular blockID! This is a packetID for the barrel. The range is from 0-255.\nIf you're running out of packet ids, or if you don't want to deal with this shit, set it to -1 and\nis will use the regular CustomPayload packet.").getInt();
            int packetIDServer = cfg.get("block", "networkIDServer", 245).getInt();
            this.packetHandler = packetIDClient > 0 && packetIDServer > 0 ? new PacketHandlerDefault(packetIDClient, packetIDServer) : new PacketHandlerCustomPayload();
            String catagory = "render";
            this.onlyRenderOneSide = cfg.get(catagory, "onlyRenderOneSide", this.onlyRenderOneSide).getBoolean(this.onlyRenderOneSide);
            this.renderIn3D = cfg.get(catagory, "renderIn3D", this.renderIn3D).getBoolean(this.renderIn3D);
            this.renderName = cfg.get(catagory, "renderName", this.renderName).getBoolean(this.renderName);
            String categoryName = "interaction";
            this.connectWithItemFrames = cfg.get(categoryName, "connectsWithItemFrames", this.connectWithItemFrames, "When a item frame is placed on a barrelthe item frame will automatically attach to it and start displaying what is instide the barrel.").getBoolean(this.connectWithItemFrames);
            String[] modes = cfg.get(categoryName, "interaction", "in/out;in/out;unused;unused;unused;unused", "How the barrels interact with outside sources (buildcraft pipes)\n Usage: can be in four states: in, out, in/out, unused\n Formatting: <up>;<down>;<back>;<forward>;<right>;<left>").getString().split(";");
            for (int index = 0; index < modes.length; ++index) {
                InventoryType mode = modes[index].equals("in") || modes[index].equals("i") ? InventoryType.IN : (modes[index].equals("out") || modes[index].equals("o") ? InventoryType.OUT : (modes[index].equals("in/out") || modes[index].equals("io") || modes[index].equals("inout") || modes[index].equals("in and out") ? InventoryType.INOUT : InventoryType.UNUSED));
                this.interaction[index] = mode;
            }
            this.leaveOneItem = cfg.get(categoryName, "leaveOneItem", this.leaveOneItem).getBoolean(this.leaveOneItem);
            this.useOreDictionary = cfg.get(categoryName, "useOreDictionary", this.useOreDictionary).getBoolean(this.useOreDictionary);
            this.keepItemsWhenBroken = cfg.get(categoryName, "keepItemsWhenBroken", this.keepItemsWhenBroken).getBoolean(this.keepItemsWhenBroken);
            if (this.useOreDictionary) {
                this.oreDictionaryWhitelist = cfg.get(categoryName, "oreDictionaryWhiteList", new String[]{"block", "ore", "ingot", "nugget", "dust"}).getStringList();
                if (this.oreDictionaryWhitelist == null || this.oreDictionaryWhitelist.length == 0) {
                    this.oreDictionaryWhitelist = null;
                    this.useOreDictionary = false;
                }
            } else {
                this.oreDictionaryWhitelist = null;
            }
        }
        catch (Exception e) {
            System.err.println("\n\n\n-------------------------------------------------------\nThe barrels mod did not initialize properly:\n" + e.getMessage() + "\n-------------------------------------------------------\n\n\n");
            throw new RuntimeException("There has been a problem with the initialization of Barrels!", e);
        }
        finally {
            cfg.save();
        }
        GameRegistry.registerBlock((Block)this.barrel, ItemBarrel.class, (String)this.barrel.getName(), (String)"barrels", (Object[])new Object[0]);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        TileEntity.func_145826_a(TileEntityBarrel.class, (String)"tileBarrels");
        Blocks.field_150480_ab.setFireInfo((Block)this.barrel, 1, 2);
        this.packetHandler.init();
        proxy.init();
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) throws Exception {
        for (BarrelType barrel : this.barrels) {
            if (barrel == null) continue;
            IRecipe recipe = this.getRecipe(barrel.getStack(), barrel.getRecipeCode());
            barrel.setRecipe(recipe);
            if (recipe == null) continue;
            GameRegistry.addRecipe((IRecipe)recipe);
        }
        proxy.postInit();
    }

    public IRecipe getRecipe(ItemStack result, String code) {
        String nothingSymbol = "nothing";
        try {
            int i;
            if (code == null || code.length() == 0) {
                return null;
            }
            String[] element = code.split(";");
            ArrayList<Object> list = new ArrayList<Object>();
            int startOffset = 1;
            if (element.length == 11) {
                startOffset = 2;
                list.add(element[1]);
            } else if (element.length != 10) {
                throw new IllegalArgumentException("Insuficent information");
            }
            int startY = 0;
            int endY = 3;
            int startX = 0;
            int endX = 3;
            boolean started = true;
            boolean ended = true;
            for (i = 0; i < 3; i = (int)((byte)(i + 1))) {
                if (started && element[i * 3 + 0 + startOffset].equals("nothing") && element[i * 3 + 1 + startOffset].equals("nothing") && element[i * 3 + 2 + startOffset].equals("nothing")) {
                    startY = (byte)(startY + 1);
                } else {
                    started = false;
                }
                if (ended && element[8 + startOffset - i * 3].equals("nothing") && element[7 + startOffset - i * 3].equals("nothing") && element[6 + startOffset - i * 3].equals("nothing")) {
                    endY = (byte)(endY - 1);
                    continue;
                }
                ended = false;
            }
            started = true;
            ended = true;
            for (i = 0; i < 3; ++i) {
                if (started && element[i + 0 + startOffset].equals("nothing") && element[i + 3 + startOffset].equals("nothing") && element[i + 6 + startOffset].equals("nothing")) {
                    startX = (byte)(startX + 1);
                } else {
                    started = false;
                }
                if (ended && element[2 + startOffset - i].equals("nothing") && element[5 + startOffset - i].equals("nothing") && element[8 + startOffset - i].equals("nothing")) {
                    endX = (byte)(endX - 1);
                    continue;
                }
                ended = false;
            }
            boolean isShapeless = element[0].equals("shapeless");
            for (int i2 = startY; i2 < endY; ++i2) {
                if (!isShapeless) {
                    list.add(i2 - startY, "");
                }
                for (int ii = startX; ii < endX; ++ii) {
                    int index = i2 * 3 + ii + startOffset;
                    boolean isNothing = element[index].equals("nothing");
                    if (!isShapeless) {
                        String string = null;
                        string = isNothing ? " " : Integer.toString(index);
                        if (i2 - startY == 0) {
                            list.set(0, list.get(0) + string);
                        } else if (i2 - startY == 1) {
                            list.set(1, list.get(1) + string);
                        } else if (i2 - startY == 2) {
                            list.set(2, list.get(2) + string);
                        }
                    }
                    if (isNothing) continue;
                    if (!isShapeless) {
                        list.add(Character.valueOf(Integer.toString(index).charAt(0)));
                    }
                    String[] crafting = null;
                    if (element[index].contains(",")) {
                        String[] subList = element[index].split(",");
                        boolean isNumber = false;
                        if (subList.length >= 2) {
                            char[] chars;
                            isNumber = true;
                            block16: for (char c : chars = subList[1].toCharArray()) {
                                for (char cc : NUMBERS) {
                                    if (c == cc) continue block16;
                                }
                                isNumber = false;
                                break;
                            }
                        }
                        switch (CraftingType.fromString(subList[0].toLowerCase())) {
                            case block: 
                            case blockid: {
                                if (isNumber) {
                                    crafting = new ItemStack(Block.func_149729_e((int)Integer.parseInt(subList[1])), subList.length >= 4 ? Integer.parseInt(subList[3]) : 1, subList.length >= 3 ? Integer.parseInt(subList[2]) : 0);
                                    break;
                                }
                            }
                            case blockname: {
                                int size = subList.length >= 4 ? Integer.parseInt(subList[3]) : 1;
                                int data = subList.length >= 3 ? Integer.parseInt(subList[2]) : 0;
                                crafting = new ItemStack(Block.func_149684_b((String)subList[1]), size, data);
                                break;
                            }
                            case item: 
                            case itemid: {
                                if (isNumber) {
                                    crafting = new ItemStack(Item.func_150899_d((int)Integer.parseInt(subList[1])), subList.length >= 4 ? Integer.parseInt(subList[3]) : 1, subList.length >= 3 ? Integer.parseInt(subList[2]) : 0);
                                    break;
                                }
                            }
                            case itemname: {
                                int size = subList.length >= 4 ? Integer.parseInt(subList[3]) : 1;
                                int data = subList.length >= 3 ? Integer.parseInt(subList[2]) : 0;
                                crafting = new ItemStack((Item)Item.field_150901_e.func_82594_a(subList[1]), size, data);
                                break;
                            }
                            case barrel: {
                                String c = subList[1].toLowerCase();
                                StringBuilder integer = new StringBuilder();
                                for (int chari = 0; chari < c.length(); ++chari) {
                                    if (Arrays.binarySearch(NUMBERS, c.charAt(chari)) < 0) continue;
                                    integer.append(c.charAt(chari));
                                }
                                int barrelIndex = Integer.parseInt(integer.toString()) - 1;
                                crafting = this.barrels[barrelIndex].getStack();
                                break;
                            }
                            case dictionary: {
                                crafting = element[index];
                                break;
                            }
                            case remote: {
                                for (int sub = 0; sub < subList.length - 1; ++sub) {
                                    subList[sub] = subList[sub + 1];
                                }
                            }
                            case unknown: {
                                int data;
                                crafting = Class.forName(subList[0]).getField(subList[1]).get(null);
                                int size = subList.length >= 4 ? Integer.parseInt(subList[3]) : 1;
                                int n = data = subList.length >= 3 ? Integer.parseInt(subList[2]) : 0;
                                if (crafting instanceof ItemStack || crafting instanceof String) break;
                                if (crafting instanceof Block) {
                                    crafting = new ItemStack((Block)crafting, size, data);
                                    break;
                                }
                                if (crafting instanceof Item) {
                                    crafting = new ItemStack((Item)crafting, size, data);
                                    break;
                                }
                                throw new IllegalArgumentException("Wrong type");
                            }
                        }
                    } else {
                        crafting = element[index].contains(":") ? element[index].split(":") : element[index];
                    }
                    list.add(crafting);
                }
            }
            if (element[0].equals("shaped")) {
                return new ShapedOreRecipe(result, list.toArray());
            }
            if (isShapeless) {
                return new ShapelessOreRecipe(result, list.toArray());
            }
            throw new IllegalArgumentException("Type of crafting has not been specified.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.toString() + ": There was a problem while adding a recipe. Plase make sure your configuratons are correct.");
            return null;
        }
    }

    public static BarrelType[] getBarrels() {
        return Barrels.instance.barrels;
    }

    public static LanguagePreSuf getPrefixAndSuffix(String language) {
        for (LanguagePreSuf lang : Barrels.instance.presuf) {
            if (!lang.getLanguage().equals(language)) continue;
            return lang;
        }
        return null;
    }

    public static void addPrefixAndSuffex(LanguagePreSuf presuf) {
        Barrels.instance.presuf.add(presuf);
    }

    public static InventoryType[] getInteraction() {
        return Barrels.instance.interaction;
    }

    public static boolean renderOneSide() {
        return Barrels.instance.onlyRenderOneSide;
    }

    public static boolean renderIn3D() {
        return Barrels.instance.renderIn3D;
    }

    public static boolean leaveOneItem() {
        return Barrels.instance.leaveOneItem;
    }

    public static boolean renderName() {
        return Barrels.instance.renderName;
    }

    public static Block getActiveBlock() {
        return Barrels.instance.barrel;
    }

    public static PacketHandler getPacketHandler() {
        return Barrels.instance.packetHandler;
    }

    public static boolean useOreDictionary() {
        return Barrels.instance.useOreDictionary;
    }

    public static boolean connectWithItemFrames() {
        return Barrels.instance.connectWithItemFrames;
    }

    public static String[] getOreDictionaryWhitelist() {
        return Barrels.instance.oreDictionaryWhitelist;
    }

    public static boolean keepItemsWhenBroken() {
        return true;
    }

    static {
        NUMBERS = "0123456789".toCharArray();
    }

    private static enum CraftingType {
        block,
        blockid,
        blockname,
        item,
        itemid,
        itemname,
        barrel,
        dictionary,
        remote,
        unknown;


        public static CraftingType fromString(String s) {
            for (CraftingType c : CraftingType.values()) {
                if (!c.toString().equals(s)) continue;
                return c;
            }
            return unknown;
        }
    }
}

