/*
 * Decompiled with CFR 0.152.
 */
package com.outlook.siribby.bamsgrave;

import baubles.api.BaublesApi;
import com.outlook.siribby.bamsgrave.Grave;
import com.outlook.siribby.bamsgrave.GraveSignInscription;
import com.outlook.siribby.bamsgrave.IGraveSignInscription;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class GraveDigger {
    private static IGraveSignInscription gsi = new GraveSignInscription();
    private static IGraveSignInscription gsi_modder;
    private static final Block[] ALLOWED_BLOCKS;

    public static void setGraveSignInscription(IGraveSignInscription gsi_m) throws Exception {
        if (gsi_modder != null) {
            Grave.instance().getLog().log(Level.ERROR, "An other mod tries to set a new method to inscribe the grave sign.");
            throw new Exception();
        }
        Grave.instance().getLog().log(Level.INFO, "A mod set a new method to inscribe the grave sign.");
        gsi_modder = gsi_m;
    }

    private static boolean isBlockPermitted(Block block) {
        for (int i = 0; i < ALLOWED_BLOCKS.length; ++i) {
            if (block != ALLOWED_BLOCKS[i]) continue;
            return true;
        }
        return false;
    }

    private static int checkGround(World world, GraveBlocks tmp_grave) {
        int blocking_blocks = 0;
        if (!GraveDigger.isBlockPermitted(world.func_147439_a(tmp_grave.gravesign.x, tmp_grave.gravesign.y, tmp_grave.gravesign.z))) {
            ++blocking_blocks;
        }
        if (!GraveDigger.isBlockPermitted(world.func_147439_a(tmp_grave.coffin_a.x, tmp_grave.coffin_a.y, tmp_grave.coffin_a.z))) {
            ++blocking_blocks;
        }
        if (!GraveDigger.isBlockPermitted(world.func_147439_a(tmp_grave.coffin_b.x, tmp_grave.coffin_b.y, tmp_grave.coffin_b.z))) {
            ++blocking_blocks;
        }
        return blocking_blocks;
    }

    private static int getTotalXP(EntityPlayerMP player) {
        int total_xp = 0;
        int level = player.field_71068_ca - 1;
        if (player.field_71106_cc < 0.0f || player.field_71106_cc >= 1.0f) {
            Grave.instance().getLog().log(Level.ERROR, player.getDisplayName() + "'s grave: wrong value in the xp bar of '" + player.field_71106_cc + "'");
        } else {
            total_xp = player.field_71068_ca < 15 ? (total_xp += (int)(player.field_71106_cc * 17.0f + 0.5f)) : (player.field_71068_ca < 30 ? (total_xp += (int)(player.field_71106_cc * (float)(17 + (player.field_71068_ca - 15) * 3) + 0.5f)) : (total_xp += (int)(player.field_71106_cc * (float)(62 + (player.field_71068_ca - 30) * 7) + 0.5f)));
        }
        while (level >= 0) {
            total_xp = level < 15 ? (total_xp += 17) : (level < 30 ? (total_xp += 17 + (level - 15) * 3) : (total_xp += 62 + (level - 30) * 7));
            --level;
        }
        return total_xp;
    }

    private static void fillCoffin(EntityPlayerMP player, TileEntityChest coffin_a, TileEntityChest coffin_b) {
        int i;
        if (coffin_a == null || coffin_b == null) {
            return;
        }
        IInventory baublesInv = BaublesApi.getBaubles((EntityPlayer)player);
        if (baublesInv != null) {
            for (i = 0; i < baublesInv.func_70302_i_(); ++i) {
                coffin_b.func_70299_a(i + 13, baublesInv.func_70301_a(i));
                baublesInv.func_70299_a(i, null);
            }
        }
        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (i < 9) {
                coffin_b.func_70299_a(i, player.field_71071_by.field_70462_a[i]);
            } else {
                coffin_a.func_70299_a(i - 9, player.field_71071_by.field_70462_a[i]);
            }
            player.field_71071_by.field_70462_a[i] = null;
        }
        for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
            coffin_b.func_70299_a(i + 9, player.field_71071_by.field_70460_b[i]);
            player.field_71071_by.field_70460_b[i] = null;
        }
        int total_xp = GraveDigger.getTotalXP(player);
        int amount_of_flasks = total_xp / 11;
        int slot1 = baublesInv != null ? 16 : 14;
        Grave.instance().getLog().log(Level.INFO, player.getDisplayName() + "'s grave: level='" + player.field_71068_ca + "'; xp='" + player.field_71106_cc + "'; total1='" + player.field_71067_cb + "'; total2='" + total_xp + "'; flasks='" + amount_of_flasks + "'");
        for (int slot = 26; amount_of_flasks > 0 && slot > slot1; amount_of_flasks -= 64, --slot) {
            int stack_size = amount_of_flasks > 64 ? 64 : amount_of_flasks;
            coffin_b.func_70299_a(slot, new ItemStack(Items.field_151062_by, stack_size));
        }
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.field_71106_cc = 0.0f;
    }

    private static String trimString(String str, int positions) {
        if (positions <= 0) {
            return "";
        }
        if (str.length() <= positions) {
            return str;
        }
        return str.substring(0, positions);
    }

    private static void convertGraveGround(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Block cover_block = null;
        if (block == Blocks.field_150348_b) {
            cover_block = Blocks.field_150347_e;
        } else if (block == Blocks.field_150349_c) {
            cover_block = Blocks.field_150346_d;
        } else if (block == Blocks.field_150322_A) {
            cover_block = Blocks.field_150354_m;
        } else if (block == Blocks.field_150334_T) {
            cover_block = Blocks.field_150347_e;
        } else if (block == Blocks.field_150333_U) {
            cover_block = Blocks.field_150347_e;
        }
        if (cover_block != null) {
            world.func_147465_d(x, y, z, cover_block, 0, 2);
        }
    }

    public static void dig(EntityPlayerMP player) {
        if (player.field_70170_p == null) {
            return;
        }
        Grave.instance().getLog().log(Level.INFO, "dig grave for '" + player.getDisplayName() + "'");
        int player_view = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        GraveBlocks tmp_grave = new GraveBlocks((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player_view);
        int blocking_blocks_0 = GraveDigger.checkGround(player.field_70170_p, tmp_grave);
        if (blocking_blocks_0 != 0) {
            int rotation_yaw = MathHelper.func_76142_g((float)player.field_70177_z) < 0.0f ? MathHelper.func_76128_c((double)((double)MathHelper.func_76142_g((float)player.field_70177_z) + 360.0)) : MathHelper.func_76128_c((double)MathHelper.func_76142_g((float)player.field_70177_z));
            GraveBlocks tmp_grave_90_left = new GraveBlocks((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player_view - 1 & 3);
            GraveBlocks tmp_grave_90_right = new GraveBlocks((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player_view + 1 & 3);
            GraveBlocks tmp_grave_180 = new GraveBlocks((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player_view + 2 & 3);
            int blocking_blocks_90_left = GraveDigger.checkGround(player.field_70170_p, tmp_grave_90_left);
            int blocking_blocks_90_right = GraveDigger.checkGround(player.field_70170_p, tmp_grave_90_right);
            int blocking_blocks_180 = GraveDigger.checkGround(player.field_70170_p, tmp_grave_180);
            if (rotation_yaw % 90 < 45) {
                if (blocking_blocks_90_right == 0) {
                    tmp_grave = tmp_grave_90_right;
                } else if (blocking_blocks_90_left == 0) {
                    tmp_grave = tmp_grave_90_left;
                } else if (blocking_blocks_180 == 0) {
                    tmp_grave = tmp_grave_180;
                } else if (blocking_blocks_90_right < blocking_blocks_0 && blocking_blocks_90_right <= blocking_blocks_90_left && blocking_blocks_90_right <= blocking_blocks_180) {
                    tmp_grave = tmp_grave_90_right;
                } else if (blocking_blocks_90_left < blocking_blocks_0 && blocking_blocks_90_left <= blocking_blocks_180) {
                    tmp_grave = tmp_grave_90_left;
                } else if (blocking_blocks_180 < blocking_blocks_0) {
                    tmp_grave = tmp_grave_180;
                }
            } else if (blocking_blocks_90_left == 0) {
                tmp_grave = tmp_grave_90_left;
            } else if (blocking_blocks_90_right == 0) {
                tmp_grave = tmp_grave_90_right;
            } else if (blocking_blocks_180 == 0) {
                tmp_grave = tmp_grave_180;
            } else if (blocking_blocks_90_left < blocking_blocks_0 && blocking_blocks_90_left <= blocking_blocks_90_right && blocking_blocks_90_left <= blocking_blocks_180) {
                tmp_grave = tmp_grave_90_left;
            } else if (blocking_blocks_90_right < blocking_blocks_0 && blocking_blocks_90_right <= blocking_blocks_180) {
                tmp_grave = tmp_grave_90_right;
            } else if (blocking_blocks_180 < blocking_blocks_0) {
                tmp_grave = tmp_grave_180;
            }
        }
        Grave.instance().getLog().log(Level.INFO, player.getDisplayName() + "'s grave: set blocks");
        int plant = 10;
        player.field_70170_p.func_147465_d(tmp_grave.gravestone.x, tmp_grave.gravestone.y, tmp_grave.gravestone.z, Blocks.field_150371_ca, 1, 2);
        player.field_70170_p.func_147465_d(tmp_grave.graveplant.x, tmp_grave.graveplant.y, tmp_grave.graveplant.z, Blocks.field_150457_bL, plant, 2);
        player.field_70170_p.func_147465_d(tmp_grave.gravesign.x, tmp_grave.gravesign.y, tmp_grave.gravesign.z, Blocks.field_150444_as, tmp_grave.gravesign_dir, 2);
        player.field_70170_p.func_147465_d(tmp_grave.coffin_a.x, tmp_grave.coffin_a.y, tmp_grave.coffin_a.z, (Block)Blocks.field_150486_ae, 0, 2);
        player.field_70170_p.func_147465_d(tmp_grave.coffin_b.x, tmp_grave.coffin_b.y, tmp_grave.coffin_b.z, (Block)Blocks.field_150486_ae, 0, 2);
        Grave.instance().getLog().log(Level.INFO, player.getDisplayName() + "'s grave: create sign");
        TileEntitySign sign = (TileEntitySign)player.field_70170_p.func_147438_o(tmp_grave.gravesign.x, tmp_grave.gravesign.y, tmp_grave.gravesign.z);
        if (sign != null) {
            String[] text;
            String[] stringArray = text = gsi_modder == null ? gsi.getInscription(player) : gsi_modder.getInscription(player);
            if (text.length != 4) {
                Grave.instance().getLog().log(Level.ERROR, "The by mod set method to inscribe the grave sign has an invalid return array size of '" + text.length + "', restore to default!");
                text = gsi.getInscription(player);
                gsi_modder = null;
            }
            sign.field_145915_a = new String[]{GraveDigger.trimString(text[0], 14), GraveDigger.trimString(text[1], 14), GraveDigger.trimString(text[2], 14), GraveDigger.trimString(text[3], 14)};
        }
        TileEntityChest coffin_a = (TileEntityChest)player.field_70170_p.func_147438_o(tmp_grave.coffin_a.x, tmp_grave.coffin_a.y, tmp_grave.coffin_a.z);
        TileEntityChest coffin_b = (TileEntityChest)player.field_70170_p.func_147438_o(tmp_grave.coffin_b.x, tmp_grave.coffin_b.y, tmp_grave.coffin_b.z);
        Grave.instance().getLog().log(Level.INFO, player.getDisplayName() + "'s grave: fill coffin");
        GraveDigger.fillCoffin(player, coffin_a, coffin_b);
        GraveDigger.convertGraveGround(player.field_70170_p, tmp_grave.graveground_a.x, tmp_grave.graveground_a.y, tmp_grave.graveground_a.z);
        GraveDigger.convertGraveGround(player.field_70170_p, tmp_grave.graveground_b.x, tmp_grave.graveground_b.y, tmp_grave.graveground_b.z);
        Grave.instance().getLog().log(Level.INFO, player.getDisplayName() + "'s grave: grave was dug");
    }

    static {
        ALLOWED_BLOCKS = new Block[]{Blocks.field_150350_a, Blocks.field_150348_b, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150345_g, Blocks.field_150358_i, Blocks.field_150355_j, Blocks.field_150356_k, Blocks.field_150353_l, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150362_t, Blocks.field_150322_A, Blocks.field_150321_G, Blocks.field_150329_H, Blocks.field_150330_I, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150478_aa, Blocks.field_150480_ab, Blocks.field_150458_ak, Blocks.field_150472_an, Blocks.field_150444_as, Blocks.field_150431_aC, Blocks.field_150432_aD, Blocks.field_150433_aE, Blocks.field_150434_aF, Blocks.field_150435_aG, Blocks.field_150436_aH, Blocks.field_150423_aK, Blocks.field_150424_aL, Blocks.field_150425_aM, Blocks.field_150420_aW, Blocks.field_150419_aX, Blocks.field_150440_ba, Blocks.field_150393_bb, Blocks.field_150394_bc, Blocks.field_150395_bd, Blocks.field_150391_bh, Blocks.field_150392_bi, Blocks.field_150388_bm, Blocks.field_150377_bs, Blocks.field_150375_by, Blocks.field_150457_bL, Blocks.field_150459_bM, Blocks.field_150469_bN};
    }

    private static class BlockCoord {
        public final int x;
        public final int y;
        public final int z;

        public BlockCoord(int new_x, int new_y, int new_z) {
            this.x = new_x;
            this.y = new_y;
            this.z = new_z;
        }
    }

    private static class GraveBlocks {
        public final BlockCoord gravestone;
        public final BlockCoord graveplant;
        public final BlockCoord gravesign;
        public final BlockCoord coffin_a;
        public final BlockCoord coffin_b;
        public final BlockCoord graveground_a;
        public final BlockCoord graveground_b;
        public final int gravesign_dir;

        public GraveBlocks(int x, int y, int z, int player_view) {
            int my_y = y < 3 ? 3 : y;
            switch (player_view) {
                case 1: {
                    this.gravestone = new BlockCoord(x, my_y, z);
                    this.graveplant = new BlockCoord(x, my_y + 1, z);
                    this.gravesign = new BlockCoord(x - 1, my_y, z);
                    this.coffin_a = new BlockCoord(x - 2, my_y - 2, z);
                    this.coffin_b = new BlockCoord(x - 1, my_y - 2, z);
                    this.graveground_a = new BlockCoord(x - 1, my_y - 1, z);
                    this.graveground_b = new BlockCoord(x - 2, my_y - 1, z);
                    this.gravesign_dir = 4;
                    break;
                }
                case 2: {
                    this.gravestone = new BlockCoord(x, my_y, z);
                    this.graveplant = new BlockCoord(x, my_y + 1, z);
                    this.gravesign = new BlockCoord(x, my_y, z - 1);
                    this.coffin_a = new BlockCoord(x, my_y - 2, z - 2);
                    this.coffin_b = new BlockCoord(x, my_y - 2, z - 1);
                    this.graveground_a = new BlockCoord(x, my_y - 1, z - 1);
                    this.graveground_b = new BlockCoord(x, my_y - 1, z - 2);
                    this.gravesign_dir = 2;
                    break;
                }
                case 3: {
                    this.gravestone = new BlockCoord(x, my_y, z);
                    this.graveplant = new BlockCoord(x, my_y + 1, z);
                    this.gravesign = new BlockCoord(x + 1, my_y, z);
                    this.coffin_a = new BlockCoord(x + 1, my_y - 2, z);
                    this.coffin_b = new BlockCoord(x + 2, my_y - 2, z);
                    this.graveground_a = new BlockCoord(x + 1, my_y - 1, z);
                    this.graveground_b = new BlockCoord(x + 2, my_y - 1, z);
                    this.gravesign_dir = 5;
                    break;
                }
                default: {
                    this.gravestone = new BlockCoord(x, my_y, z);
                    this.graveplant = new BlockCoord(x, my_y + 1, z);
                    this.gravesign = new BlockCoord(x, my_y, z + 1);
                    this.coffin_a = new BlockCoord(x, my_y - 2, z + 1);
                    this.coffin_b = new BlockCoord(x, my_y - 2, z + 2);
                    this.graveground_a = new BlockCoord(x, my_y - 1, z + 1);
                    this.graveground_b = new BlockCoord(x, my_y - 1, z + 2);
                    this.gravesign_dir = 3;
                }
            }
        }
    }
}

