/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.fire;

import java.util.ArrayList;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bending.fire.FireStream;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;

public class FireWall
extends AsynchronousAbility {
    private ArrayList<BlockBukkit> rootBlocks = new ArrayList();
    private Long time = System.currentTimeMillis();
    private Long starttime = System.currentTimeMillis();
    private Long walltime;
    private int total = 10;
    private double size = 1.0;
    private int height;
    private int length;
    private static int cooldown = 15000;
    private int level;

    public FireWall(EntityLivingBase user, int level) {
        super(user, cooldown + level * 3000);
        if (level == 0) {
            this.walltime = 5000L;
            this.height = 4;
            this.length = 4;
        }
        if (level == 1) {
            this.walltime = 10000L;
            this.height = 8;
            this.length = 10;
        }
        if (level == 2) {
            this.walltime = 20000L;
            this.height = 12;
            this.length = 17;
        }
        this.level = level;
        this.selectRootBlocks(user);
    }

    @Override
    public void update() {
        if (System.currentTimeMillis() > this.starttime + this.walltime) {
            for (BlockBukkit b : this.rootBlocks) {
                if (b.getType() != Blocks.field_150480_ab) continue;
                b.setTypeWithProtection(Blocks.field_150350_a);
            }
            this.destroy();
        }
        if (System.currentTimeMillis() > this.time + 30L) {
            this.time = System.currentTimeMillis();
            for (BlockBukkit b : this.rootBlocks) {
                if (b.getType() != Blocks.field_150480_ab) {
                    b.setTypeWithProtection((Block)Blocks.field_150480_ab);
                }
                for (int i = 0; i < this.height; ++i) {
                    int x = b.getRelative(BlockBukkit.UP, i).getX();
                    int y = b.getRelative(BlockBukkit.UP, i).getY();
                    int z = b.getRelative(BlockBukkit.UP, i).getZ();
                    PacketSender.spawnParticle("Avatar_flamesbig", b.getLocation().getWorld(), x, y, z, this.total, this.size);
                }
                for (Object o : this.user.field_70170_p.field_72996_f) {
                    Location el;
                    if (!(o instanceof Entity)) continue;
                    Entity e = (Entity)o;
                    Location l = b.getLocation();
                    if (!(l.distance(el = new Location(e)) < 2.0) || e == this.user) continue;
                    e.func_70015_d(20);
                }
                BendingUtils.damageEntities(b.getLocation(), 1.0f, AvatarDamageSource.firebending, this.level);
            }
        }
    }

    private void selectRootBlocks(EntityLivingBase user) {
        Location origin = new Location((Entity)user);
        Vector temp = origin.getDirection();
        temp.normalize();
        double x = temp.getZ();
        double y = 0.0;
        double z = -temp.getX();
        Vector direction = new Vector(x, y, z);
        int range = this.length;
        origin.add(temp);
        origin.add(temp);
        Location locationforward = origin.clone();
        Location locationbackward = origin.clone();
        while (locationforward.distance(origin) < (double)range) {
            locationforward.add(direction);
            this.addRootBlock(locationforward.getBlock());
        }
        while (locationbackward.distance(origin) < (double)range) {
            locationbackward.subtract(direction);
            this.addRootBlock(locationbackward.getBlock());
        }
    }

    private void addRootBlock(BlockBukkit b) {
        if (FireStream.isIgnitable(b)) {
            b.setType((Block)Blocks.field_150480_ab);
            this.rootBlocks.add(b);
        } else if (FireStream.isIgnitable(b.getRelative(BlockBukkit.UP))) {
            b.getRelative(BlockBukkit.UP).setTypeWithProtection((Block)Blocks.field_150480_ab);
            this.rootBlocks.add(b.getRelative(BlockBukkit.UP));
        } else if (FireStream.isIgnitable(b.getRelative(BlockBukkit.DOWN))) {
            b.getRelative(BlockBukkit.DOWN).setTypeWithProtection((Block)Blocks.field_150480_ab);
            this.rootBlocks.add(b.getRelative(BlockBukkit.DOWN));
        }
    }

    @Override
    public String getName() {
        return "Fire Wall";
    }
}

