/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.fire;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.mod_Avatar;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.EntityActionPerformer;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;

public class FireStream
extends AsynchronousAbility {
    private float speed = 15.0f;
    private long interval = (long)(1000.0f / this.speed);
    private long burntime = 400L;
    private ConcurrentHashMap<BlockBukkit, Long> onFire = new ConcurrentHashMap();
    private Location origin;
    private Location location;
    private Vector direction;
    private int range;
    private long time;
    private Block fireBlock = Blocks.field_150480_ab;
    private boolean finished = false;
    private Random r;

    public FireStream(Location location, Vector direction, int level, EntityLivingBase user) {
        super(user, 3000 + level * 3000);
        this.time = System.currentTimeMillis();
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        this.direction.setY(0);
        this.direction.normalize();
        this.location.add(this.direction);
        this.user = user;
        if (level == 0) {
            this.range = 6;
        }
        if (level == 1) {
            this.range = 12;
        }
        if (level == 2) {
            this.fireBlock = mod_Avatar.BlueFireIns;
            this.range = 20;
        }
        this.r = new Random();
    }

    @Override
    public void update() {
        if (this.user.func_70027_ad()) {
            this.user.func_70066_B();
        }
        for (BlockBukkit block : this.onFire.keySet()) {
            if (this.r.nextInt(300) == 0) {
                PacketSender.spawnParticle("Avatar_flames", this.location.getWorld(), (double)block.getX() + this.r.nextDouble(), (double)block.getY() + 0.5 + this.r.nextDouble(), (double)block.getZ() + this.r.nextDouble());
            }
            if (block.getType() != this.fireBlock) {
                this.onFire.remove(block);
                continue;
            }
            long time = this.onFire.get(block);
            if (System.currentTimeMillis() <= time + this.burntime) continue;
            block.setTypeWithProtection(Blocks.field_150350_a);
            this.onFire.remove(block);
        }
        if (this.finished) {
            if (this.onFire.isEmpty()) {
                this.destroy();
                return;
            }
            return;
        }
        if (System.currentTimeMillis() - this.time >= this.interval) {
            this.time = System.currentTimeMillis();
            this.location.add(this.direction);
            if (this.location.distance(this.origin) > (double)this.range) {
                this.finished = true;
                return;
            }
            BlockBukkit block = this.location.getBlock();
            if (FireStream.isIgnitable(block)) {
                this.ignite(block);
                return;
            }
            if (FireStream.isIgnitable(block.getRelative(BlockBukkit.DOWN))) {
                this.ignite(block.getRelative(BlockBukkit.DOWN));
                this.location = block.getRelative(BlockBukkit.DOWN).getLocation();
                return;
            }
            if (FireStream.isIgnitable(block.getRelative(BlockBukkit.UP))) {
                this.ignite(block.getRelative(BlockBukkit.UP));
                this.location = block.getRelative(BlockBukkit.UP).getLocation();
                return;
            }
            this.finished = true;
            return;
        }
    }

    public void ignite(BlockBukkit block) {
        block.setTypeWithProtection(this.fireBlock);
        this.onFire.put(block, System.currentTimeMillis());
        if (this.fireBlock == mod_Avatar.BlueFireIns) {
            BendingUtils.damageEntitiesWithCustomAction(this.user, block.getLocation(), 1.0f, AvatarDamageSource.firebending, 5, new EntityActionPerformer(){

                @Override
                public void performAction(Entity e) {
                    e.func_70015_d(2);
                }
            });
        } else {
            BendingUtils.damageEntitiesWithCustomAction(this.user, block.getLocation(), 1.0f, AvatarDamageSource.firebending, 3, new EntityActionPerformer(){

                @Override
                public void performAction(Entity e) {
                    e.func_70015_d(1);
                }
            });
        }
    }

    public static boolean isIgnitable(BlockBukkit block) {
        Block[] overwriteable = new Block[]{Blocks.field_150345_g, Blocks.field_150329_H, Blocks.field_150330_I, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150480_ab, Blocks.field_150433_aE, Blocks.field_150478_aa};
        if (Arrays.asList(overwriteable).contains(block.getType())) {
            return true;
        }
        if (block.getType() == mod_Avatar.BlueFireIns) {
            return true;
        }
        if (block.getType() != Blocks.field_150350_a) {
            return false;
        }
        Block[] ignitable = new Block[]{mod_Avatar.CharredGrassBlock, Blocks.field_150357_h, Blocks.field_150342_X, Blocks.field_150336_V, Blocks.field_150435_aG, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150346_d, Blocks.field_150377_bs, Blocks.field_150450_ax, Blocks.field_150340_R, Blocks.field_150351_n, Blocks.field_150349_c, Blocks.field_150419_aX, Blocks.field_150420_aW, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150364_r, Blocks.field_150341_Y, Blocks.field_150391_bh, Blocks.field_150385_bj, Blocks.field_150424_aL, Blocks.field_150343_Z, Blocks.field_150450_ax, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150417_aV, Blocks.field_150348_b, Blocks.field_150425_aM, Blocks.field_150433_aE, Blocks.field_150344_f, Blocks.field_150325_L, Blocks.field_150362_t};
        BlockBukkit belowblock = block.getRelative(BlockBukkit.DOWN);
        return Arrays.asList(ignitable).contains(belowblock.getType());
    }

    @Override
    public String getName() {
        return "Fire Stream";
    }
}

