/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.fire;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Random;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;

public class FireLightning
extends AsynchronousAbility {
    private Long starttime;
    private int level;
    private int damage;
    private boolean isRaining = false;
    private static int cooldown = 20000;
    private Random rand;

    public FireLightning(EntityLivingBase user, int damage, int level) {
        super(user, cooldown + level * 5000);
        this.user = user;
        this.level = level;
        this.damage = damage;
        this.starttime = System.currentTimeMillis();
        this.rand = new Random();
    }

    @Override
    public void update() {
        if (this.user.func_70093_af()) {
            BlockBukkit t = BlockBukkit.getTargetBlock(this.user);
            PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
            try {
                pb.writeInt("FireLightning".getBytes().length);
                pb.writeBytes("FireLightning".getBytes());
                pb.writeDouble((double)t.getX());
                pb.writeDouble((double)t.getY());
                pb.writeDouble((double)t.getZ());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarBend", (ByteBuf)pb);
            MinecraftServer.func_71276_C().func_71203_ab().func_148540_a((Packet)packet);
            return;
        }
        this.strike(System.currentTimeMillis() - this.starttime);
        if (this.user.field_70170_p.func_72896_J()) {
            this.isRaining = true;
        }
    }

    private void strike(Long charge) {
        Location l;
        float power;
        switch (this.level) {
            case 0: {
                if (this.isRaining) {
                    power = (float)charge.longValue() / 1700.0f;
                    break;
                }
                power = (float)charge.longValue() / 2000.0f;
                break;
            }
            case 1: {
                if (this.isRaining) {
                    power = (float)charge.longValue() / 1200.0f;
                    break;
                }
                power = (float)charge.longValue() / 1500.0f;
                break;
            }
            case 2: {
                if (this.isRaining) {
                    power = (float)charge.longValue() / 300.0f;
                    break;
                }
                power = (float)charge.longValue() / 500.0f;
                break;
            }
            default: {
                power = this.isRaining ? (float)charge.longValue() / 1700.0f : (float)charge.longValue() / 2000.0f;
            }
        }
        if (power > 20.0f) {
            power = 20.0f;
        }
        if (power < 1.0f) {
            power = 1.0f;
        }
        Random random = new Random();
        int i = 0;
        while ((float)i < power * 2.0f) {
            l = BlockBukkit.getTargetBlock(this.user).getLocation();
            l.setX(l.getX() + (double)((float)random.nextInt() % power) - (double)(power / 2.0f));
            l.setZ(l.getZ() + (double)((float)random.nextInt() % power) - (double)(power / 2.0f));
            this.user.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.user.field_70170_p, l.getX(), l.getY(), l.getZ()));
            if (l.getBlock().getType() == Blocks.field_150354_m) {
                l.getBlock().setTypeWithProtection(Blocks.field_150359_w);
            }
            BendingUtils.damageEntities(l, 2.5f, AvatarDamageSource.firebending, this.damage);
            ++i;
        }
        if (power > 15.0f) {
            i = 0;
            while ((double)i < (double)power - 14.9) {
                l = BlockBukkit.getTargetBlock(this.user).getLocation();
                l.setX(l.getX() + (double)((float)random.nextInt() % power) - (double)(power / 2.0f));
                l.setZ(l.getZ() + (double)((float)random.nextInt() % power) - (double)(power / 2.0f));
                this.user.field_70170_p.func_72876_a(null, l.getX(), l.getY(), l.getZ(), 2.0f, true);
                ++i;
            }
            i = 0;
            while ((double)i < (double)power - 14.9) {
                l = BlockBukkit.getTargetBlock(this.user).getLocation();
                l.setX(l.getX() + (double)((float)random.nextInt() % power) - (double)(power / 2.0f));
                l.setZ(l.getZ() + (double)((float)random.nextInt() % power) - (double)(power / 2.0f));
                if (l.getBlock().getType() == Blocks.field_150350_a) {
                    boolean isAir = true;
                    while (isAir) {
                        l.setY(l.getY() - 1.0);
                        if (l.getBlock().getType() == Blocks.field_150350_a) continue;
                        isAir = false;
                    }
                }
                l.getBlock().setTypeWithProtection((Block)Blocks.field_150480_ab);
                ++i;
            }
        }
        this.destroy();
    }

    public void damageEntities(Location loc) {
        for (Object o : loc.getWorld().func_72910_y()) {
            EntityLivingBase e;
            if (!(o instanceof EntityLivingBase) || !(loc.distance((Entity)(e = (EntityLivingBase)o)) < 2.5)) continue;
            e.func_70097_a((DamageSource)AvatarDamageSource.firebending, 4.0f);
        }
    }

    @Override
    public String getName() {
        return "Lightning";
    }
}

