/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.Messaging;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class EarthThrow
extends AsynchronousAbility {
    private Location sourceLocation;
    private Location blockLocation;
    private Location prevBlockLocation;
    private int blockMovementState;
    private int blockMaterialState;
    private Vector velocity;
    private int range;
    private int level;
    private long lastmovement = 0L;
    private Block blockType;
    private int metadata;
    private boolean finished = false;
    private Long time;
    private int damage;
    private static int BLOCK_MVE_IDLE = 0;
    private static int BLOCK_MVE_TRAVELLING = 1;
    private static int BLOB_MAT_WATER = 10;
    private static int BLOCK_MAT_FROZEN = 11;

    public EarthThrow(EntityLivingBase user, Long cooldowntime, Location l, int level) {
        super(user, cooldowntime);
        if (!BendingUtils.isEarthBendable(l.getBlock().getType())) {
            if (user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "Not Earth bendable!");
            }
            this.destroy();
            return;
        }
        Block m = l.getBlock().getType();
        if (BendingUtils.isEarthBendable(m)) {
            this.blockType = Blocks.field_150348_b;
        }
        if (m == Blocks.field_150346_d || m == Blocks.field_150349_c) {
            this.blockType = Blocks.field_150346_d;
        }
        if (m == Blocks.field_150354_m || m == Blocks.field_150322_A) {
            this.blockType = Blocks.field_150322_A;
        }
        if (m == Blocks.field_150406_ce || m == Blocks.field_150405_ch || m == Blocks.field_150435_aG) {
            this.blockType = m;
            Location loc2 = l.getBlock().getLocation();
            this.metadata = loc2.getWorld().func_72805_g(loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ());
        }
        this.level = level;
        this.sourceLocation = l.clone();
        this.blockLocation = l.clone();
        this.blockMovementState = BLOCK_MVE_IDLE;
        this.blockMaterialState = BLOCK_MAT_FROZEN;
        this.prevBlockLocation = new Location(this.blockLocation.getWorld(), 0.0, 240.0, 0.0);
        this.time = System.currentTimeMillis();
        this.blockLocation.getBlock().setTypeWithProtection(Blocks.field_150350_a);
    }

    @Override
    public void update() {
        if (this.blockMovementState == BLOCK_MVE_IDLE) {
            if (!this.user.func_70093_af()) {
                this.prevBlockLocation.getBlock().setTypeWithProtection(Blocks.field_150350_a);
                this.destroy();
                return;
            }
            Location l = new Location(this.user.field_70170_p, this.user.field_70165_t, this.user.field_70163_u + 1.62, this.user.field_70161_v);
            Vector v = new Vector(this.user.func_70040_Z().field_72450_a, this.user.func_70040_Z().field_72448_b, this.user.func_70040_Z().field_72449_c);
            v.normalize();
            v.multiply(3);
            l.add(v);
            this.blockLocation = l.clone();
        }
        if (this.blockMovementState == BLOCK_MVE_TRAVELLING) {
            long delta = this.lastmovement == 0L ? 10L : System.currentTimeMillis() - this.lastmovement;
            this.lastmovement = System.currentTimeMillis();
            Location newLoc = this.blockLocation.add(this.velocity.clone().multiply(delta));
            if (BendingUtils.isEarthBendable(newLoc.getBlock().getType()) || newLoc.getBlock().getType() == Blocks.field_150350_a || newLoc.getBlock().getType() == Blocks.field_150355_j || newLoc.getBlock().getType() == Blocks.field_150353_l) {
                this.blockLocation.add(this.velocity.clone().multiply(delta));
                BendingUtils.damageEntities(this.user, this.blockLocation, 2.0f, AvatarDamageSource.earthbending, this.damage);
            } else {
                this.finished = true;
            }
            if (this.blockLocation.distance(this.sourceLocation) > (double)this.range) {
                this.finished = true;
            }
        }
        if (this.blockMaterialState == BLOCK_MAT_FROZEN && this.blockLocation != this.prevBlockLocation && (this.blockLocation.getBlock().getType() == Blocks.field_150350_a || this.blockLocation.getBlock().getType() == Blocks.field_150355_j || this.blockLocation.getBlock().getType() == Blocks.field_150353_l)) {
            this.prevBlockLocation.getBlock().setTypeWithProtection(Blocks.field_150350_a);
            this.blockLocation.getBlock().setTypeWithProtection(this.blockType);
            this.prevBlockLocation = this.blockLocation.clone();
        }
        if (this.finished) {
            this.prevBlockLocation.getBlock().setTypeWithProtection(Blocks.field_150350_a);
            this.destroy();
            return;
        }
    }

    public void sendForthZeBlob(Vector vel, int range, int damage) {
        if (this.blockMovementState != BLOCK_MVE_IDLE) {
            return;
        }
        this.range = range;
        this.damage = damage;
        this.sourceLocation = this.blockLocation.clone();
        this.velocity = vel;
        this.blockMovementState = BLOCK_MVE_TRAVELLING;
    }

    public void makeItGoBoom() {
    }

    @Override
    public String getName() {
        return "Manipulate";
    }
}

