/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import kieranvs.avatar.Protection;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.EntityActionPerformer;
import kieranvs.avatar.util.Messaging;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;

public class EarthLaunch
extends AsynchronousAbility {
    private long time;
    private int iteration;
    private Location location;
    private BlockBukkit block;
    private final float power;
    private final EntityLivingBase user2;

    public EarthLaunch(EntityLivingBase user, Long cooldown, float power) {
        super(user, cooldown);
        this.user = user;
        this.user2 = user;
        this.time = System.currentTimeMillis();
        this.iteration = 0;
        this.block = BlockBukkit.getTargetBlock(user);
        this.location = this.block.getLocation();
        this.power = power;
    }

    @Override
    public void update() {
        if (!BendingUtils.isEarthBendable(this.block.getType())) {
            if (this.user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "Target block is not an Earth bendable block!");
            }
            this.destroy();
            return;
        }
        BendingUtils.damageEntitiesWithCustomAction(this.user2, this.location, 2.0f, AvatarDamageSource.earthbending, 1, new EntityActionPerformer(){

            @Override
            public void performAction(Entity e) {
                PacketSender.sendVelocity(e, new Vector(0.0f, EarthLaunch.this.power, 0.0f));
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(9, 80, 0));
            }
        });
        PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, this.location.getX(), this.location.getY(), this.location.getZ(), 50, 0.5);
        Block blockType = null;
        int metadata = 0;
        if (BendingUtils.isEarthBendable(this.block.getType())) {
            blockType = Blocks.field_150348_b;
        }
        if (this.block.getType() == Blocks.field_150346_d || this.block.getType() == Blocks.field_150349_c) {
            blockType = Blocks.field_150346_d;
        }
        if (this.block.getType() == Blocks.field_150354_m || this.block.getType() == Blocks.field_150322_A) {
            blockType = Blocks.field_150322_A;
        }
        if (this.block.getType() == Blocks.field_150406_ce || this.block.getType() == Blocks.field_150405_ch || this.block.getType() == Blocks.field_150435_aG || this.block.getType() == Blocks.field_150351_n) {
            blockType = this.block.getType();
            Location loc2 = this.location.getBlock().getRelative(BlockBukkit.DOWN).getLocation();
            metadata = loc2.getWorld().func_72805_g(loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ());
        }
        Protection.trySetBlockAndMeta(this.user.field_70170_p, blockType, this.block.getRelative(BlockBukkit.UP).getX(), this.block.getRelative(BlockBukkit.UP).getY(), this.block.getRelative(BlockBukkit.UP).getZ(), metadata, 2);
        Protection.trySetBlockAndMeta(this.user.field_70170_p, blockType, this.block.getRelative(BlockBukkit.UP, 2).getX(), this.block.getRelative(BlockBukkit.UP, 2).getY(), this.block.getRelative(BlockBukkit.UP, 2).getZ(), metadata, 2);
        this.destroy();
    }

    @Override
    public String getName() {
        return "Launch";
    }
}

