/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.air;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Random;
import kieranvs.avatar.bending.AbilityTCFix;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.client.EntityAvatarBubbleFX;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.EntityActionPerformer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityCloudFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.particle.EntitySplashFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class AirTornado
extends AsynchronousAbility
implements AbilityTCFix {
    private long starttime;
    private long lifetime;
    private int radius = 3;
    private int height;
    private Vector direction;
    private Location[] locations;
    private Random r = new Random();
    private int twistanim = 0;
    private int animspeed;

    public AirTornado(EntityLivingBase entity, Long cooldown, Location location, Vector direction, int height, int radius, float speed, float slant, long lifetime, int animspeed) {
        super(entity, cooldown + lifetime);
        this.height = height;
        this.radius = radius;
        this.lifetime = lifetime;
        this.animspeed = animspeed;
        this.direction = direction.clone().normalize().multiply(speed);
        this.direction.setY(0);
        this.locations = new Location[height];
        for (int i = 0; i < height; ++i) {
            this.locations[i] = location.clone();
            float laidbacknessforthislayer = (float)i / (float)height * slant;
            this.locations[i].subtract(direction.clone().multiply(laidbacknessforthislayer));
        }
        this.starttime = System.currentTimeMillis();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
            try {
                pb.writeInt("AirTornado".getBytes().length);
                pb.writeBytes("AirTornado".getBytes());
                pb.writeInt(entity.func_110124_au().toString().length());
                pb.writeBytes(entity.func_110124_au().toString().getBytes());
                pb.writeDouble(location.getX());
                pb.writeDouble(location.getY());
                pb.writeDouble(location.getZ());
                pb.writeDouble(direction.getX());
                pb.writeDouble(direction.getY());
                pb.writeDouble(direction.getZ());
                pb.writeInt(height);
                pb.writeInt(radius);
                pb.writeFloat(speed);
                pb.writeFloat(slant);
                pb.writeLong(lifetime);
                pb.writeInt(animspeed);
                pb.writeLong(cooldown + lifetime);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarBend", (ByteBuf)pb);
            MinecraftServer.func_71276_C().func_71203_ab().func_148540_a((Packet)packet);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClientSide() {
        if (System.currentTimeMillis() > this.starttime + this.lifetime) {
            this.destroy();
            return;
        }
        this.updateLocations(this.direction);
        int i = 0;
        while (i < this.height) {
            Location t = this.locations[i].clone();
            t.setY(this.locations[i].getY() + (double)((float)i / 10.0f));
            float thisradius = (float)((double)this.radius + Math.sin(Math.toRadians(i - 90))) + (float)(i / this.height) * 2.0f;
            if (i % this.animspeed == 0) {
                ++this.twistanim;
            }
            float modradius = (float)i / (float)this.height * 4.0f;
            double modx = (double)modradius * Math.sin(Math.toRadians(i + this.twistanim));
            double modz = (double)modradius * Math.cos(Math.toRadians(i + this.twistanim));
            t.setX(this.locations[i].getX() + modx);
            t.setZ(this.locations[i].getZ() + modz);
            this.doTheThing(t.getX(), t.getY(), t.getZ(), thisradius, 6, 15, 0);
            BendingUtils.damageAllEntitiesWithCustomAction(null, t, thisradius * 2.0f, AvatarDamageSource.airbending, 0, new EntityActionPerformer(){

                @Override
                public void performAction(Entity e) {
                    Random r = new Random();
                    if (r.nextInt(3) == 0) {
                        e.func_70016_h(0.0, 0.4, 0.0);
                    }
                    if (r.nextInt(50) == 1) {
                        e.func_70016_h(0.5, 0.0, 0.0);
                        if (r.nextInt(50) == 2) {
                            e.func_70016_h(0.0, 0.0, 0.5);
                        }
                    }
                    if (r.nextInt(50) == 2) {
                        e.func_70016_h(0.0, 0.0, 0.5);
                        if (r.nextInt(50) == 3) {
                            e.func_70016_h(0.0, 0.0, 0.5);
                        }
                    }
                }
            });
            i = (int)((double)i + 1.0);
        }
    }

    @Override
    public void update() {
        if (System.currentTimeMillis() > this.starttime + this.lifetime) {
            this.destroy();
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doTheThing(double x, double y, double z, double radius, int xzquality, int rarity, int element) {
        Random r = new Random();
        for (int t = 0; t < 360; ++t) {
            if (t % xzquality != 0 || r.nextInt(rarity) != 0) continue;
            double spawnX = x + radius * Math.cos(Math.toRadians(t));
            double spawnY = y;
            double spawnZ = z + radius * Math.sin(Math.toRadians(t));
            if (element == 0) {
                if (r.nextInt(2) == 0) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityCloudFX((World)Minecraft.func_71410_x().field_71441_e, spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0));
                } else {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntitySmokeFX((World)Minecraft.func_71410_x().field_71441_e, spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0));
                }
            }
            if (element == 1) {
                if (r.nextInt(7) == 0) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityAvatarBubbleFX((World)Minecraft.func_71410_x().field_71441_e, spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0));
                } else {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntitySplashFX((World)Minecraft.func_71410_x().field_71441_e, spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0));
                }
            }
            if (element != 2) continue;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityFlameFX((World)Minecraft.func_71410_x().field_71441_e, spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0));
        }
    }

    public void updateLocations(Vector direction) {
    }

    @Override
    public String getName() {
        return null;
    }
}

