/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Random;
import kieranvs.avatar.Protection;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.mod_Avatar;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBlueFire
extends TileEntity {
    private static Random rand = new Random();
    private static Block[] destroyBlocks = new Block[]{Blocks.field_150350_a, Blocks.field_150344_f, Blocks.field_150345_g, Blocks.field_150362_t, Blocks.field_150321_G, Blocks.field_150330_I, Blocks.field_150329_H, Blocks.field_150325_L, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150480_ab, Blocks.field_150464_aj, Blocks.field_150444_as, Blocks.field_150442_at, Blocks.field_150433_aE, Blocks.field_150432_aD, Blocks.field_150431_aC, Blocks.field_150434_aF, Blocks.field_150436_aH};
    private static Block[] unburnableBlocks = new Block[]{Blocks.field_150350_a, Blocks.field_150356_k, Blocks.field_150353_l, Blocks.field_150359_w, mod_Avatar.BlueFireIns, Blocks.field_150357_h, mod_Avatar.CharredGrassBlock};
    private int lifetime;

    public TileEntityBlueFire() {
        this.lifetime = 0;
    }

    public TileEntityBlueFire(int life) {
        this.lifetime = life;
    }

    public int getLifeTime() {
        return this.lifetime;
    }

    public void setLifeTime(int life) {
        this.lifetime = life;
    }

    public void func_145845_h() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        if (this.lifetime < 0) {
            this.lifetime = 0;
        }
        boolean autodelete = false;
        int c = 0;
        for (Object e : this.field_145850_b.field_147482_g) {
            if (!(e instanceof TileEntityBlueFire)) continue;
            ++c;
        }
        if (c > 1000) {
            autodelete = true;
        }
        if (!Protection.canBlockChangeHere(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            autodelete = true;
        }
        ++this.lifetime;
        if ((this.lifetime > 1000 || autodelete) && (rand.nextInt(5) == 0 || autodelete || this.lifetime > 1500)) {
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
            this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_145843_s();
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150349_c) {
                if (rand.nextInt(4) == 0) {
                    this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, (Block)mod_Avatar.CharredGrassBlock, 0, 2);
                } else {
                    this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Blocks.field_150346_d, 0, 2);
                }
            } else if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150354_m) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Blocks.field_150359_w, 0, 2);
            }
            return;
        }
        this.spread();
        this.burnNearbyEntites();
        this.checkNearbyStuff(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void spread() {
        this.burnRelativeWithChance(1, 0, 0, 100);
        this.burnRelativeWithChance(-1, 0, 0, 100);
        this.burnRelativeWithChance(0, 1, 0, 20);
        this.burnRelativeWithChance(0, -1, 0, 2000);
        this.burnRelativeWithChance(0, 0, 1, 100);
        this.burnRelativeWithChance(0, 0, -1, 100);
    }

    private void burnRelativeWithChance(int x, int y, int z, int chance) {
        if (this.canBlockBurn(this.field_145850_b, this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) && rand.nextInt(chance) == 0) {
            this.burnBlock(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
        }
    }

    private void burnBlock(int x, int y, int z) {
        this.field_145850_b.func_147465_d(x, y, z, (Block)mod_Avatar.BlueFireIns, 0, 2);
        if (this.field_145850_b.func_147438_o(x, y, z) != null && this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityBlueFire) {
            ((TileEntityBlueFire)this.field_145850_b.func_147438_o(x, y, z)).setLifeTime(this.lifetime);
        }
    }

    private void checkNearbyStuff(int a, int b, int c) {
        for (int i = -3; i < 4; ++i) {
            for (int j = -3; j < 4; ++j) {
                for (int k = -3; k < 4; ++k) {
                    int x = a + i;
                    int y = b + j;
                    int z = c + k;
                    if (this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150335_W) {
                        this.lifetime = (int)((float)this.lifetime + 850.0f);
                        this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150350_a);
                        this.field_145850_b.func_72876_a(null, (double)x, (double)y, (double)z, 40.0f, true);
                    }
                    if (this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150353_l || this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150356_k) {
                        this.lifetime = (int)((float)this.lifetime + 850.0f);
                        this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150350_a);
                        this.field_145850_b.func_72876_a(null, (double)x, (double)y, (double)z, 4.0f, true);
                        this.orangeFireSurroundings(x, y, z);
                    }
                    if (this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150362_t && rand.nextInt(500) == 0) {
                        this.lifetime = (int)((float)this.lifetime - 50.0f);
                        this.orangeFireSurroundings(x, y, z, 200);
                    }
                    if (this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150355_j && this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150358_i || rand.nextInt(500) != 0) continue;
                    this.lifetime = (int)((float)this.lifetime + 100.0f);
                    this.burnBlock(x, y, z);
                    PacketSender.spawnParticle("Avatar_cloud", this.field_145850_b, x, y, z, 50, 1.5);
                    this.orangeFireSurroundings(x, y, z, 500);
                }
            }
        }
    }

    private void orangeFireSurroundings(int x, int y, int z) {
        this.orangeFireSurroundings(x, y, z, 1);
    }

    private void orangeFireSurroundings(int x, int y, int z, int chance) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int k = -2; k < 3; ++k) {
                    if (rand.nextInt(chance) != 0 || this.field_145850_b.func_147439_a(x + i, y + j, z + k) != Blocks.field_150350_a) continue;
                    this.field_145850_b.func_147449_b(x + i, y + j, z + k, (Block)Blocks.field_150480_ab);
                }
            }
        }
    }

    private boolean canBlockBurn(World w, int x, int y, int z) {
        if (!this.contains(destroyBlocks, w.func_147439_a(x, y, z))) {
            return false;
        }
        return !this.contains(unburnableBlocks, w.func_147439_a(x, y - 1, z)) || !this.contains(unburnableBlocks, w.func_147439_a(x + 1, y, z)) || !this.contains(unburnableBlocks, w.func_147439_a(x - 1, y, z)) || !this.contains(unburnableBlocks, w.func_147439_a(x, y, z + 1)) || !this.contains(unburnableBlocks, w.func_147439_a(x, y, z - 1));
    }

    public static boolean canRenderSideFire(IBlockAccess w, int x, int y, int z, ForgeDirection face) {
        Block block = w.func_147439_a(x, y, z);
        return block != null;
    }

    private boolean contains(Block[] array, Block key) {
        for (Block i : array) {
            if (i != key) continue;
            return true;
        }
        return false;
    }

    private void burnNearbyEntites() {
        Location location = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Object[] o = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < o.length; ++i) {
            EntityLivingBase e;
            if (!(o[i] instanceof EntityLivingBase) || !(location.distance((Entity)(e = (EntityLivingBase)o[i])) < 1.2)) continue;
            if (e instanceof EntityPlayer) {
                e.func_70097_a((DamageSource)AvatarDamageSource.firebending, 4.0f);
            } else {
                e.func_70097_a((DamageSource)AvatarDamageSource.firebending, 12.0f);
            }
            e.func_70015_d(20);
            if (!(e instanceof EntityCreeper)) continue;
            e.field_70170_p.func_72876_a((Entity)e, e.field_70165_t, e.field_70163_u, e.field_70161_v, 10.0f, true);
            e.func_70106_y();
        }
    }

    public boolean canUpdate() {
        return true;
    }
}

