/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.water;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.Messaging;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class WaterIceWall
extends AsynchronousAbility {
    private ArrayList<BlockBukkit> rootBlocks = new ArrayList();
    private ArrayList<BlockBukkit> toCrumble = new ArrayList();
    private int stage = 0;
    private Long time;
    private Long starttime;
    private Long endtime;
    private int iteration = 0;
    private boolean isSnow = false;
    private Random r = new Random();
    private static int cooldown = 5000;
    private int level;

    public WaterIceWall(EntityLivingBase user, int level, boolean isSnow) {
        super(user, cooldown + level * 2500);
        this.time = System.currentTimeMillis();
        this.starttime = System.currentTimeMillis();
        this.isSnow = isSnow;
        this.level = level;
        this.selectRootBlocks(user);
    }

    @Override
    public void update() {
        if (this.stage == 0) {
            if (System.currentTimeMillis() > this.time + 100L) {
                ++this.iteration;
                if (this.iteration > this.level * 2 + 5) {
                    this.stage = 1;
                    this.endtime = System.currentTimeMillis();
                    return;
                }
                this.time = System.currentTimeMillis();
                for (BlockBukkit b : this.rootBlocks) {
                    if (b.getRelative(BlockBukkit.UP, this.iteration).getType() != Blocks.field_150350_a) continue;
                    if (this.isSnow) {
                        b.getRelative(BlockBukkit.UP, this.iteration).setTypeWithProtection(Blocks.field_150433_aE);
                    } else {
                        b.getRelative(BlockBukkit.UP, this.iteration).setTypeWithProtection(Blocks.field_150432_aD);
                    }
                    this.toCrumble.add(b.getRelative(BlockBukkit.UP, this.iteration));
                }
            }
        } else if (System.currentTimeMillis() - this.endtime > 3000L && System.currentTimeMillis() - this.time > 250L) {
            this.time = System.currentTimeMillis();
            if (this.toCrumble.size() > 0) {
                BlockBukkit b = this.toCrumble.get(this.r.nextInt(this.toCrumble.size()));
                boolean isTop = false;
                while (!isTop) {
                    if (this.toCrumble.contains(b.getRelative(BlockBukkit.UP))) {
                        b = b.getRelative(BlockBukkit.UP);
                        continue;
                    }
                    isTop = true;
                }
                this.toCrumble.remove(b);
                b.setTypeWithProtection(Blocks.field_150350_a);
                PacketSender.spawnParticle("Avatar_cloud", b.getLocation().getWorld(), b.getX(), b.getY(), b.getZ(), 10, 0.5);
            } else {
                this.destroy();
                return;
            }
        }
    }

    private void selectRootBlocks(EntityLivingBase user) {
        BlockBukkit t = BlockBukkit.getTargetBlock(user);
        Location origin = t.getLocation();
        Location userLoc = new Location((Entity)user);
        if (this.level == 0 && userLoc.distance(origin) > 5.0) {
            if (user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "Out of range!");
            }
            this.destroy();
        }
        if (this.level == 1 && userLoc.distance(origin) > 10.0) {
            if (user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "Out of range!");
            }
            this.destroy();
        }
        if (this.level == 2 && userLoc.distance(origin) > 20.0) {
            if (user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "Out of range!");
            }
            this.destroy();
        }
        Location locationforward = origin.clone();
        Location locationbackward = origin.clone();
        Vector temp = userLoc.getDirection();
        temp.normalize();
        double x = temp.getZ();
        double y = 0.0;
        double z = -temp.getX();
        Vector direction = new Vector(x, y, z);
        int range = 0;
        if (this.level == 0) {
            range = 4;
        }
        if (this.level == 1) {
            range = 8;
        }
        if (this.level == 2) {
            range = 12;
        }
        while (locationforward.distance(origin) < (double)range) {
            locationforward.add(direction);
            this.addRootBlock(locationforward.getBlock());
        }
        while (locationbackward.distance(origin) < (double)range) {
            locationbackward.subtract(direction);
            this.addRootBlock(locationbackward.getBlock());
        }
    }

    private void addRootBlock(BlockBukkit b) {
        if (this.isWaterbendable(b)) {
            this.rootBlocks.add(b);
        } else if (this.isWaterbendable(b.getRelative(BlockBukkit.UP))) {
            this.rootBlocks.add(b.getRelative(BlockBukkit.UP));
        } else if (this.isWaterbendable(b.getRelative(BlockBukkit.DOWN))) {
            this.rootBlocks.add(b.getRelative(BlockBukkit.DOWN));
        }
    }

    private boolean isWaterbendable(BlockBukkit b) {
        Block[] bendable = new Block[]{Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150433_aE, Blocks.field_150433_aE};
        return Arrays.asList(bendable).contains(b.getType());
    }

    @Override
    public String getName() {
        return "Ice Wall";
    }
}

