/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.fire;

import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class FireShield
extends AsynchronousAbility {
    private int radius;
    private int height;
    private long lifetime;
    private long time = System.currentTimeMillis();
    private long interval = 20L;
    private Location location;
    private static int cooldown = 7000;

    public FireShield(EntityLivingBase user, Location location, int level) {
        super(user, cooldown + level * 5000);
        this.location = location;
        if (level == 0) {
            this.radius = 5;
            this.lifetime = 7500L + System.currentTimeMillis();
        }
        if (level == 1) {
            this.radius = 8;
            this.lifetime = 12500L + System.currentTimeMillis();
        }
        if (level == 2) {
            this.radius = 13;
            this.lifetime = 20000L + System.currentTimeMillis();
        }
        this.height = this.radius;
    }

    @Override
    public void update() {
        if (System.currentTimeMillis() > this.lifetime) {
            this.destroy();
            return;
        }
        if (System.currentTimeMillis() > this.time + this.interval) {
            this.time = System.currentTimeMillis();
            this.location = new Location((Entity)this.user);
            if (this.user.func_70093_af()) {
                PacketSender.sendShield(this.location, this.height, this.radius, 10, 3, 10, 2);
                BendingUtils.repelEntitiesOnYourLevelAndAbove(this.user, this.location, this.radius);
            } else {
                this.destroy();
                return;
            }
        }
    }

    @Override
    public String getName() {
        return "Hold shift to create a shield of fire around you - be warned it doesn't last forever!";
    }
}

