/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import kieranvs.avatar.Protection;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.Messaging;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class EarthBridge
extends AsynchronousAbility {
    private Location location;
    private int length;
    private long time;
    private int iteration;
    private Block blockType;
    private int metadata;
    private int forwardDirection = BlockBukkit.WEST;
    private int sideDirectionA = BlockBukkit.NORTH;
    private int sideDirectionB = BlockBukkit.SOUTH;
    private boolean hasNaggedUser = false;

    public EarthBridge(EntityLivingBase e, Location l, int length) {
        super(e, 20000L);
        Vector direction;
        this.location = l;
        this.length = length;
        this.time = System.currentTimeMillis();
        this.iteration = -1;
        Block m = this.location.getBlock().getRelative(BlockBukkit.DOWN).getType();
        if (BendingUtils.isEarthBendable(m)) {
            this.blockType = Blocks.field_150348_b;
        }
        if (m == Blocks.field_150346_d || m == Blocks.field_150349_c) {
            this.blockType = Blocks.field_150346_d;
        }
        if (m == Blocks.field_150354_m || m == Blocks.field_150322_A) {
            this.blockType = Blocks.field_150322_A;
        }
        if (m == Blocks.field_150406_ce || m == Blocks.field_150405_ch || m == Blocks.field_150435_aG || m == Blocks.field_150351_n) {
            this.blockType = m;
            Location loc2 = this.location.getBlock().getRelative(BlockBukkit.DOWN).getLocation();
            this.metadata = loc2.getWorld().func_72805_g(loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ());
        }
        if ((direction = l.getDirection().straightifyXZ()).getX() == 1.0) {
            this.forwardDirection = BlockBukkit.EAST;
            this.sideDirectionA = BlockBukkit.NORTH;
            this.sideDirectionB = BlockBukkit.SOUTH;
        }
        if (direction.getX() == -1.0) {
            this.forwardDirection = BlockBukkit.WEST;
            this.sideDirectionA = BlockBukkit.NORTH;
            this.sideDirectionB = BlockBukkit.SOUTH;
        }
        if (direction.getZ() == 1.0) {
            this.forwardDirection = BlockBukkit.SOUTH;
            this.sideDirectionA = BlockBukkit.EAST;
            this.sideDirectionB = BlockBukkit.WEST;
        }
        if (direction.getZ() == -1.0) {
            this.forwardDirection = BlockBukkit.NORTH;
            this.sideDirectionA = BlockBukkit.EAST;
            this.sideDirectionB = BlockBukkit.WEST;
        }
    }

    @Override
    public void update() {
        if (this.iteration >= this.length) {
            this.destroy();
            return;
        }
        if (this.blockType == null) {
            if (this.user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "Not standing on an Earth bendable block!");
            }
            this.destroy();
            return;
        }
        ++this.iteration;
        BlockBukkit b = this.location.getBlock().getRelative(BlockBukkit.DOWN);
        BlockBukkit w = b.getRelative(this.forwardDirection, this.iteration + 1);
        if (w.getType() == Blocks.field_150350_a || w.getType() == Blocks.field_150355_j || w.getType() == Blocks.field_150353_l) {
            Protection.trySetBlock(this.user.field_70170_p, this.blockType, w.getX(), w.getY(), w.getY());
            PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, w.getX(), w.getY(), w.getZ(), 50, 0.5);
            w.getLocation().getWorld().func_72921_c(w.getX(), w.getY(), w.getZ(), this.metadata, 2);
            this.hasNaggedUser = true;
        } else if (this.user instanceof EntityPlayer && !this.hasNaggedUser) {
            Messaging.avatarMessage((EntityPlayer)this.user, "Bridge must go through air, water or lava!");
            this.hasNaggedUser = true;
        }
        w = b.getRelative(this.forwardDirection, this.iteration + 1).getRelative(this.sideDirectionA);
        if (w.getType() == Blocks.field_150350_a || w.getType() == Blocks.field_150355_j || w.getType() == Blocks.field_150353_l) {
            Protection.trySetBlock(this.user.field_70170_p, this.blockType, w.getX(), w.getY(), w.getY());
            PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, w.getX(), w.getY(), w.getZ(), 50, 0.5);
            w.getLocation().getWorld().func_72921_c(w.getX(), w.getY(), w.getZ(), this.metadata, 2);
            this.hasNaggedUser = true;
        } else if (this.user instanceof EntityPlayer && !this.hasNaggedUser) {
            Messaging.avatarMessage((EntityPlayer)this.user, "Bridge must go through air, water or lava!");
            this.hasNaggedUser = true;
        }
        w = b.getRelative(this.forwardDirection, this.iteration + 1).getRelative(this.sideDirectionB);
        if (w.getType() == Blocks.field_150350_a || w.getType() == Blocks.field_150355_j || w.getType() == Blocks.field_150353_l) {
            Protection.trySetBlock(this.user.field_70170_p, this.blockType, w.getX(), w.getY(), w.getY());
            PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, w.getX(), w.getY(), w.getZ(), 50, 0.5);
            w.getLocation().getWorld().func_72921_c(w.getX(), w.getY(), w.getZ(), this.metadata, 2);
            this.hasNaggedUser = true;
        } else if (this.user instanceof EntityPlayer && !this.hasNaggedUser) {
            Messaging.avatarMessage((EntityPlayer)this.user, "Bridge must go through air, water or lava!");
            this.hasNaggedUser = true;
        }
    }

    @Override
    public String getName() {
        return "Earth Bridge";
    }
}

