/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.water;

import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;

public class WaterIceStream
extends AsynchronousAbility {
    private long interval = 20L;
    private Location origin;
    private Location location;
    private Vector direction;
    private int range;
    private long time = System.currentTimeMillis();
    private int damage;
    private static int cooldown = 3000;

    public static void createTriple(EntityLivingBase user, Location location, Vector direction, int range, int damage) {
        double x = direction.getZ();
        double y = 0.0;
        double z = -direction.getX();
        Vector rightangle = new Vector(x, y, z);
        rightangle.normalize();
        Location side1 = location.clone();
        Location side2 = location.clone();
        side1.add(rightangle);
        side2.subtract(rightangle);
        new WaterIceStream(user, location, direction, 2);
        new WaterIceStream(user, side1, direction, 2);
        new WaterIceStream(user, side2, direction, 2);
    }

    public WaterIceStream(EntityLivingBase user, Location location, Vector direction, int range, int damage) {
        super(user, cooldown);
        this.range = range;
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        this.direction.setY(0);
        this.direction.normalize();
        this.location.add(this.direction);
        this.damage = damage;
    }

    public WaterIceStream(EntityLivingBase user, Location location, Vector direction, int level) {
        super(user, cooldown + level * 3000);
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        this.direction.setY(0);
        this.direction.normalize();
        this.location.add(this.direction);
        if (level == 0) {
            this.damage = 1;
            this.range = 8;
            if (location.distance((Entity)user) > 5.0) {
                this.destroy();
                return;
            }
        }
        if (level == 1) {
            this.damage = 2;
            this.range = 16;
            if (location.distance((Entity)user) > 10.0) {
                this.destroy();
                return;
            }
        }
        if (level == 2) {
            this.damage = 4;
            this.range = 20;
            if (location.distance((Entity)user) > 15.0) {
                this.destroy();
                return;
            }
        }
    }

    @Override
    public void update() {
        if (this.location.distance(this.origin) > (double)this.range) {
            this.destroy();
            return;
        }
        if (System.currentTimeMillis() > this.time + this.interval) {
            if (this.location.getBlock().getType() == Blocks.field_150355_j || this.location.getBlock().getType() == Blocks.field_150358_i || this.location.getBlock().getType() == Blocks.field_150432_aD) {
                this.time = System.currentTimeMillis();
                this.location.getBlock().setType(Blocks.field_150432_aD);
                PacketSender.spawnParticle("Avatar_watersplash", this.location.getWorld(), this.location.getX(), this.location.getY(), this.location.getZ());
                BendingUtils.damageEntities(this.user, this.location, 3.5f, AvatarDamageSource.waterbending, this.damage);
                this.location.add(this.direction);
            } else {
                this.destroy();
                return;
            }
        }
    }

    public void damageEntities(Location loc) {
        for (Object o : loc.getWorld().func_72910_y()) {
            EntityLivingBase e;
            if (!(o instanceof EntityLivingBase) || !(loc.distance((Entity)(e = (EntityLivingBase)o)) < 3.5)) continue;
            e.func_70097_a(DamageSource.field_76369_e, (float)this.damage);
        }
    }

    @Override
    public String getName() {
        return "Ice Stream";
    }
}

