/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.water;

import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.Messaging;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class WaterBlobRaise
extends AsynchronousAbility {
    private Location sourceLocation;
    private Location blobLocation;
    private Location iceLocation;
    private int blobMovementState;
    private int blobMaterialState;
    private Vector velocity;
    private int range;
    private int damage;
    private int level;
    private long lastmovement = 0L;
    private static int BLOB_MVE_IDLE = 0;
    private static int BLOB_MVE_TRAVELLING = 1;
    private static int BLOB_MAT_WATER = 10;
    private static int BLOB_MAT_FROZEN = 11;

    public WaterBlobRaise(EntityLivingBase user, Location l, int level) {
        super(user, 2500L);
        if (!BendingUtils.isWaterBendable(l.getBlock().getType())) {
            if (user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "No nearby water source.");
            }
            this.destroy();
            return;
        }
        if (l.getBlock().getType() != Blocks.field_150355_j) {
            l.getBlock().setType(Blocks.field_150350_a);
        }
        this.level = level;
        this.sourceLocation = l.clone();
        this.blobLocation = l.clone();
        this.blobMovementState = BLOB_MVE_IDLE;
        this.blobMaterialState = BLOB_MAT_WATER;
        this.iceLocation = new Location(this.blobLocation.getWorld(), 0.0, 240.0, 0.0);
    }

    @Override
    public void update() {
        if (this.blobMovementState == BLOB_MVE_IDLE) {
            if (!this.user.func_70093_af()) {
                if (this.blobMaterialState == BLOB_MAT_FROZEN) {
                    this.iceLocation.getBlock().setType(Blocks.field_150350_a);
                }
                this.destroy();
                return;
            }
            Location l = new Location(this.user.field_70170_p, this.user.field_70165_t, this.user.field_70163_u + 1.62, this.user.field_70161_v);
            Vector v = new Vector(this.user.func_70040_Z().field_72450_a, this.user.func_70040_Z().field_72448_b, this.user.func_70040_Z().field_72449_c);
            v.normalize();
            v.multiply(3);
            l.add(v);
            this.blobLocation = l.clone();
        }
        if (this.blobMovementState == BLOB_MVE_TRAVELLING) {
            long delta = this.lastmovement == 0L ? 10L : System.currentTimeMillis() - this.lastmovement;
            this.lastmovement = System.currentTimeMillis();
            this.blobLocation.add(this.velocity.clone().multiply(delta));
            if (this.blobLocation.distance(this.sourceLocation) > (double)this.range) {
                if (this.blobMaterialState == BLOB_MAT_FROZEN) {
                    this.iceLocation.getBlock().setType(Blocks.field_150350_a);
                }
                this.destroy();
            }
            BendingUtils.damageEntities(this.user, this.blobLocation, 2.0f, AvatarDamageSource.waterbending, this.damage);
        }
        if (!(this.blobMaterialState != BLOB_MAT_FROZEN || this.blobLocation.getBlockX() == this.iceLocation.getBlockX() && this.blobLocation.getBlockY() == this.iceLocation.getBlockY() && this.blobLocation.getBlockZ() == this.iceLocation.getBlockZ() || this.blobLocation.getBlock().getType() != Blocks.field_150350_a && this.blobLocation.getBlock().getType() != Blocks.field_150355_j)) {
            this.iceLocation.getBlock().setType(Blocks.field_150350_a);
            this.blobLocation.getBlock().setType(Blocks.field_150432_aD);
            this.iceLocation = this.blobLocation.clone();
        }
        this.renderZeBlob();
    }

    private void renderZeBlob() {
        if (this.blobMaterialState == BLOB_MAT_WATER) {
            PacketSender.spawnParticle("Avatar_bubblesplash", this.user.field_70170_p, this.blobLocation.getX(), this.blobLocation.getY(), this.blobLocation.getZ());
            PacketSender.spawnParticle("Avatar_watersplashsmall", this.user.field_70170_p, this.blobLocation.getX(), this.blobLocation.getY(), this.blobLocation.getZ());
        }
    }

    public void sendForthZeBlob(Vector vel, int range, int damage) {
        if (this.blobMovementState != BLOB_MVE_IDLE) {
            return;
        }
        this.range = range;
        this.damage = damage;
        this.sourceLocation = this.blobLocation.clone();
        this.velocity = vel;
        this.blobMovementState = BLOB_MVE_TRAVELLING;
    }

    public void freezeZeBlob() {
        this.blobMaterialState = BLOB_MAT_FROZEN;
    }

    public void makeItGoBoom() {
    }

    @Override
    public String getName() {
        return "Manipulate";
    }
}

