/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import java.util.ArrayList;
import java.util.Random;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;

public class EarthWall
extends AsynchronousAbility {
    private ArrayList<BlockBukkit> rootBlocks = new ArrayList();
    private ArrayList<BlockBukkit> toCrumble = new ArrayList();
    private int stage = 0;
    private Long time;
    private Long starttime;
    private Long endtime;
    private int iteration = 0;
    private Random r = new Random();
    private int range = 5;
    private int height = 5;

    public EarthWall(EntityLivingBase user, Long cooldown, int height, int range) {
        super(user, cooldown);
        this.time = System.currentTimeMillis();
        this.starttime = System.currentTimeMillis();
        this.range = range;
        this.height = height;
        this.selectRootBlocks(user);
    }

    @Override
    public void update() {
        if (this.stage == 0) {
            if (System.currentTimeMillis() > this.time + 100L) {
                ++this.iteration;
                if (this.iteration > this.height) {
                    this.stage = 1;
                    this.endtime = System.currentTimeMillis();
                    return;
                }
                this.time = System.currentTimeMillis();
                for (BlockBukkit b : this.rootBlocks) {
                    if (b.getRelative(BlockBukkit.UP, this.iteration).getType() != Blocks.field_150350_a) continue;
                    Block m = b.getRelative(BlockBukkit.UP, this.iteration - 1).getType();
                    Block blockType = null;
                    boolean shouldSetBlock = true;
                    int metadata = 0;
                    if (BendingUtils.isEarthBendable(m)) {
                        blockType = Blocks.field_150348_b;
                    } else {
                        shouldSetBlock = false;
                    }
                    if (m == Blocks.field_150346_d || m == Blocks.field_150349_c) {
                        blockType = Blocks.field_150346_d;
                    }
                    if (m == Blocks.field_150354_m || m == Blocks.field_150322_A) {
                        blockType = Blocks.field_150322_A;
                    }
                    if (m == Blocks.field_150406_ce || m == Blocks.field_150405_ch || m == Blocks.field_150435_aG || m == Blocks.field_150351_n) {
                        blockType = m;
                        Location loc2 = b.getRelative(BlockBukkit.UP, this.iteration - 1).getLocation();
                        metadata = loc2.getWorld().func_72805_g(loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ());
                    }
                    if (!shouldSetBlock) continue;
                    b.getRelative(BlockBukkit.UP, this.iteration).setType(blockType).setMetadata(metadata);
                    this.toCrumble.add(b.getRelative(BlockBukkit.UP, this.iteration));
                }
            }
        } else if (System.currentTimeMillis() - this.endtime > 3000L && System.currentTimeMillis() - this.time > 250L) {
            this.time = System.currentTimeMillis();
            if (this.toCrumble.size() > 0) {
                BlockBukkit b = this.toCrumble.get(this.r.nextInt(this.toCrumble.size()));
                boolean isTop = false;
                while (!isTop) {
                    if (this.toCrumble.contains(b.getRelative(BlockBukkit.UP))) {
                        b = b.getRelative(BlockBukkit.UP);
                        continue;
                    }
                    isTop = true;
                }
                this.toCrumble.remove(b);
                b.setType(Blocks.field_150350_a);
                PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, b.getX(), b.getY(), b.getZ(), 50, 0.5);
            } else {
                this.destroy();
                return;
            }
        }
    }

    private void selectRootBlocks(EntityLivingBase user) {
        Location origin = new Location((Entity)user);
        Location locationforward = origin.clone();
        Location locationbackward = origin.clone();
        Vector temp = origin.getDirection();
        temp.normalize();
        double x = temp.getZ();
        double y = 0.0;
        double z = -temp.getX();
        Vector direction = new Vector(x, y, z);
        while (locationforward.distance(origin) < (double)this.range) {
            locationforward.add(direction);
            this.addRootBlock(locationforward.getBlock());
        }
        while (locationbackward.distance(origin) < (double)this.range) {
            locationbackward.subtract(direction);
            this.addRootBlock(locationbackward.getBlock());
        }
    }

    private void addRootBlock(BlockBukkit b) {
        if (BendingUtils.isEarthBendable(b.getType())) {
            this.rootBlocks.add(b);
        } else if (BendingUtils.isEarthBendable(b.getRelative(BlockBukkit.UP).getType())) {
            this.rootBlocks.add(b.getRelative(BlockBukkit.UP));
        } else if (BendingUtils.isEarthBendable(b.getRelative(BlockBukkit.DOWN).getType())) {
            this.rootBlocks.add(b.getRelative(BlockBukkit.DOWN));
        }
    }

    @Override
    public String getName() {
        return "Earth Wall";
    }
}

