/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import java.util.Random;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.Messaging;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class EarthTunnelColumn
extends AsynchronousAbility {
    private int depth;
    private Location origin;
    private Location current;
    private Vector direction;
    private Long lasttime;
    private boolean hasNagged = false;
    private int chance;
    private Random r;

    public EarthTunnelColumn(EntityLivingBase e, long cooldowntime, Vector direction, int depth, int chance) {
        super(e, cooldowntime);
        this.depth = depth;
        this.origin = new Location((Entity)e);
        this.current = this.origin.clone();
        this.direction = direction.clone().normalize();
        this.lasttime = System.currentTimeMillis();
        this.chance = chance;
        this.r = new Random();
    }

    @Override
    public void update() {
        if (System.currentTimeMillis() > this.lasttime + 100L) {
            this.lasttime = System.currentTimeMillis();
            this.current.add(this.direction);
            if (this.current.distance(this.origin) > (double)this.depth) {
                this.destroy();
                return;
            }
            if (BendingUtils.isEarthBendable(this.current.getBlock().getType()) || this.current.getBlock().getType() == Blocks.field_150350_a) {
                this.hasNagged = true;
                this.dropWithChance(this.current, this.chance);
                this.current.getBlock().setType(Blocks.field_150350_a);
                PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, this.current.getX(), this.current.getY(), this.current.getZ(), 50, 0.5);
                if (BendingUtils.isEarthBendable(this.current.getBlock().getRelative(BlockBukkit.UP).getType())) {
                    this.dropWithChance(this.current.getBlock().getRelative(BlockBukkit.UP).getLocation(), this.chance);
                    this.current.getBlock().getRelative(BlockBukkit.UP).setType(Blocks.field_150350_a);
                }
                if (BendingUtils.isEarthBendable(this.current.getBlock().getRelative(BlockBukkit.DOWN).getType())) {
                    this.dropWithChance(this.current.getBlock().getRelative(BlockBukkit.DOWN).getLocation(), this.chance);
                    this.current.getBlock().getRelative(BlockBukkit.DOWN).setType(Blocks.field_150350_a);
                }
                if (BendingUtils.isEarthBendable(this.current.getBlock().getRelative(BlockBukkit.NORTH).getType())) {
                    this.dropWithChance(this.current.getBlock().getRelative(BlockBukkit.NORTH).getLocation(), this.chance);
                    this.current.getBlock().getRelative(BlockBukkit.NORTH).setType(Blocks.field_150350_a);
                }
                if (BendingUtils.isEarthBendable(this.current.getBlock().getRelative(BlockBukkit.EAST).getType())) {
                    this.dropWithChance(this.current.getBlock().getRelative(BlockBukkit.EAST).getLocation(), this.chance);
                    this.current.getBlock().getRelative(BlockBukkit.EAST).setType(Blocks.field_150350_a);
                }
                if (BendingUtils.isEarthBendable(this.current.getBlock().getRelative(BlockBukkit.SOUTH).getType())) {
                    this.dropWithChance(this.current.getBlock().getRelative(BlockBukkit.SOUTH).getLocation(), this.chance);
                    this.current.getBlock().getRelative(BlockBukkit.SOUTH).setType(Blocks.field_150350_a);
                }
                if (BendingUtils.isEarthBendable(this.current.getBlock().getRelative(BlockBukkit.WEST).getType())) {
                    this.dropWithChance(this.current.getBlock().getRelative(BlockBukkit.WEST).getLocation(), this.chance);
                    this.current.getBlock().getRelative(BlockBukkit.WEST).setType(Blocks.field_150350_a);
                }
            } else {
                if (!this.hasNagged) {
                    Messaging.avatarMessage((EntityPlayer)this.user, "Can only dig Earth bendable blocks!");
                    this.hasNagged = true;
                }
                this.destroy();
                return;
            }
        }
    }

    public final void dropAsItem(Location location) {
        location.getBlock().getType().func_149697_b(this.user.field_70170_p, location.getBlock().getX(), location.getBlock().getY(), location.getBlock().getZ(), 0, 0);
    }

    public void dropWithChance(Location location, int c) {
        if (c == -1) {
            return;
        }
        if (this.r.nextInt(c) == 0) {
            this.dropAsItem(location);
        }
    }

    @Override
    public String getName() {
        return null;
    }
}

