/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.Messaging;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class EarthRaisePlatform
extends AsynchronousAbility {
    private long time;
    private int iteration;
    private Location location;
    private int height;
    private Block platformBlock;
    private int metadata;
    private Block block;
    private int level;

    public EarthRaisePlatform(EntityLivingBase user, int height, int level) {
        super(user, level * level * level * 1000);
        this.user = user;
        this.time = System.currentTimeMillis();
        this.iteration = 0;
        this.location = new Location((Entity)user);
        this.height = height;
        this.level = level;
    }

    @Override
    public void update() {
        if (this.iteration > this.height) {
            this.destroy();
        }
        if (System.currentTimeMillis() - this.time > 100L) {
            ++this.iteration;
            this.time = System.currentTimeMillis();
            this.block = this.location.getBlock().getRelative(BlockBukkit.DOWN).getType();
            if (!BendingUtils.isEarthBendable(this.block)) {
                Messaging.avatarMessage((EntityPlayer)this.user, "Not standing on an Earth bendable block!");
                this.destroy();
                return;
            }
            this.platformBlock = Blocks.field_150348_b;
            if (this.block == Blocks.field_150346_d || this.block == Blocks.field_150349_c) {
                this.platformBlock = Blocks.field_150346_d;
            }
            if (this.block == Blocks.field_150354_m || this.block == Blocks.field_150322_A) {
                this.platformBlock = Blocks.field_150322_A;
            }
            if (this.block == Blocks.field_150406_ce || this.block == Blocks.field_150405_ch || this.block == Blocks.field_150435_aG || this.block == Blocks.field_150351_n) {
                this.platformBlock = this.block;
                Location loc2 = this.location.getBlock().getRelative(BlockBukkit.DOWN).getLocation();
                this.metadata = loc2.getWorld().func_72805_g(loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ());
            }
            PacketSender.sendVelocity((Entity)this.user, new Vector(0.0, 0.5, 0.0));
            this.location.getBlock().setType(this.platformBlock).setMetadata(this.metadata);
            PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, this.location.getX(), this.location.getY(), this.location.getZ(), 50, 0.5);
            if (this.level == 3) {
                PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, this.location.getX(), this.location.getY(), this.location.getZ(), 100, 1.0);
                this.location.getBlock().getRelative(BlockBukkit.NORTH).setType(this.platformBlock).setMetadata(this.metadata);
                this.location.getBlock().getRelative(BlockBukkit.EAST).setType(this.platformBlock).setMetadata(this.metadata);
                this.location.getBlock().getRelative(BlockBukkit.SOUTH).setType(this.platformBlock).setMetadata(this.metadata);
                this.location.getBlock().getRelative(BlockBukkit.WEST).setType(this.platformBlock).setMetadata(this.metadata);
                this.location.getBlock().getRelative(BlockBukkit.NORTH).getRelative(BlockBukkit.EAST).setType(this.platformBlock).setMetadata(this.metadata);
                this.location.getBlock().getRelative(BlockBukkit.SOUTH).getRelative(BlockBukkit.EAST).setType(this.platformBlock).setMetadata(this.metadata);
                this.location.getBlock().getRelative(BlockBukkit.SOUTH).getRelative(BlockBukkit.WEST).setType(this.platformBlock).setMetadata(this.metadata);
                this.location.getBlock().getRelative(BlockBukkit.NORTH).getRelative(BlockBukkit.WEST).setType(this.platformBlock).setMetadata(this.metadata);
            }
            if (this.location.getY() > 254.0) {
                this.destroy();
                return;
            }
            this.location.setY(this.location.getY() + 1.0);
        }
    }

    @Override
    public String getName() {
        return "Platform raise";
    }
}

