/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.air;

import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.EntityActionPerformer;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class AirStream
extends AsynchronousAbility {
    private long interval = 20L;
    private Location origin;
    private Location location;
    private Vector direction;
    private int range;
    private long time = System.currentTimeMillis();
    private int strength;
    private int damage;
    private World worldObj;

    public AirStream(EntityLivingBase user, Long cooldown, Location location, Vector direction, int range, int strength, int damage) {
        super(user, cooldown);
        this.range = range;
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        this.direction.normalize();
        this.location.add(this.direction);
        this.strength = strength;
        this.damage = damage;
        this.worldObj = user.field_70170_p;
    }

    @Override
    public void update() {
        if (this.location.distance(this.origin) > (double)this.range) {
            this.destroy();
            return;
        }
        if (System.currentTimeMillis() > this.time + this.interval) {
            if (this.location.getBlock().getType() == Blocks.field_150350_a || this.location.getBlock().getRelative(BlockBukkit.UP).getType() == Blocks.field_150350_a || BendingUtils.isDroppablePlant(this.location.getBlock().getType())) {
                this.time = System.currentTimeMillis();
                PacketSender.spawnParticle("Avatar_cloud", this.location.getWorld(), this.location.getX(), this.location.getY(), this.location.getZ(), 1, 0.1);
                if (this.damage == 0) {
                    BendingUtils.performCustomAction(this.user, this.location, 1.0f, new EntityActionPerformer(this){

                        @Override
                        public void performAction(Entity e) {
                            if (!e.equals((Object)this.getAbility().user)) {
                                PacketSender.sendVelocity(e, AirStream.this.direction.clone().multiply(AirStream.this.strength));
                            }
                        }
                    });
                } else {
                    BendingUtils.damageAllEntitiesWithCustomAction(this.user, this.location, 1.0f, AvatarDamageSource.airbending, this.damage, new EntityActionPerformer(this){

                        @Override
                        public void performAction(Entity e) {
                            if (!e.equals((Object)this.getAbility().user)) {
                                PacketSender.sendVelocity(e, AirStream.this.direction.clone().multiply(AirStream.this.strength));
                            }
                        }
                    });
                }
                BendingUtils.affectLevers(this.worldObj, this.location.getBlock());
                BendingUtils.affectButtons(this.worldObj, this.location.getBlock());
                BendingUtils.douseFlames(this.worldObj, this.location.getBlock());
                if (this.location.getBlock().getType() == Blocks.field_150353_l) {
                    this.location.getBlock().setType(Blocks.field_150343_Z);
                    this.worldObj.func_72908_a(this.location.getX() + 0.5, this.location.getY() + 0.5, this.location.getZ() + 0.5, "random.fizz", 1.0f, this.worldObj.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                if (this.location.getBlock().getType() == Blocks.field_150353_l) {
                    this.location.getBlock().setType(Blocks.field_150347_e);
                    this.worldObj.func_72908_a(this.location.getX() + 0.5, this.location.getY() + 0.5, this.location.getZ() + 0.5, "random.fizz", 1.0f, this.worldObj.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                if (BendingUtils.isPlant(this.location.getBlock().getType())) {
                    if (BendingUtils.isDroppablePlant(this.location.getBlock().getType())) {
                        this.location.getBlock().getType().func_149697_b(this.worldObj, (int)this.location.getX(), (int)this.location.getY(), (int)this.location.getZ(), 1, 0);
                    }
                    if (this.location.getBlock().getType() == Blocks.field_150329_H) {
                        this.location.getBlock().getType().func_149697_b(this.worldObj, (int)this.location.getX(), (int)this.location.getY(), (int)this.location.getZ(), 1, 0);
                    }
                    if (this.location.getBlock().getType() == Blocks.field_150434_aF) {
                        this.worldObj.func_72908_a(this.location.getX() + 0.5, this.location.getY() + 0.5, this.location.getZ() + 0.5, "dig.cloth", 1.0f, this.worldObj.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    } else {
                        this.worldObj.func_72908_a(this.location.getX() + 0.5, this.location.getY() + 0.5, this.location.getZ() + 0.5, "dig.grass", 1.0f, this.worldObj.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    }
                    this.location.getBlock().setType(Blocks.field_150350_a);
                }
                this.location.add(this.direction);
            } else {
                this.destroy();
            }
        }
    }

    @Override
    public String getName() {
        return "Air Stream";
    }
}

