/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import kieranvs.avatar.bending.AbilityTCFix;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.util.StringColour;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public abstract class Ability {
    private boolean destroyed = false;
    public EntityLivingBase user;
    public static Vector<Ability> Instances = new Vector();
    private static Vector<Ability> Queued = new Vector();
    public static Vector<AbilityTCFix> clientInstances = new Vector();
    private static boolean disableCooldown = false;
    private static HashMap<EntityLivingBase, HashMap<Class<? extends AsynchronousAbility>, Long>> cooldowns = new HashMap();

    public Ability(EntityLivingBase user) {
        this.user = user;
        Queued.add(this);
    }

    public void destroy() {
        this.destroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTempClientFix() {
        for (AbilityTCFix a : clientInstances) {
            a.updateClientSide();
        }
        Vector<AbilityTCFix> vector = clientInstances;
        synchronized (vector) {
            Iterator<AbilityTCFix> i = clientInstances.iterator();
            while (i.hasNext()) {
                AbilityTCFix a = i.next();
                if (!((Ability)((Object)a)).destroyed) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAll() {
        Vector<Ability> vector = Instances;
        synchronized (vector) {
            Iterator<Ability> i = Instances.iterator();
            while (i.hasNext()) {
                Ability a = i.next();
                a.update();
                if (!a.destroyed) continue;
                i.remove();
            }
        }
        if (Instances.size() > 4000) {
            for (int i = 0; i < 200; ++i) {
                Instances.get(i).destroy();
            }
        }
        if (!Queued.isEmpty()) {
            for (int i = 0; i < Queued.size(); ++i) {
                Instances.add(Queued.get(i));
            }
            Queued.clear();
        }
    }

    public static boolean canStart(EntityLivingBase entity, Class<? extends Ability> type) {
        if (disableCooldown) {
            return true;
        }
        if (AsynchronousAbility.class.isAssignableFrom(type)) {
            if (Ability.isInUse(entity, type)) {
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StringColour.GRAY + StringColour.ITALIC + "You are still using this move!"));
                }
                return false;
            }
            long timetill = Ability.getTimeTillNextUse(entity, type);
            if (timetill <= 0L) {
                return true;
            }
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StringColour.GRAY + StringColour.ITALIC + "Wait " + (int)(timetill / 1000L + 1L) + " seconds to reuse this move!"));
            }
            return false;
        }
        return true;
    }

    private static long getTimeTillNextUse(EntityLivingBase entity, Class<? extends AsynchronousAbility> type) {
        if (cooldowns.containsKey(entity)) {
            if (cooldowns.get(entity).containsKey(type)) {
                long nexttime = cooldowns.get(entity).get(type);
                return nexttime - System.currentTimeMillis();
            }
            return -1L;
        }
        return -1L;
    }

    public static boolean isInUse(EntityLivingBase entity, Class<? extends AsynchronousAbility> type) {
        for (Ability a : Instances) {
            if (!type.isInstance(a) || !a.user.equals((Object)entity)) continue;
            return true;
        }
        return false;
    }

    public static void registerNextUseTime(EntityLivingBase entity, Class<? extends AsynchronousAbility> type, Long time) {
        if (cooldowns.containsKey(entity)) {
            cooldowns.get(entity).put(type, time);
        } else {
            cooldowns.put(entity, new HashMap());
            cooldowns.get(entity).put(type, time);
        }
    }

    public abstract void update();

    public abstract String getName();
}

