/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.util;

import java.util.Arrays;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.generation.TeleporterSpiritWorld;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.EntityActionPerformer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class BendingUtils {
    private static Block[] moveable = new Block[]{Blocks.field_150336_V, Blocks.field_150435_aG, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150341_Y, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150458_ak, Blocks.field_150348_b, Blocks.field_150402_ci, Blocks.field_150366_p, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150405_ch, Blocks.field_150369_x, Blocks.field_150371_ca, Blocks.field_150449_bY, Blocks.field_150450_ax, Blocks.field_150417_aV, Blocks.field_150406_ce};
    private static Block[] overwriteable = new Block[]{Blocks.field_150350_a, Blocks.field_150420_aW, Blocks.field_150434_aF, Blocks.field_150414_aQ, Blocks.field_150459_bM, Blocks.field_150375_by, Blocks.field_150457_bL, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150394_bc, Blocks.field_150469_bN, Blocks.field_150423_aK, Blocks.field_150393_bb, Blocks.field_150436_aH, Blocks.field_150429_aA, Blocks.field_150488_af, Blocks.field_150419_aX, Blocks.field_150345_g, Blocks.field_150431_aC, Blocks.field_150472_an, Blocks.field_150478_aa, Blocks.field_150473_bD, Blocks.field_150329_H, Blocks.field_150479_bC, Blocks.field_150437_az, Blocks.field_150395_bd, Blocks.field_150444_as, Blocks.field_150392_bi, Blocks.field_150321_G, Blocks.field_150464_aj, Blocks.field_150471_bO, Blocks.field_150327_N};

    public static void sendToDimension(EntityPlayerMP e, int dimension) {
        if (e.field_71088_bW > 0) {
            e.field_71088_bW = 10;
        } else if (e.field_71093_bK != dimension) {
            e.field_71088_bW = 10;
            MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(e, dimension, (Teleporter)new TeleporterSpiritWorld(MinecraftServer.func_71276_C().func_71218_a(dimension)));
        }
    }

    @Deprecated
    public static void damageEntities(Location location, float range, AvatarDamageSource source, int damage) {
        BendingUtils.damageEntities(null, location, range, source, damage);
    }

    public static void damageEntities(EntityLivingBase damager, Location location, float range, AvatarDamageSource source, int damage) {
        Object[] o = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < o.length; ++i) {
            EntityLivingBase e;
            if (!(o[i] instanceof EntityLivingBase) || o[i] == damager || !(location.distance((Entity)(e = (EntityLivingBase)o[i])) < (double)range)) continue;
            e.func_70097_a((DamageSource)source, (float)damage);
        }
    }

    public static void damageEntitiesWithCustomAction(Location location, float range, AvatarDamageSource source, int damage, EntityActionPerformer action) {
        BendingUtils.damageEntitiesWithCustomAction(null, location, range, source, damage, action);
    }

    public static void damageEntitiesWithCustomAction(EntityLivingBase damager, Location location, float range, AvatarDamageSource source, int damage, EntityActionPerformer action) {
        Object[] o = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < o.length; ++i) {
            EntityLivingBase e;
            if (!(o[i] instanceof EntityLivingBase) || o[i] == damager || !(location.distance((Entity)(e = (EntityLivingBase)o[i])) < (double)range)) continue;
            e.func_70097_a((DamageSource)source, (float)damage);
            action.performAction((Entity)e);
        }
        location.setY(location.getY() - 1.0);
        Object[] oDown = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < oDown.length; ++i) {
            EntityLivingBase e;
            if (!(oDown[i] instanceof EntityLivingBase) || oDown[i] == damager || !(location.distance((Entity)(e = (EntityLivingBase)oDown[i])) < (double)range)) continue;
            e.func_70097_a((DamageSource)source, (float)damage);
            action.performAction((Entity)e);
        }
        location.setY(location.getY() + 1.0);
    }

    public static void performCustomAction(EntityLivingBase damager, Location location, float range, EntityActionPerformer action) {
        Object[] o = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < o.length; ++i) {
            EntityLivingBase e;
            if (!(o[i] instanceof EntityLivingBase) || o[i] == damager || !(location.distance((Entity)(e = (EntityLivingBase)o[i])) < (double)range)) continue;
            action.performAction((Entity)e);
        }
        location.setY(location.getY() - 1.0);
        Object[] oDown = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < oDown.length; ++i) {
            EntityLivingBase e;
            if (!(oDown[i] instanceof EntityLivingBase) || oDown[i] == damager || !(location.distance((Entity)(e = (EntityLivingBase)oDown[i])) < (double)range)) continue;
            action.performAction((Entity)e);
        }
        location.setY(location.getY() + 1.0);
    }

    public static void repelEntitiesInSphere(EntityLivingBase damager, Location location, float range) {
        Object[] o = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < o.length; ++i) {
            if (!(o[i] instanceof Entity) || o[i] == damager) continue;
            Entity e = (Entity)o[i];
            Location eLoc = new Location(e);
            if (!(location.distance(e) < (double)range)) continue;
            double angle = 50.0;
            angle = Math.toRadians(angle);
            double x = eLoc.getX() - location.getX();
            double z = eLoc.getZ() - location.getZ();
            double mag = Math.sqrt(x * x + z * z);
            double vx = (x * Math.cos(angle) - z * Math.sin(angle)) / mag;
            double vz = (x * Math.sin(angle) + z * Math.cos(angle)) / mag;
            Vector velocity = eLoc.getDirection();
            velocity.setX(vx);
            velocity.setZ(vz);
            e.func_70024_g(velocity.getX(), velocity.getY(), velocity.getZ());
            e.field_70143_R = 0.0f;
        }
    }

    public static void repelEntitiesOnYourLevelAndAbove(EntityLivingBase damager, Location location, float range) {
        Object[] o = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < o.length; ++i) {
            if (!(o[i] instanceof Entity) || o[i] == damager) continue;
            Entity e = (Entity)o[i];
            Location eLoc = new Location(e);
            if (!(location.distance(e) < (double)range)) continue;
            Location location2 = new Location((Entity)damager);
            if (!(location.getY() >= location2.getY())) continue;
            double angle = 50.0;
            angle = Math.toRadians(angle);
            double x = eLoc.getX() - location.getX();
            double z = eLoc.getZ() - location.getZ();
            double mag = Math.sqrt(x * x + z * z);
            double vx = (x * Math.cos(angle) - z * Math.sin(angle)) / mag;
            double vz = (x * Math.sin(angle) + z * Math.cos(angle)) / mag;
            Vector velocity = eLoc.getDirection();
            velocity.setX(vx);
            velocity.setZ(vz);
            e.func_70024_g(velocity.getX(), velocity.getY(), velocity.getZ());
            e.field_70143_R = 0.0f;
        }
    }

    public static void damageAllEntitiesWithCustomAction(EntityLivingBase damager, Location location, float range, AvatarDamageSource source, int damage, EntityActionPerformer action) {
        Object[] o = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < o.length; ++i) {
            Entity e;
            if (!(o[i] instanceof Entity) || o[i] == damager || !(location.distance(e = (Entity)o[i]) < (double)range)) continue;
            action.performAction(e);
            if (!(o[i] instanceof EntityLivingBase)) continue;
            e.func_70097_a((DamageSource)source, (float)damage);
        }
        location.setY(location.getY() - 1.0);
        Object[] oDown = location.getWorld().field_72996_f.toArray();
        for (int i = 0; i < oDown.length; ++i) {
            Entity e;
            if (!(oDown[i] instanceof Entity) || oDown[i] == damager || !(location.distance(e = (Entity)oDown[i]) < (double)range)) continue;
            action.performAction(e);
            if (!(o[i] instanceof EntityLivingBase)) continue;
            e.func_70097_a((DamageSource)source, (float)damage);
        }
        location.setY(location.getY() + 1.0);
    }

    public static boolean isPlant(Block block) {
        Block[] plants = new Block[]{Blocks.field_150345_g, Blocks.field_150329_H, Blocks.field_150330_I, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150434_aF, Blocks.field_150436_aH, Blocks.field_150392_bi, Blocks.field_150395_bd, Blocks.field_150394_bc, Blocks.field_150393_bb, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150464_aj, Blocks.field_150375_by, Blocks.field_150459_bM, Blocks.field_150469_bN, Blocks.field_150398_cm};
        return Arrays.asList(plants).contains(block);
    }

    public static boolean isDroppablePlant(Block block) {
        Block[] plants = new Block[]{Blocks.field_150345_g, Blocks.field_150329_H, Blocks.field_150330_I, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150434_aF, Blocks.field_150436_aH, Blocks.field_150392_bi, Blocks.field_150395_bd, Blocks.field_150394_bc, Blocks.field_150393_bb, Blocks.field_150464_aj, Blocks.field_150375_by, Blocks.field_150459_bM, Blocks.field_150469_bN, Blocks.field_150398_cm};
        return Arrays.asList(plants).contains(block);
    }

    public static boolean isWaterBendable(Block block) {
        Block[] plants = new Block[31];
        plants[0] = Blocks.field_150345_g;
        plants[1] = Blocks.field_150329_H;
        plants[2] = Blocks.field_150431_aC;
        plants[3] = Blocks.field_150327_N;
        plants[4] = Blocks.field_150328_O;
        plants[5] = Blocks.field_150338_P;
        plants[6] = Blocks.field_150337_Q;
        plants[7] = Blocks.field_150434_aF;
        plants[8] = Blocks.field_150436_aH;
        plants[9] = Blocks.field_150392_bi;
        plants[10] = Blocks.field_150395_bd;
        plants[11] = Blocks.field_150394_bc;
        plants[12] = Blocks.field_150393_bb;
        plants[13] = Blocks.field_150362_t;
        plants[14] = Blocks.field_150361_u;
        plants[15] = Blocks.field_150464_aj;
        plants[16] = Blocks.field_150423_aK;
        plants[17] = Blocks.field_150440_ba;
        plants[18] = Blocks.field_150420_aW;
        plants[19] = Blocks.field_150419_aX;
        plants[20] = Blocks.field_150375_by;
        plants[21] = Blocks.field_150459_bM;
        plants[22] = Blocks.field_150469_bN;
        plants[23] = Blocks.field_150407_cf;
        plants[24] = Blocks.field_150398_cm;
        plants[25] = Blocks.field_150355_j;
        plants[26] = Blocks.field_150432_aD;
        plants[27] = Blocks.field_150403_cj;
        plants[28] = Blocks.field_150433_aE;
        return Arrays.asList(plants).contains(block);
    }

    public static void affectLevers(World worldObj, BlockBukkit block) {
        if (block.getType() == Blocks.field_150442_at) {
            int i1 = worldObj.func_72805_g(block.getX(), block.getY(), block.getZ());
            int j1 = i1 & 7;
            int k1 = 8 - (i1 & 8);
            worldObj.func_72921_c(block.getX(), block.getY(), block.getZ(), j1 + k1, 3);
            worldObj.func_72908_a((double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5, "random.click", 0.3f, k1 > 0 ? 0.6f : 0.5f);
            worldObj.func_147459_d(block.getX(), block.getY(), block.getZ(), Blocks.field_150442_at);
            if (j1 == 1) {
                worldObj.func_147459_d(block.getX() - 1, block.getY(), block.getZ(), Blocks.field_150442_at);
            } else if (j1 == 2) {
                worldObj.func_147459_d(block.getX() + 1, block.getY(), block.getZ(), Blocks.field_150442_at);
            } else if (j1 == 3) {
                worldObj.func_147459_d(block.getX(), block.getY(), block.getZ() - 1, Blocks.field_150442_at);
            } else if (j1 == 4) {
                worldObj.func_147459_d(block.getX(), block.getY(), block.getZ() + 1, Blocks.field_150442_at);
            } else if (j1 != 5 && j1 != 6) {
                if (j1 == 0 || j1 == 7) {
                    worldObj.func_147459_d(block.getX(), block.getY() + 1, block.getZ(), Blocks.field_150442_at);
                }
            } else {
                worldObj.func_147459_d(block.getX(), block.getY() - 1, block.getZ(), Blocks.field_150442_at);
            }
        }
    }

    public static void affectButtons(World worldObj, BlockBukkit block) {
        if (block.getType() == Blocks.field_150471_bO || block.getType() == Blocks.field_150430_aB) {
            Block buttonId;
            boolean woodenButton = false;
            if (block.getType() == Blocks.field_150471_bO) {
                woodenButton = true;
                buttonId = Blocks.field_150471_bO;
            } else {
                buttonId = Blocks.field_150430_aB;
            }
            int i1 = worldObj.func_72805_g(block.getX(), block.getY(), block.getZ());
            int j1 = i1 & 7;
            int k1 = 8 - (i1 & 8);
            if (k1 != 0) {
                worldObj.func_72921_c(block.getX(), block.getY(), block.getZ(), j1 + k1, 3);
                worldObj.func_147458_c(block.getX(), block.getY(), block.getZ(), block.getX(), block.getY(), block.getZ());
                worldObj.func_72908_a((double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5, "random.click", 0.3f, 0.6f);
                worldObj.func_147459_d(block.getX(), block.getY(), block.getZ(), buttonId);
                if (j1 == 1) {
                    worldObj.func_147459_d(block.getX() - 1, block.getY(), block.getZ(), buttonId);
                } else if (j1 == 2) {
                    worldObj.func_147459_d(block.getX() + 1, block.getY(), block.getZ(), buttonId);
                } else if (j1 == 3) {
                    worldObj.func_147459_d(block.getX(), block.getY(), block.getZ() - 1, buttonId);
                } else if (j1 == 4) {
                    worldObj.func_147459_d(block.getX(), block.getY(), block.getZ() + 1, buttonId);
                } else {
                    worldObj.func_147459_d(block.getX(), block.getY() - 1, block.getZ(), buttonId);
                }
                worldObj.func_147464_a(block.getX(), block.getY(), block.getZ(), block.getType(), 10);
            }
        }
    }

    public static void douseFlames(World worldObj, BlockBukkit block) {
        if (block.getType() == Blocks.field_150480_ab) {
            block.setType(Blocks.field_150350_a);
            worldObj.func_72908_a((double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5, "random.fizz", 1.0f, worldObj.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public static boolean isEarthBendable(Block block) {
        return Arrays.asList(moveable).contains(block);
    }

    public static boolean isOverwriteable(Block block) {
        return Arrays.asList(overwriteable).contains(block);
    }
}

