/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.generation;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import kieranvs.avatar.bending.ElementManager;
import kieranvs.avatar.entity.EntityFireMan;
import kieranvs.avatar.mod_Avatar;
import kieranvs.avatar.util.GenerationUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenFireNationTower
implements IWorldGenerator {
    private static BiomeGenBase[] biomes = new BiomeGenBase[]{BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_150588_X, BiomeGenBase.field_150587_Y};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int[] result = GenerationUtils.shouldSpawnHere(random, chunkX, chunkZ, world, 10, 2, 40, biomes);
        if (result[0] == 0) {
            this.generate(world, result[1], result[2], result[3]);
            this.generateEntities(world, result[1], result[2] - 5, result[3], random);
            this.generateLoot(world, result[1], result[2], result[3], random);
        }
    }

    public void generateEntities(World world, int i, int j, int k, Random random) {
        int numM = random.nextInt(2) + 1;
        for (int x = 0; x < numM; ++x) {
            EntityFireMan fireMan = new EntityFireMan(world, i + 5, j + 5, k + 5, 5);
            fireMan.func_70080_a(i + 5, j + 5, k + 5, 1.0f, 1.0f);
            world.func_72838_d((Entity)fireMan);
        }
    }

    public void generateLoot(World world, int i, int j, int k, Random random) {
        for (int x = i; x < i + 10; ++x) {
            for (int z = k; z < k + 10; ++z) {
                for (int y = j; y < j + 23; ++y) {
                    TileEntity e = world.func_147438_o(x, y, z);
                    if (e == null || !(e instanceof TileEntityChest)) continue;
                    GenerationUtils.generateScrolls(random, (TileEntityChest)e, ElementManager.FIRE, 3);
                    GenerationUtils.generateRandomMoney(random, (TileEntityChest)e, ElementManager.FIRE, 2);
                }
            }
        }
    }

    public boolean generate(World world, int i, int j, int k) {
        world.func_147465_d(i + 5, j + 5, k + 2, (Block)Blocks.field_150486_ae, 1, 2);
        world.func_147465_d(i + 2, j + 5, k + 5, (Block)Blocks.field_150486_ae, 1, 2);
        world.func_147465_d(i + 5, j + 5, k + 8, (Block)Blocks.field_150486_ae, 1, 2);
        world.func_147465_d(i + 8, j + 5, k + 5, (Block)Blocks.field_150486_ae, 1, 2);
        world.func_147465_d(i + 0, j + 0, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 0, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 0, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 1, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 0, j + 1, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 0, j + 2, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 2, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 3, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 3, k + 4, Blocks.field_150372_bz, 7, 2);
        world.func_147465_d(i + 0, j + 3, k + 6, Blocks.field_150372_bz, 6, 2);
        world.func_147465_d(i + 0, j + 3, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 4, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 4, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 0, j + 4, k + 5, Blocks.field_150385_bj);
        world.func_147465_d(i + 0, j + 4, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 0, j + 4, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 0, k + 3, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 1, j + 0, k + 4, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 1, j + 0, k + 5, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 1, j + 0, k + 6, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 1, j + 0, k + 7, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 1, j + 1, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 1, j + 1, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 1, j + 2, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 2, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 3, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 3, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 4, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 1, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 1, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 1, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 1, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 1, j + 4, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 5, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 1, j + 5, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 5, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 5, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 5, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 1, j + 6, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 1, j + 6, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 6, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 6, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 1, j + 7, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 1, j + 7, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 7, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 1, j + 7, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 1, j + 8, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 1, j + 8, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 1, j + 8, k + 5, Blocks.field_150385_bj);
        world.func_147449_b(i + 1, j + 8, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 1, j + 8, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 2, j + 0, k + 2, Blocks.field_150426_aN);
        world.func_147465_d(i + 2, j + 0, k + 3, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 2, j + 0, k + 4, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 2, j + 0, k + 5, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 2, j + 0, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 0, k + 7, Blocks.field_150325_L, 14, 2);
        world.func_147449_b(i + 2, j + 0, k + 8, Blocks.field_150426_aN);
        world.func_147465_d(i + 2, j + 1, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 2, j + 1, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 2, j + 2, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 2, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 3, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 3, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 4, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 4, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 8, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 2, j + 8, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 8, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 8, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 8, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 8, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 2, j + 8, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 2, j + 9, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 9, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 2, j + 9, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 9, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 2, j + 9, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 10, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 10, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 2, j + 10, k + 5, Blocks.field_150422_aJ);
        world.func_147465_d(i + 2, j + 10, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 2, j + 10, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 11, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 11, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 2, j + 11, k + 5, Blocks.field_150422_aJ);
        world.func_147465_d(i + 2, j + 11, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 2, j + 11, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 2, j + 12, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 2, j + 12, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 2, j + 12, k + 5, Blocks.field_150385_bj);
        world.func_147449_b(i + 2, j + 12, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 2, j + 12, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 0, k + 1, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 3, j + 0, k + 2, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 3, j + 0, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 0, k + 4, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 3, j + 0, k + 5, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 3, j + 0, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 0, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 0, k + 8, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 3, j + 0, k + 9, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 3, j + 1, k + 0, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 1, k + 10, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 2, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 2, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 3, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 3, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 4, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 4, k + 1, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 9, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 4, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 5, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 5, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 6, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 6, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 7, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 7, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 8, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 8, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 3, j + 8, k + 3, Blocks.field_150426_aN);
        world.func_147465_d(i + 3, j + 8, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 8, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 8, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 3, j + 8, k + 7, Blocks.field_150426_aN);
        world.func_147465_d(i + 3, j + 8, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 8, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 9, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 9, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 10, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 10, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 11, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 11, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 12, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 12, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 12, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 12, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 12, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 12, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 3, j + 12, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 3, j + 13, k + 3, (Block)Blocks.field_150333_U, 1, 2);
        world.func_147465_d(i + 3, j + 13, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 13, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 13, k + 7, (Block)Blocks.field_150333_U, 1, 2);
        world.func_147465_d(i + 3, j + 14, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 14, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 3, j + 15, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 3, j + 15, k + 5, (Block)mod_Avatar.FireNationBlock);
        world.func_147465_d(i + 3, j + 15, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 3, j + 16, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 3, j + 16, k + 5, Blocks.field_150385_bj);
        world.func_147449_b(i + 3, j + 16, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 3, j + 20, k + 3, Blocks.field_150372_bz, 6, 2);
        world.func_147465_d(i + 3, j + 20, k + 4, Blocks.field_150372_bz, 4, 2);
        world.func_147465_d(i + 3, j + 20, k + 6, Blocks.field_150372_bz, 4, 2);
        world.func_147465_d(i + 3, j + 20, k + 7, Blocks.field_150372_bz, 4, 2);
        world.func_147465_d(i + 3, j + 21, k + 3, Blocks.field_150387_bl, 2, 2);
        world.func_147449_b(i + 3, j + 21, k + 4, Blocks.field_150387_bl);
        world.func_147449_b(i + 3, j + 21, k + 5, Blocks.field_150387_bl);
        world.func_147449_b(i + 3, j + 21, k + 6, Blocks.field_150387_bl);
        world.func_147449_b(i + 3, j + 21, k + 7, Blocks.field_150387_bl);
        world.func_147465_d(i + 4, j + 0, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 0, k + 1, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 4, j + 0, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 0, k + 3, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 4, j + 0, k + 4, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 4, j + 0, k + 5, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 4, j + 0, k + 6, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 4, j + 0, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 0, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 0, k + 9, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 4, j + 0, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 3, k + 0, Blocks.field_150372_bz, 5, 2);
        world.func_147465_d(i + 4, j + 3, k + 10, Blocks.field_150372_bz, 5, 2);
        world.func_147465_d(i + 4, j + 4, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 4, k + 1, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 9, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 4, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 5, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 5, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 6, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 6, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 7, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 4, j + 7, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 4, j + 8, k + 1, Blocks.field_150385_bj);
        world.func_147465_d(i + 4, j + 8, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 8, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 8, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 8, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 8, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 8, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 4, j + 8, k + 9, Blocks.field_150385_bj);
        world.func_147465_d(i + 4, j + 9, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 9, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 10, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 10, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 11, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 11, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 4, j + 12, k + 2, Blocks.field_150385_bj);
        world.func_147465_d(i + 4, j + 12, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 12, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 12, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 12, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 4, j + 12, k + 8, Blocks.field_150385_bj);
        world.func_147465_d(i + 4, j + 13, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 13, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 14, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 14, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 15, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 15, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 4, j + 16, k + 3, Blocks.field_150385_bj);
        world.func_147465_d(i + 4, j + 16, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 4, j + 16, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 4, j + 16, k + 7, Blocks.field_150385_bj);
        world.func_147465_d(i + 4, j + 17, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 17, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 18, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 18, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 19, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 19, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 4, j + 20, k + 3, Blocks.field_150372_bz, 6, 2);
        world.func_147449_b(i + 4, j + 20, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 4, j + 20, k + 5, Blocks.field_150385_bj);
        world.func_147449_b(i + 4, j + 20, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 4, j + 20, k + 7, Blocks.field_150372_bz, 7, 2);
        world.func_147465_d(i + 4, j + 21, k + 3, Blocks.field_150387_bl, 2, 2);
        world.func_147465_d(i + 4, j + 21, k + 7, Blocks.field_150387_bl, 3, 2);
        world.func_147449_b(i + 4, j + 22, k + 4, Blocks.field_150372_bz);
        world.func_147449_b(i + 4, j + 22, k + 5, Blocks.field_150372_bz);
        world.func_147465_d(i + 4, j + 22, k + 6, Blocks.field_150372_bz, 3, 2);
        world.func_147465_d(i + 5, j + 0, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 5, j + 0, k + 1, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 5, j + 0, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 5, j + 0, k + 3, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 5, j + 0, k + 4, Blocks.field_150325_L, 14, 2);
        world.func_147449_b(i + 5, j + 0, k + 5, (Block)mod_Avatar.FireBlock);
        world.func_147465_d(i + 5, j + 0, k + 6, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 5, j + 0, k + 7, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 5, j + 0, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 5, j + 0, k + 9, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 5, j + 0, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 5, j + 4, k + 0, Blocks.field_150385_bj);
        world.func_147465_d(i + 5, j + 4, k + 1, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 4, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 4, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 4, k + 9, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 4, k + 10, Blocks.field_150385_bj);
        world.func_147465_d(i + 5, j + 5, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 5, j + 5, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 5, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 5, j + 6, k + 1, Blocks.field_150422_aJ);
        world.func_147465_d(i + 5, j + 6, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 6, k + 9, Blocks.field_150422_aJ);
        world.func_147449_b(i + 5, j + 7, k + 1, Blocks.field_150422_aJ);
        world.func_147465_d(i + 5, j + 7, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 7, k + 9, Blocks.field_150422_aJ);
        world.func_147449_b(i + 5, j + 8, k + 1, Blocks.field_150385_bj);
        world.func_147465_d(i + 5, j + 8, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 8, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 8, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 8, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 8, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 8, k + 9, Blocks.field_150385_bj);
        world.func_147465_d(i + 5, j + 9, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 5, j + 9, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 9, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 5, j + 10, k + 2, Blocks.field_150422_aJ);
        world.func_147465_d(i + 5, j + 10, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 10, k + 8, Blocks.field_150422_aJ);
        world.func_147449_b(i + 5, j + 11, k + 2, Blocks.field_150422_aJ);
        world.func_147465_d(i + 5, j + 11, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 11, k + 8, Blocks.field_150422_aJ);
        world.func_147449_b(i + 5, j + 12, k + 2, Blocks.field_150385_bj);
        world.func_147465_d(i + 5, j + 12, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 12, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 12, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 12, k + 8, Blocks.field_150385_bj);
        world.func_147465_d(i + 5, j + 13, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 5, j + 14, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 15, k + 3, (Block)mod_Avatar.FireNationBlock);
        world.func_147465_d(i + 5, j + 15, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 15, k + 7, (Block)mod_Avatar.FireNationBlock);
        world.func_147449_b(i + 5, j + 16, k + 3, Blocks.field_150385_bj);
        world.func_147465_d(i + 5, j + 16, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 5, j + 16, k + 7, Blocks.field_150385_bj);
        world.func_147449_b(i + 5, j + 20, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 5, j + 20, k + 5, Blocks.field_150426_aN);
        world.func_147449_b(i + 5, j + 20, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 5, j + 21, k + 3, Blocks.field_150387_bl, 2, 2);
        world.func_147465_d(i + 5, j + 21, k + 7, Blocks.field_150387_bl, 3, 2);
        world.func_147465_d(i + 5, j + 22, k + 4, Blocks.field_150372_bz, 2, 2);
        world.func_147465_d(i + 5, j + 22, k + 6, Blocks.field_150372_bz, 3, 2);
        world.func_147449_b(i + 5, j + 23, k + 5, Blocks.field_150426_aN);
        world.func_147465_d(i + 6, j + 0, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 0, k + 1, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 6, j + 0, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 0, k + 3, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 6, j + 0, k + 4, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 6, j + 0, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 0, k + 6, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 6, j + 0, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 0, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 0, k + 9, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 6, j + 0, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 3, k + 0, Blocks.field_150372_bz, 4, 2);
        world.func_147465_d(i + 6, j + 3, k + 10, Blocks.field_150372_bz, 4, 2);
        world.func_147465_d(i + 6, j + 4, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 4, k + 1, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 9, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 4, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 5, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 5, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 6, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 6, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 7, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 6, j + 7, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 6, j + 8, k + 1, Blocks.field_150385_bj);
        world.func_147465_d(i + 6, j + 8, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 8, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 8, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 8, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 8, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 8, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 6, j + 8, k + 9, Blocks.field_150385_bj);
        world.func_147465_d(i + 6, j + 9, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 9, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 10, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 10, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 11, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 11, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 6, j + 12, k + 2, Blocks.field_150385_bj);
        world.func_147465_d(i + 6, j + 12, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 12, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 12, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 12, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 6, j + 12, k + 8, Blocks.field_150385_bj);
        world.func_147465_d(i + 6, j + 13, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 13, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 14, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 14, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 15, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 15, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 6, j + 16, k + 3, Blocks.field_150385_bj);
        world.func_147465_d(i + 6, j + 16, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 6, j + 16, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 6, j + 16, k + 7, Blocks.field_150385_bj);
        world.func_147465_d(i + 6, j + 17, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 17, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 18, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 18, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 19, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 19, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 6, j + 20, k + 3, Blocks.field_150372_bz, 6, 2);
        world.func_147449_b(i + 6, j + 20, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 6, j + 20, k + 5, Blocks.field_150385_bj);
        world.func_147449_b(i + 6, j + 20, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 6, j + 20, k + 7, Blocks.field_150372_bz, 7, 2);
        world.func_147465_d(i + 6, j + 21, k + 3, Blocks.field_150387_bl, 2, 2);
        world.func_147465_d(i + 6, j + 21, k + 7, Blocks.field_150387_bl, 3, 2);
        world.func_147465_d(i + 6, j + 22, k + 4, Blocks.field_150372_bz, 2, 2);
        world.func_147465_d(i + 6, j + 22, k + 5, Blocks.field_150372_bz, 1, 2);
        world.func_147465_d(i + 6, j + 22, k + 6, Blocks.field_150372_bz, 1, 2);
        world.func_147465_d(i + 7, j + 0, k + 1, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 7, j + 0, k + 2, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 7, j + 0, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 0, k + 4, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 7, j + 0, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 0, k + 6, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 7, j + 0, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 0, k + 8, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 7, j + 0, k + 9, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 7, j + 1, k + 0, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 1, k + 10, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 2, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 2, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 3, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 3, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 4, k + 0, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 4, k + 1, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 9, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 4, k + 10, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 5, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 5, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 6, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 6, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 7, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 7, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 8, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 8, k + 2, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 7, j + 8, k + 3, Blocks.field_150426_aN);
        world.func_147465_d(i + 7, j + 8, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 8, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 8, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147449_b(i + 7, j + 8, k + 7, Blocks.field_150426_aN);
        world.func_147465_d(i + 7, j + 8, k + 8, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 8, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 9, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 9, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 10, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 10, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 11, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 11, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 12, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 12, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 12, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 12, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 12, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 12, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 7, j + 12, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 7, j + 13, k + 3, (Block)Blocks.field_150333_U, 1, 2);
        world.func_147465_d(i + 7, j + 13, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 13, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 13, k + 7, (Block)Blocks.field_150333_U, 1, 2);
        world.func_147465_d(i + 7, j + 14, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 14, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 7, j + 15, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 7, j + 15, k + 5, (Block)mod_Avatar.FireNationBlock);
        world.func_147465_d(i + 7, j + 15, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 7, j + 16, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 7, j + 16, k + 5, Blocks.field_150385_bj);
        world.func_147449_b(i + 7, j + 16, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 7, j + 20, k + 3, Blocks.field_150372_bz, 5, 2);
        world.func_147465_d(i + 7, j + 20, k + 4, Blocks.field_150372_bz, 5, 2);
        world.func_147465_d(i + 7, j + 20, k + 6, Blocks.field_150372_bz, 5, 2);
        world.func_147465_d(i + 7, j + 20, k + 7, Blocks.field_150372_bz, 7, 2);
        world.func_147465_d(i + 7, j + 21, k + 3, Blocks.field_150387_bl, 1, 2);
        world.func_147465_d(i + 7, j + 21, k + 4, Blocks.field_150387_bl, 1, 2);
        world.func_147465_d(i + 7, j + 21, k + 5, Blocks.field_150387_bl, 1, 2);
        world.func_147465_d(i + 7, j + 21, k + 6, Blocks.field_150387_bl, 1, 2);
        world.func_147465_d(i + 7, j + 21, k + 7, Blocks.field_150387_bl, 1, 2);
        world.func_147449_b(i + 8, j + 0, k + 2, Blocks.field_150426_aN);
        world.func_147465_d(i + 8, j + 0, k + 3, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 8, j + 0, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 0, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 0, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 0, k + 7, Blocks.field_150325_L, 14, 2);
        world.func_147449_b(i + 8, j + 0, k + 8, Blocks.field_150426_aN);
        world.func_147465_d(i + 8, j + 1, k + 1, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 8, j + 1, k + 9, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 8, j + 2, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 2, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 3, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 3, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 4, k + 1, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 4, k + 9, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 8, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 8, j + 8, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 8, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 8, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 8, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 8, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 8, j + 8, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 8, j + 9, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 9, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 8, j + 9, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 9, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 8, j + 9, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 10, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 10, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 8, j + 10, k + 5, Blocks.field_150422_aJ);
        world.func_147465_d(i + 8, j + 10, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 8, j + 10, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 11, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 11, k + 4, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 8, j + 11, k + 5, Blocks.field_150422_aJ);
        world.func_147465_d(i + 8, j + 11, k + 6, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 8, j + 11, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 8, j + 12, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 8, j + 12, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 8, j + 12, k + 5, Blocks.field_150385_bj);
        world.func_147449_b(i + 8, j + 12, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 8, j + 12, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 0, k + 3, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 9, j + 0, k + 4, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 9, j + 0, k + 5, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 9, j + 0, k + 6, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 9, j + 0, k + 7, Blocks.field_150325_L, 14, 2);
        world.func_147465_d(i + 9, j + 1, k + 2, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 9, j + 1, k + 8, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 9, j + 2, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 2, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 3, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 3, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 4, k + 2, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 4, k + 3, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 9, j + 4, k + 4, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 9, j + 4, k + 5, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 9, j + 4, k + 6, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 9, j + 4, k + 7, Blocks.field_150344_f, 1, 2);
        world.func_147465_d(i + 9, j + 4, k + 8, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 5, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 9, j + 5, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 5, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 5, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 5, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 9, j + 6, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 9, j + 6, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 9, j + 6, k + 5, Blocks.field_150422_aJ);
        world.func_147465_d(i + 9, j + 6, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 6, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 9, j + 7, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 9, j + 7, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 9, j + 7, k + 5, Blocks.field_150422_aJ);
        world.func_147465_d(i + 9, j + 7, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 9, j + 7, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 9, j + 8, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147449_b(i + 9, j + 8, k + 4, Blocks.field_150385_bj);
        world.func_147449_b(i + 9, j + 8, k + 5, Blocks.field_150385_bj);
        world.func_147449_b(i + 9, j + 8, k + 6, Blocks.field_150385_bj);
        world.func_147465_d(i + 9, j + 8, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 10, j + 0, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 0, k + 5, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 0, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 1, k + 3, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 10, j + 1, k + 7, Blocks.field_150322_A, 1, 2);
        world.func_147465_d(i + 10, j + 2, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 2, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 3, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 3, k + 4, Blocks.field_150372_bz, 7, 2);
        world.func_147465_d(i + 10, j + 3, k + 6, Blocks.field_150372_bz, 6, 2);
        world.func_147465_d(i + 10, j + 3, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 4, k + 3, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 4, k + 4, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 10, j + 4, k + 5, Blocks.field_150385_bj);
        world.func_147465_d(i + 10, j + 4, k + 6, Blocks.field_150322_A, 2, 2);
        world.func_147465_d(i + 10, j + 4, k + 7, Blocks.field_150322_A, 2, 2);
        world.func_147449_b(i + 0, j + 0, k + 0, Blocks.field_150354_m);
        world.func_147449_b(i + 0, j + 0, k + 1, Blocks.field_150354_m);
        world.func_147449_b(i + 0, j + 0, k + 2, Blocks.field_150354_m);
        world.func_147449_b(i + 0, j + 0, k + 3, Blocks.field_150354_m);
        world.func_147449_b(i + 0, j + 0, k + 7, Blocks.field_150354_m);
        world.func_147449_b(i + 0, j + 0, k + 8, Blocks.field_150354_m);
        world.func_147449_b(i + 0, j + 0, k + 9, Blocks.field_150354_m);
        world.func_147449_b(i + 0, j + 0, k + 10, Blocks.field_150354_m);
        world.func_147449_b(i + 1, j + 0, k + 0, Blocks.field_150354_m);
        world.func_147449_b(i + 1, j + 0, k + 1, Blocks.field_150354_m);
        world.func_147449_b(i + 1, j + 0, k + 2, Blocks.field_150354_m);
        world.func_147449_b(i + 1, j + 0, k + 8, Blocks.field_150354_m);
        world.func_147449_b(i + 1, j + 0, k + 9, Blocks.field_150354_m);
        world.func_147449_b(i + 1, j + 0, k + 10, Blocks.field_150354_m);
        world.func_147449_b(i + 2, j + 0, k + 0, Blocks.field_150354_m);
        world.func_147449_b(i + 2, j + 0, k + 1, Blocks.field_150354_m);
        world.func_147449_b(i + 2, j + 0, k + 9, Blocks.field_150354_m);
        world.func_147449_b(i + 2, j + 0, k + 10, Blocks.field_150354_m);
        world.func_147465_d(i + 2, j + 1, k + 2, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 2, j + 1, k + 8, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 2, j + 2, k + 2, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 2, j + 2, k + 8, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 2, j + 3, k + 2, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 2, j + 3, k + 8, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 2, j + 4, k + 2, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 2, j + 4, k + 8, Blocks.field_150468_ap, 2, 2);
        world.func_147449_b(i + 3, j + 0, k + 0, Blocks.field_150354_m);
        world.func_147449_b(i + 3, j + 0, k + 10, Blocks.field_150354_m);
        world.func_147465_d(i + 4, j + 5, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 6, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 7, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 8, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 9, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 10, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 11, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 12, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 13, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 14, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 15, k + 4, Blocks.field_150478_aa, 1, 2);
        world.func_147465_d(i + 4, j + 15, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 4, j + 15, k + 6, Blocks.field_150478_aa, 1, 2);
        world.func_147465_d(i + 4, j + 16, k + 5, Blocks.field_150468_ap, 4, 2);
        world.func_147465_d(i + 5, j + 5, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 5, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 6, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 6, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 7, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 7, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 8, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 8, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 9, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 9, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 10, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 10, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 11, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 11, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 12, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 12, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 13, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 13, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 14, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 14, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 15, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 15, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 5, j + 16, k + 4, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 5, j + 16, k + 6, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 6, j + 5, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 6, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 7, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 8, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 9, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 10, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 11, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 12, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 13, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 14, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 15, k + 4, Blocks.field_150478_aa, 2, 2);
        world.func_147465_d(i + 6, j + 15, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147465_d(i + 6, j + 15, k + 6, Blocks.field_150478_aa, 2, 2);
        world.func_147465_d(i + 6, j + 16, k + 5, Blocks.field_150468_ap, 5, 2);
        world.func_147449_b(i + 7, j + 0, k + 0, Blocks.field_150354_m);
        world.func_147449_b(i + 7, j + 0, k + 10, Blocks.field_150354_m);
        world.func_147449_b(i + 8, j + 0, k + 0, Blocks.field_150354_m);
        world.func_147449_b(i + 8, j + 0, k + 1, Blocks.field_150354_m);
        world.func_147449_b(i + 8, j + 0, k + 9, Blocks.field_150354_m);
        world.func_147449_b(i + 8, j + 0, k + 10, Blocks.field_150354_m);
        world.func_147465_d(i + 8, j + 1, k + 2, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 8, j + 1, k + 8, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 8, j + 2, k + 2, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 8, j + 2, k + 8, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 8, j + 3, k + 2, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 8, j + 3, k + 8, Blocks.field_150468_ap, 2, 2);
        world.func_147465_d(i + 8, j + 4, k + 2, Blocks.field_150468_ap, 3, 2);
        world.func_147465_d(i + 8, j + 4, k + 8, Blocks.field_150468_ap, 2, 2);
        world.func_147449_b(i + 9, j + 0, k + 0, Blocks.field_150354_m);
        world.func_147449_b(i + 9, j + 0, k + 1, Blocks.field_150354_m);
        world.func_147449_b(i + 9, j + 0, k + 2, Blocks.field_150354_m);
        world.func_147449_b(i + 9, j + 0, k + 8, Blocks.field_150354_m);
        world.func_147449_b(i + 9, j + 0, k + 9, Blocks.field_150354_m);
        world.func_147449_b(i + 9, j + 0, k + 10, Blocks.field_150354_m);
        world.func_147449_b(i + 10, j + 0, k + 0, Blocks.field_150354_m);
        world.func_147449_b(i + 10, j + 0, k + 1, Blocks.field_150354_m);
        world.func_147449_b(i + 10, j + 0, k + 2, Blocks.field_150354_m);
        world.func_147449_b(i + 10, j + 0, k + 3, Blocks.field_150354_m);
        world.func_147449_b(i + 10, j + 0, k + 7, Blocks.field_150354_m);
        world.func_147449_b(i + 10, j + 0, k + 8, Blocks.field_150354_m);
        world.func_147449_b(i + 10, j + 0, k + 9, Blocks.field_150354_m);
        world.func_147449_b(i + 10, j + 0, k + 10, Blocks.field_150354_m);
        return true;
    }
}

