/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.entity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Random;
import kieranvs.avatar.entity.EntityChatListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class EntityFamiliar
extends EntityCreature
implements EntityChatListener {
    public String owner = "";
    public int mood = 0;
    private int healthlastsent = -1;
    private int moodlastsent = -1;
    private int moodrandom = 0;
    private long moodrandomtime = 0L;

    public EntityFamiliar(World par1World) {
        super(par1World);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(19, (Object)"");
    }

    public void setOwner(EntityPlayer owner) {
        if (EntityFamiliar.getFamiliarByOwner(owner) == null) {
            this.owner = owner.getDisplayName();
            this.sendNameUpdate();
            this.sendHealthUpdate();
        } else {
            owner.func_146105_b((IChatComponent)new ChatComponentText("You already have a familiar, dumbass..."));
        }
    }

    public void setName(String name) {
        this.field_70180_af.func_75692_b(19, (Object)name);
        this.sendNameUpdate();
    }

    public String getName() {
        return this.field_70180_af.func_75681_e(19);
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (this.owner != null) {
            this.sendDeathUpdate();
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!(this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n != player)) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == this.getTameItem()) {
                --player.func_70694_bm().field_77994_a;
                Random r = this.func_70681_au();
                for (int var3 = 0; var3 < 7; ++var3) {
                    double vx = r.nextGaussian() * 202.0;
                    double vy = r.nextGaussian() * 202.0;
                    double vz = r.nextGaussian() * 202.0;
                    this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(r.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(r.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(r.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, vx, vy, vz);
                }
                this.setOwner(player);
            } else {
                player.func_70078_a((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (System.currentTimeMillis() - this.moodrandomtime > 1000L) {
            this.moodrandomtime = System.currentTimeMillis();
            this.moodrandom = this.field_70146_Z.nextInt(40) - 20;
        }
        this.updateMood();
        if ((int)this.func_110143_aJ() != this.healthlastsent) {
            this.sendHealthUpdate();
        }
        if (this.mood != this.moodlastsent) {
            this.sendMoodUpdate();
        }
    }

    public void updateMood() {
        if ((int)this.func_110143_aJ() < 20) {
            this.mood = 3;
            return;
        }
        int moodval = (int)this.func_110143_aJ();
        if ((moodval += this.moodrandom) < 50) {
            this.mood = 2;
            return;
        }
        if (moodval < 100) {
            this.mood = 0;
            return;
        }
        if (moodval < 2000) {
            this.mood = 1;
            return;
        }
    }

    public boolean func_70692_ba() {
        return false;
    }

    public void sendNameUpdate() {
        EntityPlayer o;
        String name = this.field_70180_af.func_75681_e(19);
        if (this.owner != null && name != null && (o = this.field_70170_p.func_72924_a(this.owner)) != null) {
            PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
            try {
                pb.writeInt(1);
                pb.writeInt(name.getBytes().length);
                pb.writeBytes(name.getBytes());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarFam", (ByteBuf)pb);
            ((EntityPlayerMP)o).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public void sendDeathUpdate() {
        EntityPlayer o;
        if (this.owner != null && (o = this.field_70170_p.func_72924_a(this.owner)) != null) {
            PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
            try {
                pb.writeInt(4);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarFam", (ByteBuf)pb);
            ((EntityPlayerMP)o).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public void sendHealthUpdate() {
        EntityPlayer o;
        if (this.owner != null && (o = this.field_70170_p.func_72924_a(this.owner)) != null) {
            PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
            try {
                pb.writeInt(2);
                pb.writeInt((int)this.func_110143_aJ());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarFam", (ByteBuf)pb);
            ((EntityPlayerMP)o).field_71135_a.func_147359_a((Packet)packet);
            this.healthlastsent = (int)this.func_110143_aJ();
        }
    }

    public void sendMoodUpdate() {
        EntityPlayer o;
        if (this.owner != null && (o = this.field_70170_p.func_72924_a(this.owner)) != null) {
            PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
            try {
                pb.writeInt(3);
                pb.writeInt(this.mood);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarFam", (ByteBuf)pb);
            ((EntityPlayerMP)o).field_71135_a.func_147359_a((Packet)packet);
            this.moodlastsent = this.mood;
        }
    }

    public abstract Item getTameItem();

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74778_a("Name", this.field_70180_af.func_75681_e(19));
        par1NBTTagCompound.func_74778_a("Owner", this.owner);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74779_i("Name") != null) {
            this.field_70180_af.func_75692_b(19, (Object)par1NBTTagCompound.func_74779_i("Name"));
        }
        this.owner = par1NBTTagCompound.func_74779_i("Owner");
    }

    public static EntityFamiliar getFamiliarByOwner(EntityPlayer owner) {
        String ownerStr = owner.getDisplayName();
        for (Object o : owner.field_70170_p.func_72910_y()) {
            if (!(o instanceof EntityFamiliar)) continue;
            EntityFamiliar e = (EntityFamiliar)o;
            if (e.owner != ownerStr) continue;
            return e;
        }
        return null;
    }

    public static String getMoodName(int mood) {
        switch (mood) {
            case 0: {
                return "Neutral";
            }
            case 1: {
                return "Happy";
            }
            case 2: {
                return "Unhappy";
            }
            case 3: {
                return "Scared";
            }
        }
        return "";
    }

    public static int getMoodColor(int mood) {
        switch (mood) {
            case 0: {
                return 65535;
            }
            case 1: {
                return 65280;
            }
            case 2: {
                return 0xFF6600;
            }
            case 3: {
                return 0xFF0000;
            }
        }
        return 0xFFFFFF;
    }
}

