/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.fire;

import java.util.Random;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;

public class FireExplosion
extends AsynchronousAbility {
    private Long starttime;
    private float chargeSpeed;
    private float maxPower;
    private float minPower;
    private static int cooldown = 15000;
    private Random rand;
    private int range;

    public FireExplosion(EntityLivingBase user, int level) {
        super(user, cooldown + level * 3000);
        this.user = user;
        this.starttime = System.currentTimeMillis();
        if (level == 0) {
            this.chargeSpeed = 1500.0f;
            this.maxPower = 20.0f;
            this.minPower = 2.0f;
            this.range = 10;
        }
        if (level == 1) {
            this.chargeSpeed = 1000.0f;
            this.maxPower = 30.0f;
            this.minPower = 4.0f;
            this.range = 20;
        }
        if (level == 2) {
            this.chargeSpeed = 500.0f;
            this.maxPower = 40.0f;
            this.minPower = 6.0f;
            this.range = 40;
        }
        this.rand = new Random();
    }

    @Override
    public void update() {
        if (this.user.func_70093_af()) {
            BlockBukkit t = BlockBukkit.getTargetBlock(this.user);
            if (t.getLocation().distance((Entity)this.user) > (double)this.range) {
                this.destroy();
                return;
            }
            PacketSender.spawnParticle("smoke", this.user.field_70170_p, t.getX(), t.getY(), t.getZ(), 100, 40.0);
            return;
        }
        this.strike(System.currentTimeMillis() - this.starttime);
    }

    private void strike(long charge) {
        BlockBukkit t;
        float power = (float)charge / this.chargeSpeed;
        if (power > this.maxPower) {
            power = this.maxPower;
        }
        if (power < this.minPower) {
            power = this.minPower;
        }
        if ((t = BlockBukkit.getTargetBlock(this.user)).getLocation().distance((Entity)this.user) > (double)this.range) {
            this.destroy();
            return;
        }
        this.user.field_70170_p.func_72876_a(null, (double)t.getX(), (double)t.getY(), (double)t.getZ(), power, true);
        if (power > 32.0f) {
            for (int i = -10; i < 11; ++i) {
                for (int j = -20; j < 0; ++j) {
                    for (int k = -10; k < 11; ++k) {
                        Block blockType = this.user.field_70170_p.func_147439_a(t.getX() + i, t.getY() + j, t.getZ() + k);
                        Block above = this.user.field_70170_p.func_147439_a(t.getX() + i, t.getY() + j + 1, t.getZ() + k);
                        Block below = this.user.field_70170_p.func_147439_a(t.getX() + i, t.getY() + j - 1, t.getZ() + k);
                        if (blockType == Blocks.field_150402_ci || above != Blocks.field_150350_a || below == Blocks.field_150350_a || below == Blocks.field_150402_ci || this.rand.nextInt(5) != 0) continue;
                        this.user.field_70170_p.func_147449_b(t.getX() + i, t.getY() + j, t.getZ() + k, Blocks.field_150402_ci);
                        if (this.rand.nextInt(7) >= 2) continue;
                        this.user.field_70170_p.func_147449_b(t.getX() + i, t.getY() + j + 1, t.getZ() + k, (Block)Blocks.field_150480_ab);
                    }
                }
            }
        }
        this.destroy();
    }

    @Override
    public String getName() {
        return "Explosion";
    }
}

