/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;

public class EarthStream
extends AsynchronousAbility {
    private long interval = 200L;
    private long risetime = 600L;
    private ConcurrentHashMap<BlockBukkit, Long> movedBlocks = new ConcurrentHashMap();
    private Location origin;
    private Location location;
    private Vector direction;
    private int range;
    private long time = System.currentTimeMillis();
    private boolean finished = false;

    public EarthStream(EntityLivingBase user, Location location, Vector direction, int range) {
        super(user, 2000L);
        this.range = range;
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        this.direction.setY(0);
        this.direction.normalize();
        this.location.add(this.direction);
    }

    @Override
    public void update() {
        for (BlockBukkit block : this.movedBlocks.keySet()) {
            long time = this.movedBlocks.get(block);
            if (System.currentTimeMillis() <= time + this.risetime) continue;
            block.getRelative(BlockBukkit.UP).setType(Blocks.field_150350_a);
            this.movedBlocks.remove(block);
        }
        if (this.finished) {
            if (this.movedBlocks.isEmpty()) {
                this.destroy();
            } else {
                return;
            }
        }
        if (System.currentTimeMillis() - this.time >= this.interval) {
            this.time = System.currentTimeMillis();
            this.location.add(this.direction);
            if (this.location.distance(this.origin) > (double)this.range) {
                this.finished = true;
                return;
            }
            BlockBukkit block = this.location.getBlock();
            if (EarthStream.isMoveable(block)) {
                this.moveBlock(block);
            }
            if (EarthStream.isMoveable(block.getRelative(BlockBukkit.DOWN))) {
                this.moveBlock(block.getRelative(BlockBukkit.DOWN));
                this.location = block.getRelative(BlockBukkit.DOWN).getLocation();
                return;
            }
            if (EarthStream.isMoveable(block.getRelative(BlockBukkit.UP))) {
                this.moveBlock(block.getRelative(BlockBukkit.UP));
                this.location = block.getRelative(BlockBukkit.UP).getLocation();
                return;
            }
            this.finished = true;
            return;
        }
    }

    public void moveBlock(BlockBukkit block) {
        block.getRelative(BlockBukkit.UP).setType(Blocks.field_150346_d);
        this.movedBlocks.put(block, System.currentTimeMillis());
    }

    public void damageEntities(Location loc) {
        for (Object o : loc.getWorld().func_72910_y()) {
            EntityLivingBase e;
            if (!(o instanceof EntityLivingBase) || !(loc.distance((Entity)(e = (EntityLivingBase)o)) < 3.5)) continue;
            e.func_70097_a((DamageSource)AvatarDamageSource.earthbending, 3.0f);
        }
    }

    public static boolean isMoveable(BlockBukkit block) {
        Block[] overwriteable = new Block[]{Blocks.field_150350_a, Blocks.field_150345_g, Blocks.field_150329_H, Blocks.field_150330_I, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150480_ab, Blocks.field_150433_aE, Blocks.field_150478_aa, Blocks.field_150362_t, Blocks.field_150434_aF, Blocks.field_150436_aH, Blocks.field_150321_G, Blocks.field_150392_bi, Blocks.field_150395_bd};
        if (!Arrays.asList(overwriteable).contains(block.getRelative(BlockBukkit.UP).getType())) {
            return false;
        }
        Block[] moveable = new Block[]{Blocks.field_150336_V, Blocks.field_150435_aG, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150341_Y, Blocks.field_150391_bh, Blocks.field_150385_bj, Blocks.field_150424_aL, Blocks.field_150343_Z, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150348_b};
        return Arrays.asList(moveable).contains(block.getType());
    }

    @Override
    public String getName() {
        return "Earth Stream";
    }
}

