/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;

public class EarthBuildTower
extends AsynchronousAbility {
    private Location location;
    private int height;
    private long time;
    private int iteration;
    private Block blockType;
    private int metadata;

    public EarthBuildTower(EntityLivingBase e, Location l, int height) {
        super(e, 50000L);
        this.location = l;
        this.height = height;
        this.time = System.currentTimeMillis();
        this.iteration = -1;
        Block m = this.location.getBlock().getRelative(BlockBukkit.DOWN).getType();
        if (BendingUtils.isEarthBendable(m)) {
            this.blockType = Blocks.field_150348_b;
        }
        if (m == Blocks.field_150346_d || m == Blocks.field_150349_c) {
            this.blockType = Blocks.field_150346_d;
        }
        if (m == Blocks.field_150354_m || m == Blocks.field_150322_A) {
            this.blockType = Blocks.field_150322_A;
        }
        if (m == Blocks.field_150406_ce || m == Blocks.field_150405_ch || m == Blocks.field_150435_aG || m == Blocks.field_150351_n) {
            this.blockType = m;
            Location loc2 = this.location.getBlock().getRelative(BlockBukkit.DOWN).getLocation();
            this.metadata = loc2.getWorld().func_72805_g(loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ());
        }
    }

    @Override
    public void update() {
        if (this.iteration > this.height || this.blockType == null) {
            this.destroy();
            return;
        }
        if (System.currentTimeMillis() > this.time + 500L) {
            BlockBukkit b;
            this.time = System.currentTimeMillis();
            ++this.iteration;
            if (this.iteration == 0) {
                b = this.location.getBlock().getRelative(BlockBukkit.DOWN);
                PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, b.getX(), b.getY(), b.getZ(), 150, 1.0);
                b.setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.NORTH).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.WEST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.EAST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.SOUTH).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.NORTH).getRelative(BlockBukkit.EAST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.NORTH).getRelative(BlockBukkit.WEST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.SOUTH).getRelative(BlockBukkit.EAST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.SOUTH).getRelative(BlockBukkit.WEST).setType(this.blockType).setMetadata(this.metadata);
            }
            if (this.iteration > 0 && this.iteration < this.height && this.iteration != 1 && this.iteration != 2) {
                b = this.location.getBlock().getRelative(BlockBukkit.UP, this.iteration - 1);
                PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, b.getX(), b.getY(), b.getZ(), 150, 1.0);
                b.getRelative(BlockBukkit.NORTH).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.WEST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.EAST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.SOUTH).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.NORTH).getRelative(BlockBukkit.EAST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.NORTH).getRelative(BlockBukkit.WEST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.SOUTH).getRelative(BlockBukkit.EAST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.SOUTH).getRelative(BlockBukkit.WEST).setType(this.blockType).setMetadata(this.metadata);
            }
            if (this.iteration == this.height || this.iteration == 1 || this.iteration == 2) {
                b = this.location.getBlock().getRelative(BlockBukkit.UP, this.iteration - 1);
                PacketSender.spawnParticle("Avatar_dig", this.user.field_70170_p, b.getX(), b.getY(), b.getZ(), 150, 1.0);
                b.getRelative(BlockBukkit.NORTH).getRelative(BlockBukkit.EAST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.NORTH).getRelative(BlockBukkit.WEST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.SOUTH).getRelative(BlockBukkit.EAST).setType(this.blockType).setMetadata(this.metadata);
                b.getRelative(BlockBukkit.SOUTH).getRelative(BlockBukkit.WEST).setType(this.blockType).setMetadata(this.metadata);
            }
        }
    }

    @Override
    public String getName() {
        return "Earth Build Tower";
    }
}

