package mods.immibis.autofood;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import mods.immibis.core.api.util.BaseGuiContainer;

public class AutoFeederGui extends BaseGuiContainer<AutoFeederContainer> {

	public AutoFeederGui(AutoFeederContainer container) {
		super(container, 176, 166, new ResourceLocation("autofood", "textures/gui/autofeeder.png"));
	}
	
	public void drawCenteredStringWithoutShadow(String str, int x, int y) {
		int w = fontRendererObj.getStringWidth(str);
		fontRendererObj.drawString(str, guiLeft+x-w/2, guiTop+y, 0x404040);
	}
	
	@Override
	protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
		super.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
		
		drawCenteredStringWithoutShadow(I18n.format("gui.immibis.autofood.autofeeder"), 88, 8);
		
		int area = 2*container.getRange() + 1;
		drawCenteredStringWithoutShadow(I18n.format("gui.immibis.autofood.area", area), 88, 55);
	}

}
