package mods.immibis.autofood;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import mods.immibis.cobaltite.AssignedBlock;
import mods.immibis.cobaltite.CobaltiteMod;
import mods.immibis.cobaltite.ModBase;
import mods.immibis.cobaltite.TileGUI;
import mods.immibis.cobaltite.CobaltiteMod.RegisteredTile;
import mods.immibis.core.api.FMLModInfo;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(modid="AutoFood", name="AutoFood", version="58.1.1", dependencies="required-after:ImmibisCore")
@CobaltiteMod(channel="AutoFood", tiles={
	@RegisteredTile(id="immibis.autofood.autofeeder", tile=AutoFeederTile.class)
})
@FMLModInfo(
	url="http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/",
	description="Allows you to automatically feed yourself.",
	authors="immibis"
	)
public class AutoFood extends ModBase {
	
	@Instance("AutoFood")
	public static AutoFood INSTANCE;
	
	@AssignedBlock(id="machine", item=AutoFoodMachineItem.class)
	public static AutoFoodMachineBlock blockMachine;
	
	@TileGUI(container=AutoFeederContainer.class, gui=AutoFeederGui.class)
	public static int GUI_AUTOFEEDER = 0;
	
	
	@Override
	protected void addRecipes() throws Exception {
		GameRegistry.addRecipe(new ItemStack(blockMachine, 1, 0),
			"III",
			"IBI",
			"III",
			'I', Items.iron_ingot,
			'B', Items.bread
			);
	}
	
	
	
	@EventHandler public void base_preinit(FMLPreInitializationEvent evt) {super._preinit(evt);}
	@EventHandler public void base_init(FMLInitializationEvent evt) {super._init(evt);}
}
